/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.common.persistence;

import java.util.Collections;
import java.util.Map;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.jpa.spi.IdentifierGeneratorStrategyProvider;

public class HibernateCustomIdentifierGeneratorStrategyProvider
implements IdentifierGeneratorStrategyProvider {
    private static final Log LOG = ExoLogger.getLogger(HibernateCustomIdentifierGeneratorStrategyProvider.class);
    private static final boolean IS_MYSQL = Boolean.parseBoolean(System.getProperty("io.meeds.hibernate.legacy_mysql_sequence_generator", "true"));

    public Map<String, Class<?>> getStrategies() {
        if (this.isMySQLDriver()) {
            if (PropertyManager.isDevelopping()) {
                LOG.info((Object)"Using Old Strategy generator. This might be deleted by hibernate new versions.");
            }
            return Collections.singletonMap(SequenceStyleGenerator.class.getName(), IdentityGenerator.class);
        }
        return Collections.singletonMap(SequenceStyleGenerator.class.getName(), SequenceStyleGenerator.class);
    }

    private boolean isMySQLDriver() {
        try {
            return IS_MYSQL && this.getClass().getClassLoader().loadClass("com.mysql.cj.jdbc.Driver") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

