/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.ext;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.activation.UnsupportedDataTypeException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;

public class UIExtension
implements Comparable<UIExtension> {
    private static final Log LOG = ExoLogger.getLogger(UIExtension.class);
    private boolean enable = true;
    private String type;
    private String name;
    private String category;
    private int rank;
    private List<UIExtensionFilter> extendedFilters;
    private String component;
    private Class<? extends UIComponent> componentClass;
    private List<UIExtensionFilter> componentFilters;
    private boolean componentFiltersInitialized;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public List<UIExtensionFilter> getExtendedFilters() {
        return this.extendedFilters;
    }

    public void setExtendedFilters(List<UIExtensionFilter> extendedFilters) {
        this.extendedFilters = extendedFilters;
    }

    public Class<? extends UIComponent> getComponent() {
        if (this.componentClass == null) {
            try {
                this.componentClass = Class.forName(this.component, false, Thread.currentThread().getContextClassLoader()).asSubclass(UIComponent.class);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("The class of the extension component cannot be found", e);
            }
        }
        return this.componentClass;
    }

    public void setComponent(Class<? extends UIComponent> componentClass) {
        this.componentClass = componentClass;
    }

    public void setComponent(String component) {
        this.component = component;
        this.componentClass = null;
        this.componentFiltersInitialized = false;
        this.componentFilters = null;
        this.enable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UIExtensionFilter> getComponentFilters() {
        if (!this.componentFiltersInitialized) {
            try {
                block15: for (Class<? extends UIComponent> currentClass = this.getComponent(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                    for (Method m : currentClass.getDeclaredMethods()) {
                        if (!m.isAnnotationPresent(UIExtensionFilters.class)) continue;
                        this.checkMethodReturnType(m);
                        List filters = (List)m.invoke((Object)this.getComponent().newInstance(), (Object[])null);
                        if (filters == null) continue block15;
                        this.componentFilters = Collections.unmodifiableList(filters);
                        continue block15;
                    }
                }
            }
            catch (SecurityException e) {
                this.enable = false;
                LOG.error((Object)"The internal filters of the component cannot be initialized", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                this.enable = false;
                LOG.error((Object)"The internal filters of the component cannot be initialized", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.enable = false;
                LOG.error((Object)"The internal filters of the component cannot be initialized", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.enable = false;
                LOG.error((Object)"The internal filters of the component cannot be initialized", (Throwable)e);
            }
            catch (InstantiationException e) {
                this.enable = false;
                LOG.error((Object)"The internal filters of the component cannot be initialized", (Throwable)e);
            }
            catch (UnsupportedDataTypeException e) {
                this.enable = false;
                LOG.error((Object)"The internal filters of the component cannot be initialized", (Throwable)e);
            }
            finally {
                this.componentFiltersInitialized = true;
            }
        }
        return this.componentFilters;
    }

    private void checkMethodReturnType(Method m) throws UnsupportedDataTypeException {
        Type[] actualTypeArguments;
        ParameterizedType pReturnType;
        Type rawType;
        Type returnType = m.getGenericReturnType();
        if (returnType instanceof ParameterizedType && this.typeEquals(rawType = (pReturnType = (ParameterizedType)returnType).getRawType(), List.class) && (actualTypeArguments = pReturnType.getActualTypeArguments()) != null && actualTypeArguments.length == 1 && this.typeEquals(actualTypeArguments[0], UIExtensionFilter.class)) {
            return;
        }
        throw new UnsupportedDataTypeException(String.format("The expected type is a list of objects of type UIExtensionFilter. found: %s", returnType));
    }

    private boolean typeEquals(Type type, Class targetClass) {
        return type instanceof Class && ((Class)type).getName().equals(targetClass.getName());
    }

    public boolean isEnable() {
        return this.enable;
    }

    @Override
    public int compareTo(UIExtension extension) {
        int diff = 0;
        if (this.rank != 0 && extension.rank != 0) {
            diff = this.rank - extension.rank;
        } else {
            if (this.rank == 0 && extension.rank != 0) {
                return 1;
            }
            if (this.rank != 0 && extension.rank == 0) {
                return -1;
            }
        }
        if (diff == 0) {
            if (this.category != null && extension.category != null) {
                diff = this.category.compareTo(extension.category);
            } else {
                if (this.category == null && extension.category != null) {
                    return 1;
                }
                if (this.category != null && extension.category == null) {
                    return -1;
                }
            }
            if (diff == 0) {
                return this.name.compareTo(extension.name);
            }
        }
        return diff;
    }

    public boolean equals(Object o) {
        return o instanceof UIExtension && this.compareTo((UIExtension)o) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.category, this.rank);
    }
}

