/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.web.openid;

import io.meeds.oauth.exception.OAuthException;
import io.meeds.oauth.openid.OpenIdAccessTokenContext;
import io.meeds.oauth.openid.OpenIdProcessor;
import io.meeds.oauth.spi.OAuthPrincipal;
import io.meeds.oauth.spi.OAuthProviderTypeRegistry;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.gatein.sso.agent.filter.api.AbstractSSOInterceptor;

public class OpenIdAuthenticationFilter
extends AbstractSSOInterceptor {
    private static Log log = ExoLogger.getLogger(OpenIdAuthenticationFilter.class);
    private AuthenticationRegistry authenticationRegistry;
    private OpenIdProcessor openIdProcessor;
    private boolean openIdEnabled;

    protected void initImpl() {
        this.openIdEnabled = Boolean.parseBoolean(System.getProperty("exo.oauth.openid.enabled"));
        if (this.openIdEnabled) {
            this.authenticationRegistry = (AuthenticationRegistry)this.getExoContainer().getComponentInstanceOfType(AuthenticationRegistry.class);
            OAuthProviderTypeRegistry oAuthProviderTypeRegistry = (OAuthProviderTypeRegistry)this.getExoContainer().getComponentInstanceOfType(OAuthProviderTypeRegistry.class);
            this.openIdProcessor = (OpenIdProcessor)oAuthProviderTypeRegistry.getOAuthProvider("OPENID", OpenIdAccessTokenContext.class).getOauthProviderProcessor();
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.openIdEnabled || request.getRemoteUser() != null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        User oauthAuthenticatedUser = (User)this.authenticationRegistry.getAttributeOfClient(request, "_authenticatedPortalUser");
        if (oauthAuthenticatedUser != null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        User jaasAuthenticatedUser = (User)this.authenticationRegistry.getAttributeOfClient(request, "_authenticatedPortalUserForJaas");
        if (jaasAuthenticatedUser != null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        OAuthPrincipal principal = (OAuthPrincipal)this.authenticationRegistry.getAttributeOfClient(request, "_authenticatedOAuthPrincipal");
        if (principal != null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.checkAccessTokenInCookies(request, response);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void checkAccessTokenInCookies(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("OPENID_ACCESS_TOKEN")) continue;
                try {
                    this.saveInitialURI(request);
                    this.openIdProcessor.processOAuthInteraction(request, response);
                }
                catch (OAuthException | IOException | InterruptedException | ExecutionException ex) {
                    log.error((Object)("Error during OAuth flow with: " + ex.getMessage()), (Throwable)ex);
                    return;
                }
            }
        }
    }

    private void saveInitialURI(HttpServletRequest request) {
        String initialURI = request.getParameter("initialURI");
        if (initialURI != null) {
            request.getSession().setAttribute("_urlToRedirectAfterLinkSocialAccount", (Object)initialURI);
        }
    }
}

