/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin;

import com.fasterxml.jackson.core.type.TypeReference;
import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.layout.model.LayoutModel;
import io.meeds.layout.model.NavigationCreateModel;
import io.meeds.layout.model.NavigationUpdateModel;
import io.meeds.layout.model.NodeDefinition;
import io.meeds.layout.model.NodeLabel;
import io.meeds.layout.model.PortletInstanceContext;
import io.meeds.layout.model.SpaceNavigationDatabind;
import io.meeds.layout.plugin.SpaceNavigationDatabindPlugin$AjcClosure1;
import io.meeds.layout.service.NavigationLayoutService;
import io.meeds.layout.service.PageLayoutService;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.layout.util.JsonUtils;
import io.meeds.social.databind.model.DatabindReport;
import io.meeds.social.databind.plugin.DatabindPlugin;
import io.meeds.social.databind.service.DatabindService;
import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.service.SpaceTemplateService;
import io.meeds.social.translation.service.TranslationService;
import jakarta.annotation.PostConstruct;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.DescriptionService;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpaceNavigationDatabindPlugin
implements DatabindPlugin {
    private static final Log LOG;
    public static final String OBJECT_TYPE = "SpaceNavigation";
    public static final String NAVIGATION_JSON = "navigation.json";
    public static final String CONFIG_JSON = "config.json";
    @Autowired
    protected DatabindService databindService;
    @Autowired
    protected FileService fileService;
    @Autowired
    protected TranslationService translationService;
    @Autowired
    protected SpaceTemplateService spaceTemplateService;
    @Autowired
    protected AttachmentService attachmentService;
    @Autowired
    LayoutService layoutService;
    @Autowired
    private NavigationService navigationService;
    @Autowired
    DescriptionService descriptionService;
    @Autowired
    private NavigationLayoutService navigationLayoutService;
    @Autowired
    private PageLayoutService pageLayoutService;
    @Autowired
    PortletInstanceService portletInstanceService;
    @Autowired
    protected UserACL userAcl;
    @Autowired
    protected IdentityManager identityManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        this.databindService.addPlugin((DatabindPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean canHandleDatabind(String objectType, String objectId) {
        return StringUtils.equals((CharSequence)"SpaceTemplate", (CharSequence)objectType);
    }

    public void serialize(String objectId, ZipOutputStream zipOutputStream, String username) {
        SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplate(Long.parseLong(objectId), username, Locale.getDefault(), true);
        SiteKey siteKey = SiteKey.groupTemplate((String)spaceTemplate.getLayout());
        String folderPath = String.valueOf(siteKey.getType()) + "-" + siteKey.getName();
        List pageContexts = this.layoutService.findPages(siteKey);
        List<Object> pages = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageContexts)) {
            pages = pageContexts.stream().map(this::toPage).toList();
        }
        List<NodeDefinition> nodeDefinitions = this.buildNodeDefinitions(siteKey, username);
        String navigationJsonData = JsonUtils.toJsonString(nodeDefinitions);
        for (Page page : pages) {
            try {
                LayoutModel layoutModel = new LayoutModel((ModelObject)page, this.portletInstanceService, new PortletInstanceContext(true, null));
                layoutModel.resetStorage();
                String pageJson = JsonUtils.toJsonString(layoutModel);
                this.writeToZip(zipOutputStream, folderPath + "/pages/" + page.getName() + ".json", pageJson);
            }
            catch (Exception e) {
                LOG.warn((Object)("Error processing page " + page.getName() + ": " + e.getMessage()));
            }
        }
        this.writeToZip(zipOutputStream, folderPath + "/navigation.json", navigationJsonData);
    }

    public CompletableFuture<Pair<DatabindReport, File>> deserialize(File zipFile, Map<String, String> params, String username) {
        return CompletableFuture.supplyAsync(() -> this.importSpaceTemplates(zipFile, username)).thenApply(processedTemplates -> {
            DatabindReport report = new DatabindReport();
            report.setSuccess(!processedTemplates.isEmpty());
            report.setProcessedItems(processedTemplates);
            return Pair.of((Object)report, (Object)zipFile);
        });
    }

    @ContainerTransactional
    public List<String> importSpaceTemplates(File zipFile, String username) {
        File file = zipFile;
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)file, (Object)string);
        Object[] objectArray = new Object[]{this, file, string, joinPoint};
        SpaceNavigationDatabindPlugin$AjcClosure1 spaceNavigationDatabindPlugin$AjcClosure1 = new SpaceNavigationDatabindPlugin$AjcClosure1(objectArray);
        return (List)ContainerTransactionalAspect.aspectOf().around(spaceNavigationDatabindPlugin$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private Map<String, SpaceNavigationDatabind> extractTemplates(File zipFile) {
        HashMap<String, SpaceNavigationDatabind> templateDatabindMap = new HashMap<String, SpaceNavigationDatabind>();
        try (ZipInputStream zis = new ZipInputStream((InputStream)new FileInputStream(zipFile), StandardCharsets.UTF_8);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                LayoutModel page;
                SpaceNavigationDatabind databind;
                String key;
                int bytesRead;
                if (entry.isDirectory()) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = zis.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                String jsonContent = baos.toString(StandardCharsets.UTF_8);
                String entryName = entry.getName();
                if (entryName.endsWith(CONFIG_JSON)) {
                    SpaceNavigationDatabind databindFromJson = JsonUtils.fromJsonString(jsonContent, SpaceNavigationDatabind.class);
                    if (databindFromJson == null) continue;
                    key = entryName.substring(0, entryName.lastIndexOf(47));
                    templateDatabindMap.put(key, databindFromJson);
                    continue;
                }
                if (entryName.endsWith(NAVIGATION_JSON)) {
                    List<NodeDefinition> nodeDefinitions = JsonUtils.fromJsonString(jsonContent, new TypeReference<List<NodeDefinition>>(this){});
                    if (nodeDefinitions == null) continue;
                    key = entryName.substring(0, entryName.lastIndexOf(47));
                    databind = templateDatabindMap.computeIfAbsent(key, k -> {
                        SpaceNavigationDatabind st = new SpaceNavigationDatabind();
                        st.setPages(new ArrayList<LayoutModel>());
                        return st;
                    });
                    databind.setNodeDefinitions(nodeDefinitions);
                    continue;
                }
                if (!entryName.matches(".+/pages/.+\\.json$") || (page = JsonUtils.fromJsonString(jsonContent, LayoutModel.class)) == null) continue;
                key = entryName.substring(0, entryName.indexOf("/pages/"));
                databind = templateDatabindMap.computeIfAbsent(key, k -> {
                    SpaceNavigationDatabind st = new SpaceNavigationDatabind();
                    st.setPages(new ArrayList<LayoutModel>());
                    return st;
                });
                if (databind.getPages() == null) {
                    databind.setPages(new ArrayList<LayoutModel>());
                }
                databind.getPages().add(page);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading zip file", e);
        }
        return templateDatabindMap;
    }

    private void processSpaceTemplate(SpaceNavigationDatabind spaceTemplateDatabind, String username) {
        if (spaceTemplateDatabind.getSpaceTemplateId() == null) {
            return;
        }
        SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplate(Long.parseLong(spaceTemplateDatabind.getSpaceTemplateId()));
        SiteKey siteKey = SiteKey.groupTemplate((String)spaceTemplate.getLayout());
        if (CollectionUtils.isNotEmpty(spaceTemplateDatabind.getPages())) {
            for (LayoutModel layoutModel : spaceTemplateDatabind.getPages()) {
                Page page = layoutModel.toPage();
                page.setOwnerType(layoutModel.getOwnerType());
                page.setOwnerId(spaceTemplateDatabind.getSpaceTemplateId());
                page.setName(layoutModel.getName());
                page.setType(layoutModel.getType());
                page.setEditPermission(layoutModel.getEditPermission());
                page.setAccessPermissions(layoutModel.getAccessPermissions());
                page.setLink(layoutModel.getLink());
                page.setShowMaxWindow(Boolean.valueOf(false));
                page.setHideSharedLayout(false);
                if (page.getPageKey() == null) continue;
                this.layoutService.save(new PageContext(new PageKey(siteKey, page.getName()), Utils.toPageState((Page)page)));
                this.pageLayoutService.updatePageLayout(page.getPageKey().format(), page, true, username);
            }
        }
        NodeContext parentNode = this.navigationService.loadNode(siteKey);
        List<NodeDefinition> nodeDefinitions = spaceTemplateDatabind.getNodeDefinitions();
        if (CollectionUtils.isNotEmpty(nodeDefinitions)) {
            NodeDefinition targetParentNode = nodeDefinitions.getFirst();
            NavigationUpdateModel navigationUpdateModel = new NavigationUpdateModel();
            navigationUpdateModel.setNodeLabel(targetParentNode.getName());
            navigationUpdateModel.setPageRef(this.getPageKey(siteKey, targetParentNode));
            navigationUpdateModel.setVisible(targetParentNode.getVisibility().equals((Object)Visibility.DISPLAYED));
            navigationUpdateModel.setScheduled(false);
            navigationUpdateModel.setIcon(targetParentNode.getIcon());
            targetParentNode.setLabels(targetParentNode.getLabels());
            this.navigationLayoutService.updateNode(Long.parseLong(parentNode.getId()), navigationUpdateModel, username);
            parentNode.getNodes().forEach(node -> this.navigationLayoutService.deleteNode(Long.parseLong(node.getId())));
            this.createNodesRecursively(nodeDefinitions, parentNode.getId(), siteKey, username);
        }
    }

    private List<NodeDefinition> buildNodeDefinitions(SiteKey siteKey, String username) {
        NavigationContext navigationContext = this.navigationService.loadNavigation(siteKey);
        NodeContext rootNode = this.navigationService.loadNode(NodeModel.SELF_MODEL, navigationContext, Scope.ALL, null);
        if (rootNode == null || rootNode.getNodeCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<NodeDefinition> nodeDefinitions = new ArrayList<NodeDefinition>();
        Collection<NodeContext<?>> children = this.getChildren(rootNode);
        for (NodeContext<?> child : children) {
            nodeDefinitions.add(this.buildNodeDefinitionRecursively(child, username));
        }
        return nodeDefinitions;
    }

    private NodeDefinition buildNodeDefinitionRecursively(NodeContext<?> nodeContext, String username) {
        NodeState state = nodeContext.getData().getState();
        NodeDefinition def = new NodeDefinition();
        def.setName(nodeContext.getName());
        def.setIcon(state.getIcon());
        def.setVisibility(state.getVisibility());
        def.setPageReference(state.getPageRef() != null ? state.getPageRef().format() : null);
        NodeLabel nodeLabel = this.navigationLayoutService.getNodeLabels(Long.parseLong(nodeContext.getId()), username);
        def.setLabels(nodeLabel.getLabels());
        Collection<NodeContext<?>> children = this.getChildren(nodeContext);
        for (NodeContext<?> child : children) {
            def.getChildren().add(this.buildNodeDefinitionRecursively(child, username));
        }
        return def;
    }

    private Collection<NodeContext<?>> getChildren(NodeContext<?> node) {
        Collection rawNodes = node.getNodes();
        if (rawNodes == null) {
            return Collections.emptyList();
        }
        return rawNodes;
    }

    private Page toPage(PageContext pageContext) {
        Page page = this.layoutService.getPage(pageContext.getKey());
        page.resetStorage();
        return page;
    }

    private void writeToZip(ZipOutputStream zipOutputStream, String filePath, String content) throws IOException {
        ZipEntry entry = new ZipEntry(filePath);
        zipOutputStream.putNextEntry(entry);
        zipOutputStream.write(content.getBytes(StandardCharsets.UTF_8));
        zipOutputStream.closeEntry();
    }

    private void createNodesRecursively(List<NodeDefinition> nodeDefinitions, String parentId, SiteKey siteKey, String username) {
        String previousNodeId = null;
        for (NodeDefinition nodeDefinition : nodeDefinitions) {
            NavigationCreateModel model = new NavigationCreateModel(parentId != null ? Long.valueOf(Long.parseLong(parentId)) : null, previousNodeId != null ? Long.valueOf(Long.parseLong(previousNodeId)) : null, nodeDefinition.getName(), nodeDefinition.getName(), nodeDefinition.getVisibility().equals((Object)Visibility.DISPLAYED), false, false, null, null, this.getPageKey(siteKey, nodeDefinition), null, false, nodeDefinition.getIcon(), nodeDefinition.getLabels());
            NodeData nodeData = null;
            if (!StringUtils.contains((CharSequence)nodeDefinition.getName(), (CharSequence)"_draft_")) {
                nodeData = this.navigationLayoutService.createNode(model, username);
            }
            String string = previousNodeId = nodeData != null ? nodeData.getId() : null;
            List<NodeDefinition> children = nodeDefinition.getChildren();
            if (children == null || children.isEmpty()) continue;
            this.createNodesRecursively(children, nodeData != null ? nodeData.getId() : null, siteKey, username);
        }
    }

    private String getPageKey(SiteKey siteKey, NodeDefinition nodeDefinition) {
        int lastIndex;
        String pageRef = nodeDefinition.getPageReference();
        String pageName = StringUtils.isNotBlank((CharSequence)pageRef) ? ((lastIndex = pageRef.lastIndexOf("::")) != -1 ? pageRef.substring(lastIndex + 2) : pageRef) : nodeDefinition.getName();
        PageKey pageKey = new PageKey(siteKey, pageName);
        String formattedKey = pageKey.format();
        if (StringUtils.isBlank((CharSequence)formattedKey)) {
            return null;
        }
        PageContext pageContext = this.layoutService.getPageContext(PageKey.parse((String)formattedKey));
        return pageContext != null ? pageContext.getKey().format() : null;
    }

    static {
        SpaceNavigationDatabindPlugin.ajc$preClinit();
        LOG = ExoLogger.getLogger(SpaceNavigationDatabindPlugin.class);
    }

    static final /* synthetic */ List importSpaceTemplates_aroundBody0(SpaceNavigationDatabindPlugin ajc$this, File zipFile, String username, JoinPoint joinPoint) {
        Map<String, SpaceNavigationDatabind> instances = ajc$this.extractTemplates(zipFile);
        ArrayList<String> processedSpaceTemplates = new ArrayList<String>();
        for (Map.Entry<String, SpaceNavigationDatabind> entry : instances.entrySet()) {
            SpaceNavigationDatabind spaceTemplate = entry.getValue();
            ajc$this.processSpaceTemplate(spaceTemplate, username);
            processedSpaceTemplates.add(spaceTemplate.getLayout());
        }
        return processedSpaceTemplates;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpaceNavigationDatabindPlugin.java", SpaceNavigationDatabindPlugin.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importSpaceTemplates", "io.meeds.layout.plugin.SpaceNavigationDatabindPlugin", "java.io.File:java.lang.String", "zipFile:username", "", "java.util.List"), 182);
    }
}

