/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.HashSet;
import lombok.Generated;

public class NewPortalConfig
implements Cloneable {
    private HashSet<String> predefinedOwner = new HashSet();
    private String ownerType;
    private String templateName;
    private String location;
    private String label;
    private String description;
    private String importMode;
    private Object override;
    private boolean useMetaPortalLayout = false;
    @Deprecated
    private String templateLocation;

    public NewPortalConfig() {
    }

    public NewPortalConfig(NewPortalConfig cfg) {
        this.ownerType = cfg.ownerType;
        this.templateLocation = cfg.templateLocation;
        this.location = cfg.location;
        this.label = cfg.label;
        this.description = cfg.description;
        this.templateName = cfg.templateName;
        this.predefinedOwner = new HashSet<String>(cfg.predefinedOwner);
        this.importMode = cfg.importMode;
        this.override = cfg.override;
        this.useMetaPortalLayout = cfg.useMetaPortalLayout;
    }

    public NewPortalConfig(String path) {
        this.location = path;
    }

    public HashSet<String> getPredefinedOwner() {
        return this.predefinedOwner;
    }

    public void setPredefinedOwner(HashSet<String> s) {
        this.predefinedOwner = s;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getTemplateLocation() {
        if (this.location != null) {
            return this.location;
        }
        return this.templateLocation;
    }

    public void setTemplateLocation(String s) {
        this.location = s;
        this.templateLocation = s;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String s) {
        this.templateName = s;
    }

    public boolean isPredefinedOwner(String user) {
        return this.predefinedOwner.contains(user);
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getImportMode() {
        return this.importMode;
    }

    public void setImportMode(String importMode) {
        this.importMode = importMode;
    }

    public Boolean getOverrideMode() {
        if (this.override != null) {
            return this.override instanceof String ? "true".equals((String)this.override) : ((Boolean)this.override).booleanValue();
        }
        return null;
    }

    public void setOverrideMode(boolean overrideMode) {
        this.override = overrideMode;
    }

    public void setUseMetaPortalLayout(boolean useMetaPortalLayout) {
        this.useMetaPortalLayout = useMetaPortalLayout;
    }

    public boolean isUseMetaPortalLayout() {
        return this.useMetaPortalLayout;
    }

    @Deprecated(forRemoval=true, since="1.5.0")
    public void setUseDefaultPortalLayout(boolean useMetaPortalLayout) {
        this.useMetaPortalLayout = useMetaPortalLayout;
    }

    @Deprecated(forRemoval=true, since="1.5.0")
    public boolean isUseDefaultPortalLayout() {
        return this.useMetaPortalLayout;
    }

    protected NewPortalConfig clone() {
        return new NewPortalConfig(this);
    }

    @Generated
    public String toString() {
        return "NewPortalConfig(predefinedOwner=" + String.valueOf(this.getPredefinedOwner()) + ", ownerType=" + this.getOwnerType() + ", templateName=" + this.getTemplateName() + ", location=" + this.getLocation() + ", label=" + this.getLabel() + ", description=" + this.getDescription() + ", importMode=" + this.getImportMode() + ", override=" + String.valueOf(this.override) + ", useMetaPortalLayout=" + this.isUseMetaPortalLayout() + ", templateLocation=" + this.getTemplateLocation() + ")";
    }
}

