/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.GenericContainerResponse;

public class ByteArrayContainerResponseWriter
implements ContainerResponseWriter {
    private byte[] body;
    private MultivaluedMap<String, Object> headers;

    @Override
    public void writeBody(GenericContainerResponse response, MessageBodyWriter entityWriter) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Object entity = response.getEntity();
        if (entity != null) {
            entityWriter.writeTo(entity, entity.getClass(), response.getEntityType(), null, response.getContentType(), response.getHttpHeaders(), (OutputStream)out);
            this.body = out.toByteArray();
        }
    }

    @Override
    public void writeHeaders(GenericContainerResponse response) throws IOException {
        this.headers = response.getHttpHeaders();
    }

    public byte[] getBody() {
        return this.body;
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.headers;
    }

    public void reset() {
        this.body = null;
        this.headers = null;
    }
}

