/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.rest;

import io.meeds.wallet.model.InitialFundsSettings;
import io.meeds.wallet.model.UserSettings;
import io.meeds.wallet.service.WalletService;
import io.meeds.wallet.utils.WalletUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/settings")
@Tag(name="/wallet/api/settings", description="Manage wallet settings operations")
public class WalletSettingsREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(WalletSettingsREST.class);
    private WalletService walletService;

    public WalletSettingsREST(WalletService walletService) {
        this.walletService = walletService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves user settings by including space settings when added in parameters", method="GET", description="Retrieves user settings by including space settings when added in parameters")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getSettings(@Parameter(description="Space pretty name") @QueryParam(value="spaceId") String spaceId, @Parameter(description="Space pretty name") @QueryParam(value="administration") boolean isAdministration) {
        String currentUser = WalletUtils.getCurrentUserId();
        try {
            UserSettings userSettings = this.walletService.getUserSettings(spaceId, currentUser, isAdministration);
            return Response.ok((Object)userSettings).build();
        }
        catch (Exception e) {
            LOG.error("Error getting settings for user {} and spaceId {}", new Object[]{currentUser, spaceId, e});
            return Response.status((int)401).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="saveInitialFunds")
    @RolesAllowed(value={"rewarding"})
    @Operation(summary="Saves initial funds settings", method="POST", description="Saves initial funds settings and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveInitialFundsSettings(@Parameter(description="Initial funds settings", required=true) InitialFundsSettings initialFundsSettings) {
        if (initialFundsSettings == null) {
            LOG.warn((Object)"Bad request sent to server with empty settings");
            return Response.status((int)400).build();
        }
        try {
            this.walletService.saveInitialFundsSettings(initialFundsSettings);
            LOG.info("{} saved initialFunds settings details '{}'", new Object[]{WalletUtils.getCurrentUserId(), initialFundsSettings.toString()});
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error saving global settings", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

