/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.listener;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.metadata.tag.model.TagObject;
import org.exoplatform.wiki.model.Page;

public class NotesMetadataListener
extends Listener<String, Page> {
    private final IdentityManager identityManager;
    private final SpaceService spaceService;
    private final TagService tagService;
    private final UserACL userACL;
    private static final String NOTES_METADATA_OBJECT_TYPE = "notes";

    public NotesMetadataListener(IdentityManager identityManager, SpaceService spaceService, TagService tagService, UserACL userACL) {
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.tagService = tagService;
        this.userACL = userACL;
    }

    public void onEvent(Event<String, Page> event) {
        Page note = (Page)event.getData();
        String username = (String)event.getSource();
        if (username == null) {
            username = note.getAuthor();
        }
        if (username == null) {
            username = this.userACL.getSuperUser();
        }
        long creatorId = this.getPosterId(username);
        long audienceId = this.getStreamOwnerId(note.getWikiOwner(), username);
        Set tagNames = this.tagService.detectTagNames(note.getContent());
        this.tagService.saveTags(new TagObject(NOTES_METADATA_OBJECT_TYPE, note.getId(), note.getParentPageId()), tagNames, audienceId, creatorId);
    }

    private long getStreamOwnerId(String spaceGroupId, String username) {
        Space space = this.spaceService.getSpaceByGroupId(spaceGroupId);
        return space == null ? this.getPosterId(username) : Long.parseLong(this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()).getId());
    }

    private long getPosterId(String username) {
        return StringUtils.isBlank((CharSequence)username) ? 0L : Long.parseLong(this.identityManager.getOrCreateUserIdentity(username).getId());
    }
}

