/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.service;

import io.meeds.social.search.SpaceSearchConnector;
import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.service.SpaceTemplateService;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.common.lifecycle.LifeCycleListener;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.storage.SpaceStorage;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.BannerAttachment;
import org.exoplatform.social.core.model.SpaceExternalInvitation;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceLifecycle;
import org.exoplatform.social.core.space.SpaceListAccess;
import org.exoplatform.social.core.space.SpaceListAccessType;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleListener;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.GroupSpaceBindingStorage;
import org.exoplatform.web.security.security.RemindPasswordTokenService;

public class SpaceServiceImpl
implements SpaceService {
    private static final Log LOG = ExoLogger.getLogger(SpaceServiceImpl.class);
    private static final int MAX_SPACE_NAME_LENGTH = 200;
    private SpaceStorage spaceStorage;
    private SpaceSearchConnector spaceSearchConnector;
    private GroupSpaceBindingStorage groupSpaceBindingStorage;
    private IdentityManager identityManager;
    private UserACL userAcl;
    private ResourceBundleService resourceBundleService;
    private LocaleConfigService localeConfigService;
    private OrganizationService organizationService;
    private SpaceTemplateService spaceTemplateService;
    private FileService fileService;
    private SpaceLifecycle spaceLifeCycle = new SpaceLifecycle();

    public SpaceServiceImpl(SpaceStorage spaceStorage, GroupSpaceBindingStorage groupSpaceBindingStorage, SpaceSearchConnector spaceSearchConnector, IdentityManager identityManager, UserACL userAcl, ResourceBundleService resourceBundleService, LocaleConfigService localeConfigService, FileService fileService) {
        this.spaceStorage = spaceStorage;
        this.groupSpaceBindingStorage = groupSpaceBindingStorage;
        this.spaceSearchConnector = spaceSearchConnector;
        this.identityManager = identityManager;
        this.userAcl = userAcl;
        this.resourceBundleService = resourceBundleService;
        this.localeConfigService = localeConfigService;
        this.fileService = fileService;
    }

    public Space getSpaceByPrettyName(String spacePrettyName) {
        return this.spaceStorage.getSpaceByPrettyName(spacePrettyName);
    }

    public Instant getSpaceMembershipDate(long spaceId, String username) {
        return this.spaceStorage.getSpaceMembershipDate(spaceId, username);
    }

    public Space getSpaceByGroupId(String groupId) {
        return this.spaceStorage.getSpaceByGroupId(groupId);
    }

    public Space getSpaceById(long spaceId) {
        return this.spaceStorage.getSpaceById(spaceId);
    }

    public ListAccess<Space> getAccessibleSpacesWithListAccess(String username) {
        return this.getAccessibleSpacesByFilter(username, new SpaceFilter());
    }

    public ListAccess<Space> getAccessibleSpacesByFilter(String username, SpaceFilter spaceFilter) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return new ListAccessImpl(Space.class, Collections.emptyList());
        }
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, this.getSpaceTemplateService(), username, spaceFilter, SpaceListAccessType.ACCESSIBLE_FILTER);
    }

    public ListAccess<Space> getVisibleSpacesWithListAccess(String username, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, this.getSpaceTemplateService(), username, spaceFilter, SpaceListAccessType.VISIBLE);
    }

    public ListAccess<Space> getPendingSpacesWithListAccess(String username) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return new ListAccessImpl(Space.class, Collections.emptyList());
        }
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, username, SpaceListAccessType.PENDING);
    }

    public ListAccess<Space> getAllSpacesWithListAccess() {
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, SpaceListAccessType.ALL);
    }

    public ListAccess<Space> getAllSpacesByFilter(SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, this.getSpaceTemplateService(), spaceFilter, SpaceListAccessType.ALL_FILTER);
    }

    public ListAccess<Space> getInvitedSpacesWithListAccess(String username) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return new ListAccessImpl(Space.class, Collections.emptyList());
        }
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, username, SpaceListAccessType.INVITED);
    }

    public ListAccess<Space> getInvitedSpacesByFilter(String username, SpaceFilter spaceFilter) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return new ListAccessImpl(Space.class, Collections.emptyList());
        }
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, username, spaceFilter, SpaceListAccessType.INVITED_FILTER);
    }

    public ListAccess<Space> getMemberSpaces(String username) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return new ListAccessImpl(Space.class, Collections.emptyList());
        }
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, username, SpaceListAccessType.MEMBER);
    }

    public ListAccess<Space> getMemberSpacesByFilter(String username, SpaceFilter spaceFilter) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return new ListAccessImpl(Space.class, Collections.emptyList());
        }
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, username, spaceFilter, SpaceListAccessType.MEMBER_FILTER);
    }

    public ListAccess<Space> getManagerSpaces(String username) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return new ListAccessImpl(Space.class, Collections.emptyList());
        }
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, username, SpaceListAccessType.MANAGER);
    }

    public ListAccess<Space> getManagerSpacesByFilter(String username, SpaceFilter spaceFilter) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return new ListAccessImpl(Space.class, Collections.emptyList());
        }
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, username, spaceFilter, SpaceListAccessType.MANAGER_FILTER);
    }

    public ListAccess<Space> getEditableSpacesByFilter(String username, SpaceFilter spaceFilter) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return new ListAccessImpl(Space.class, Collections.emptyList());
        }
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, this.getSpaceTemplateService(), username, spaceFilter, SpaceListAccessType.MANAGER_FILTER);
    }

    public ListAccess<Space> getFavoriteSpacesByFilter(String username, SpaceFilter spaceFilter) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return new ListAccessImpl(Space.class, Collections.emptyList());
        }
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, this.getSpaceTemplateService(), username, spaceFilter, SpaceListAccessType.FAVORITE_FILTER);
    }

    public ListAccess<Space> getPendingSpacesByFilter(String username, SpaceFilter spaceFilter) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return new ListAccessImpl(Space.class, Collections.emptyList());
        }
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, username, spaceFilter, SpaceListAccessType.PENDING_FILTER);
    }

    public ListAccess<Space> getPendingSpaceRequestsToManage(String username) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return new ListAccessImpl(Space.class, Collections.emptyList());
        }
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, username, SpaceListAccessType.PENDING_REQUESTS);
    }

    public ListAccess<Space> getLastAccessedSpace(String username) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return new ListAccessImpl(Space.class, Collections.emptyList());
        }
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, username, SpaceListAccessType.LASTEST_ACCESSED);
    }

    public ListAccess<Space> getLastAccessedSpaceByFilter(String username, SpaceFilter spaceFilter) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return new ListAccessImpl(Space.class, Collections.emptyList());
        }
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, username, spaceFilter, SpaceListAccessType.LASTEST_ACCESSED);
    }

    public ListAccess<Space> getCommonSpaces(String username, String otherUserId) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return new ListAccessImpl(Space.class, Collections.emptyList());
        }
        return new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, SpaceListAccessType.COMMON, username, otherUserId);
    }

    public List<String> getMemberSpacesIds(String username, int offset, int limit) {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateUserIdentity(username);
        if (identity == null) {
            return Collections.emptyList();
        }
        return this.spaceStorage.getMemberRoleSpaceIds(identity.getId(), offset, limit);
    }

    public List<String> getManagerSpacesIds(String username, int offset, int limit) {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateUserIdentity(username);
        if (identity == null) {
            return Collections.emptyList();
        }
        return this.spaceStorage.getManagerRoleSpaceIds(identity.getId(), offset, limit);
    }

    public List<Space> getLastSpaces(int limit) {
        return this.spaceStorage.getLastSpaces(limit);
    }

    public Space createSpace(Space space, String username) {
        return this.createSpace(space, username, null);
    }

    public Space createSpace(Space space, String username, List<org.exoplatform.social.core.identity.model.Identity> identitiesToInvite) throws SpaceException {
        Space createdSpace;
        if (!this.getSpaceTemplateService().canCreateSpace(space.getTemplateId(), username)) {
            throw new SpaceException(SpaceException.Code.SPACE_PERMISSION);
        }
        Space spaceToCreate = new Space();
        spaceToCreate.setDisplayName(space.getDisplayName());
        spaceToCreate.setPrettyName(space.getPrettyName());
        spaceToCreate.setDescription(space.getDescription());
        spaceToCreate.setRegistration(space.getRegistration());
        spaceToCreate.setVisibility(space.getVisibility());
        spaceToCreate.setTemplateId(space.getTemplateId());
        spaceToCreate.setEditor(username);
        spaceToCreate.setMembers(new String[]{username});
        spaceToCreate.setManagers(new String[]{username});
        SpaceTemplate spaceTemplate = this.getSpaceTemplateService().getSpaceTemplate(spaceToCreate.getTemplateId());
        if (spaceTemplate == null || !spaceTemplate.isEnabled() || spaceTemplate.isDeleted()) {
            throw new SpaceException(SpaceException.Code.UNKNOWN_SPACE_TEMPLATE);
        }
        this.copySpaceTemplateProperties(spaceToCreate, spaceTemplate, username, this.getUsersToInvite(identitiesToInvite));
        this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.SPACE_CREATED);
        try {
            createdSpace = this.spaceStorage.saveSpace(spaceToCreate, true);
            space.setId(createdSpace.getId());
            this.spaceLifeCycle.spaceCreated(spaceToCreate, username);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, String.format("Failed to save the space %s", spaceToCreate.getPrettyName()), (Throwable)e);
        }
        finally {
            this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.SPACE_CREATED);
        }
        long bannerId = this.getSpaceTemplateService().getSpaceTemplateBannerId(spaceTemplate.getId());
        if (bannerId > 0L) {
            this.duplicateBannerById(createdSpace, bannerId, username);
        }
        try {
            createdSpace.setEditor(username);
            this.inviteIdentities(createdSpace, identitiesToInvite);
        }
        catch (Exception e) {
            LOG.warn("Error inviting identities {} to space {}", new Object[]{identitiesToInvite, spaceToCreate.getDisplayName(), e});
        }
        return this.getSpaceById(createdSpace.getId());
    }

    public void inviteIdentities(Space space, List<org.exoplatform.social.core.identity.model.Identity> identitiesToInvite) {
        if (CollectionUtils.isEmpty(identitiesToInvite)) {
            return;
        }
        Space existingSpace = this.getSpaceById(space.getId());
        existingSpace.setEditor(space.getEditor());
        List<String> usernames = this.getUsersToInvite(identitiesToInvite);
        for (String username : usernames) {
            if (this.isMember(existingSpace, username) || this.isInvitedUser(existingSpace, username)) continue;
            this.addInvitedUser(existingSpace, username);
        }
    }

    public boolean isSpaceContainsExternals(Long spaceId) {
        return this.spaceStorage.countExternalMembers(spaceId) != 0;
    }

    public Space createSpace(Space space) {
        if (ArrayUtils.isEmpty((Object[])space.getManagers()) && space.getEditor() == null) {
            throw new IllegalArgumentException("Can't Find Space editor username");
        }
        String username = space.getEditor() == null ? space.getManagers()[0] : space.getEditor();
        return this.createSpace(space, username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSpace(Space space, String newDisplayName) {
        this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.SPACE_RENAMED);
        try {
            String oldPrettyName = space.getPrettyName();
            String newPrettyName = this.buildPrettyName(newDisplayName);
            space.setDisplayName(newDisplayName);
            space.setPrettyName(newPrettyName);
            if (oldPrettyName.equals(space.getUrl())) {
                space.setUrl(newPrettyName);
            } else if (StringUtils.isBlank((CharSequence)space.getUrl())) {
                space.setUrl("home");
            }
            this.spaceStorage.renameSpace(space);
            this.spaceLifeCycle.spaceRenamed(space, space.getEditor());
        }
        finally {
            this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.SPACE_RENAMED);
        }
    }

    public void renameSpace(Space space, String newDisplayName, String username) throws SpaceException {
        if (username == null || !this.canManageSpace(this.getSpaceById(space.getId()), username)) {
            throw new SpaceException(SpaceException.Code.UNAUTHORIZED_TO_RENAME_SPACE);
        }
        this.renameSpace(space, newDisplayName);
    }

    public void deleteSpace(Space space) throws SpaceException {
        this.deleteSpace(space, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSpace(Space space, boolean deleteGroup) throws SpaceException {
        this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.SPACE_REMOVED);
        try {
            List groupSpaceBindings = this.groupSpaceBindingStorage.findGroupSpaceBindingsBySpace(space.getId());
            groupSpaceBindings.stream().map(GroupSpaceBinding::getId).forEach(arg_0 -> ((GroupSpaceBindingStorage)this.groupSpaceBindingStorage).deleteGroupBinding(arg_0));
            SpaceUtils.removeMembershipFromGroup(space);
            org.exoplatform.social.core.identity.model.Identity spaceIdentity = null;
            if (this.identityManager.identityExisted("space", space.getPrettyName())) {
                spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
            }
            this.spaceStorage.deleteSpace(space.getId());
            if (spaceIdentity != null) {
                this.identityManager.hardDeleteIdentity(spaceIdentity);
            }
            if (deleteGroup) {
                GroupHandler groupHandler = this.getOrganizationService().getGroupHandler();
                Group spaceGroup = groupHandler.findGroupById(space.getGroupId());
                List mandatories = this.userAcl.getMandatoryGroups();
                if (spaceGroup != null && !this.isMandatory(groupHandler, spaceGroup, mandatories)) {
                    SpaceUtils.removeGroup(space);
                }
            }
            this.spaceLifeCycle.spaceRemoved(space, space.getEditor());
        }
        finally {
            this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.SPACE_REMOVED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMember(Space space, String username) {
        this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.JOINED);
        try {
            Object[] members = space.getMembers();
            space = this.removeInvited(space, username);
            space = this.removePending(space, username);
            if (!ArrayUtils.contains((Object[])members, (Object)username)) {
                members = (String[])ArrayUtils.add((Object[])members, (Object)username);
                space.setMembers((String[])members);
                this.spaceStorage.saveSpace(space, false);
                SpaceUtils.addUserToGroupWithMemberMembership(username, space.getGroupId());
                this.spaceLifeCycle.memberJoined(space, username);
            }
        }
        finally {
            this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.JOINED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(Space space, String username) {
        if (this.groupSpaceBindingStorage.countUserBindings(space.getId(), username) > 0L) {
            throw new IllegalStateException("space.cantLeaveBoundSpace");
        }
        if (this.isManager(space, username)) {
            this.setManager(space, username, false);
        }
        if (this.isManager(space, username)) {
            this.setManager(space, username, false);
        }
        if (this.isRedactor(space, username)) {
            this.removeRedactor(space, username);
        }
        if (this.isPublisher(space, username)) {
            this.removePublisher(space, username);
        }
        this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.LEFT);
        try {
            org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
            if (spaceIdentity != null && spaceIdentity.isDeleted()) {
                return;
            }
            Object[] members = space.getMembers();
            List disabledMembers = this.identityManager.getDisabledSpaceMembers(Long.parseLong(space.getId()));
            if (disabledMembers != null && !disabledMembers.isEmpty()) {
                members = (String[])ArrayUtils.addAll((Object[])members, (Object[])((String[])disabledMembers.toArray(String[]::new)));
            }
            if (ArrayUtils.contains((Object[])members, (Object)username)) {
                SpaceUtils.removeUserFromGroupWithMemberMembership(username, space.getGroupId());
                members = (String[])ArrayUtils.removeAllOccurrences((Object[])members, (Object)username);
                space.setMembers((String[])members);
                this.spaceStorage.saveSpace(space, false);
                this.setManager(space, username, false);
                this.removeRedactor(space, username);
                SpaceUtils.removeUserFromGroupWithAnyMembership(username, space.getGroupId());
                this.spaceLifeCycle.memberLeft(space, username);
            }
        }
        finally {
            this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.LEFT);
        }
    }

    public boolean isMember(Space space, String username) {
        return space != null && ArrayUtils.contains((Object[])space.getMembers(), (Object)username);
    }

    public boolean isIgnored(Space space, String username) {
        return space != null && this.spaceStorage.isSpaceIgnored(space.getId(), username);
    }

    public void setIgnored(String spaceId, String username) {
        this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.DENY_INVITED_USER);
        try {
            this.spaceStorage.ignoreSpace(spaceId, username);
            this.spaceLifeCycle.removeInvitedUser(this.getSpaceById(spaceId), username);
        }
        finally {
            this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.DENY_INVITED_USER);
        }
    }

    public void registerSpaceLifeCycleListener(SpaceLifeCycleListener listener) {
        this.spaceLifeCycle.addListener((LifeCycleListener)listener);
    }

    public void unregisterSpaceLifeCycleListener(SpaceLifeCycleListener listener) {
        this.spaceLifeCycle.removeListener((LifeCycleListener)listener);
    }

    public void addInvitedUser(Space space, String username) {
        if (ArrayUtils.contains((Object[])space.getMembers(), (Object)username)) {
            return;
        }
        if (this.isPendingUser(space, username)) {
            this.removePending(space, username);
            this.addMember(space, username);
        } else {
            this.addInvited(space, username);
        }
        this.spaceStorage.saveSpace(space, false);
        this.spaceLifeCycle.addInvitedUser(space, username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingUser(Space space, String username) {
        if (ArrayUtils.contains((Object[])space.getMembers(), (Object)username)) {
            return;
        }
        if (ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)username)) {
            return;
        }
        if (ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)username)) {
            this.addMember(space, username);
            this.removeInvited(space, username);
            this.spaceStorage.saveSpace(space, false);
            return;
        }
        String registration = space.getRegistration();
        String visibility = space.getVisibility();
        if (visibility.equals("hidden") && registration.equals("closed")) {
            LOG.warn((Object)"Unable request to join hidden");
            return;
        }
        if (registration.equals("open")) {
            this.addMember(space, username);
        } else if (registration.equals("validation")) {
            this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.ADD_PENDING_USER);
            try {
                this.addPending(space, username);
                this.spaceStorage.saveSpace(space, false);
                this.spaceLifeCycle.addPendingUser(space, username);
            }
            finally {
                this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.ADD_PENDING_USER);
            }
        } else {
            LOG.warn((Object)"Unable request to join");
        }
    }

    public boolean hasSettingPermission(Space space, String username) {
        return this.canManageSpace(space, username);
    }

    public boolean canDeleteSpace(Space space, String username) {
        return this.hasSpacePermission(space, space.getDeletePermissions(), username);
    }

    public boolean canAccessSpacePublicSite(Space space, String username) {
        if (space == null || space.getPublicSiteId() == 0L || StringUtils.isBlank((CharSequence)space.getPublicSiteVisibility())) {
            return false;
        }
        if (StringUtils.equals((CharSequence)space.getPublicSiteVisibility(), (CharSequence)"everyone")) {
            return true;
        }
        if (this.userAcl.isAnonymousUser(username)) {
            return false;
        }
        if (StringUtils.equals((CharSequence)space.getPublicSiteVisibility(), (CharSequence)"authenticated")) {
            return true;
        }
        if (StringUtils.equals((CharSequence)space.getPublicSiteVisibility(), (CharSequence)"internal")) {
            return this.userAcl.getUserIdentity(username).isMemberOf("/platform/users");
        }
        if (StringUtils.equals((CharSequence)space.getPublicSiteVisibility(), (CharSequence)"member")) {
            return this.canViewSpace(space, username);
        }
        if (StringUtils.equals((CharSequence)space.getPublicSiteVisibility(), (CharSequence)"manager")) {
            return this.canManageSpace(space, username);
        }
        return false;
    }

    public boolean canManageSpace(Space space, String username) {
        if (username == null || space == null) {
            return false;
        }
        if (this.isMember(space, username) && this.isManager(space, username)) {
            return true;
        }
        return this.isSuperManager(space, username);
    }

    public boolean isInvitedUser(Space space, String username) {
        return space != null && ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)username);
    }

    public boolean isManager(Space space, String username) {
        return space != null && ArrayUtils.contains((Object[])space.getManagers(), (Object)username);
    }

    public boolean isRedactor(Space space, String username) {
        return space != null && ArrayUtils.contains((Object[])space.getRedactors(), (Object)username);
    }

    public boolean isPublisher(Space space, String username) {
        return space != null && ArrayUtils.contains((Object[])space.getPublishers(), (Object)username);
    }

    public boolean hasRedactor(Space space) {
        return space != null && space.getRedactors() != null && space.getRedactors().length > 0;
    }

    public boolean isOnlyManager(Space space, String username) {
        return space.getManagers() != null && space.getManagers().length == 1 && StringUtils.equals((CharSequence)space.getManagers()[0], (CharSequence)username);
    }

    public boolean isPendingUser(Space space, String username) {
        return ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)username);
    }

    public void registerSpaceListenerPlugin(SpaceListenerPlugin spaceListenerPlugin) {
        this.spaceLifeCycle.addListener((LifeCycleListener)spaceListenerPlugin);
    }

    public void removeInvitedUser(Space space, String username) {
        if (ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)username)) {
            this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.DENY_INVITED_USER);
            try {
                space = this.removeInvited(space, username);
                this.spaceStorage.saveSpace(space, false);
                this.spaceLifeCycle.removeInvitedUser(space, username);
            }
            finally {
                this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.DENY_INVITED_USER);
            }
        }
    }

    public void removePendingUser(Space space, String username) {
        if (ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)username)) {
            this.removePending(space, username);
            this.spaceStorage.saveSpace(space, false);
            this.spaceLifeCycle.removePendingUser(space, username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRedactor(Space space, String username) {
        Object[] redactors = space.getRedactors();
        if (!ArrayUtils.contains((Object[])redactors, (Object)username)) {
            this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.ADD_REDACTOR_USER);
            try {
                redactors = (String[])ArrayUtils.add((Object[])redactors, (Object)username);
                space.setRedactors((String[])redactors);
                this.spaceStorage.saveSpace(space, false);
                SpaceUtils.addUserToGroupWithRedactorMembership(username, space.getGroupId());
                this.spaceLifeCycle.addRedactorUser(space, username);
            }
            finally {
                this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.ADD_REDACTOR_USER);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRedactor(Space space, String username) {
        Object[] redactors = space.getRedactors();
        if (ArrayUtils.contains((Object[])redactors, (Object)username)) {
            this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.REMOVE_REDACTOR_USER);
            try {
                redactors = (String[])ArrayUtils.removeAllOccurrences((Object[])redactors, (Object)username);
                space.setRedactors((String[])redactors);
                this.spaceStorage.saveSpace(space, false);
                SpaceUtils.removeUserFromGroupWithRedactorMembership(username, space.getGroupId());
                this.spaceLifeCycle.removeRedactorUser(space, username);
            }
            finally {
                this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.REMOVE_REDACTOR_USER);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPublisher(Space space, String username) {
        Object[] publishers = space.getPublishers();
        if (!ArrayUtils.contains((Object[])publishers, (Object)username)) {
            this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.ADD_PUBLISHER_USER);
            try {
                publishers = (String[])ArrayUtils.add((Object[])publishers, (Object)username);
                space.setPublishers((String[])publishers);
                this.spaceStorage.saveSpace(space, false);
                SpaceUtils.addUserToGroupWithPublisherMembership(username, space.getGroupId());
                this.spaceLifeCycle.addPublisherUser(space, username);
            }
            finally {
                this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.ADD_PUBLISHER_USER);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePublisher(Space space, String username) {
        Object[] publishers = space.getPublishers();
        if (ArrayUtils.contains((Object[])publishers, (Object)username)) {
            this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.REMOVE_PUBLISHER_USER);
            try {
                publishers = (String[])ArrayUtils.removeAllOccurrences((Object[])publishers, (Object)username);
                space.setPublishers((String[])publishers);
                this.spaceStorage.saveSpace(space, false);
                SpaceUtils.removeUserFromGroupWithPublisherMembership(username, space.getGroupId());
                this.spaceLifeCycle.removePublisherUser(space, username);
            }
            finally {
                this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.REMOVE_PUBLISHER_USER);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManager(Space space, String username, boolean isManager) {
        Object[] managers = space.getManagers();
        if (isManager) {
            if (!ArrayUtils.contains((Object[])managers, (Object)username)) {
                this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.GRANTED_LEAD);
                try {
                    managers = (String[])ArrayUtils.add((Object[])managers, (Object)username);
                    space.setManagers((String[])managers);
                    this.spaceStorage.saveSpace(space, false);
                    SpaceUtils.addUserToGroupWithManagerMembership(username, space.getGroupId());
                    this.spaceLifeCycle.grantedLead(space, username);
                }
                finally {
                    this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.GRANTED_LEAD);
                }
            }
        } else if (ArrayUtils.contains((Object[])managers, (Object)username)) {
            this.spaceLifeCycle.setCurrentEvent(SpaceLifeCycleEvent.Type.REVOKED_LEAD);
            try {
                SpaceUtils.removeUserFromGroupWithManagerMembership(username, space.getGroupId());
                managers = (String[])ArrayUtils.removeAllOccurrences((Object[])managers, (Object)username);
                space.setManagers((String[])managers);
                this.spaceStorage.saveSpace(space, false);
                Space updatedSpace = this.getSpaceById(space.getId());
                if (this.isMember(updatedSpace, username)) {
                    this.spaceLifeCycle.revokedLead(space, username);
                }
            }
            finally {
                this.spaceLifeCycle.resetCurrentEvent(SpaceLifeCycleEvent.Type.REVOKED_LEAD);
            }
        }
    }

    public void unregisterSpaceListenerPlugin(SpaceListenerPlugin spaceListenerPlugin) {
        this.spaceLifeCycle.removeListener((LifeCycleListener)spaceListenerPlugin);
    }

    public Space updateSpace(Space existingSpace) {
        return this.updateSpace(existingSpace, null);
    }

    public Space updateSpace(Space space, List<org.exoplatform.social.core.identity.model.Identity> identitiesToInvite) {
        Space storedSpace = this.spaceStorage.getSpaceById(space.getSpaceId());
        this.spaceStorage.saveSpace(space, false);
        this.triggerSpaceUpdate(space, storedSpace);
        this.inviteIdentities(space, identitiesToInvite);
        return this.getSpaceById(space.getId());
    }

    public Space updateSpaceAvatar(Space existingSpace, String username) {
        existingSpace.setEditor(username);
        this.checkSpaceEditorPermissions(existingSpace);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(existingSpace.getPrettyName());
        Profile profile = spaceIdentity.getProfile();
        if (existingSpace.getAvatarAttachment() != null) {
            profile.setProperty("avatar", (Object)existingSpace.getAvatarAttachment());
        } else {
            profile.removeProperty("avatar");
            profile.setAvatarUrl(null);
            profile.setAvatarLastUpdated(null);
        }
        this.identityManager.updateProfile(profile);
        this.spaceLifeCycle.spaceAvatarEdited(existingSpace, existingSpace.getEditor());
        existingSpace = this.spaceStorage.getSpaceById(existingSpace.getSpaceId());
        existingSpace.setAvatarLastUpdated(Long.valueOf(System.currentTimeMillis()));
        this.spaceStorage.saveSpace(existingSpace, false);
        return existingSpace;
    }

    public Space updateSpaceBanner(Space existingSpace, String username) {
        Profile profile;
        existingSpace.setEditor(username);
        this.checkSpaceEditorPermissions(existingSpace);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(existingSpace.getPrettyName());
        if (spaceIdentity != null) {
            profile = spaceIdentity.getProfile();
            if (existingSpace.getBannerAttachment() != null) {
                profile.setProperty("banner", (Object)existingSpace.getBannerAttachment());
            } else {
                profile.removeProperty("banner");
            }
        } else {
            throw new IllegalStateException("Can not update space banner. Space identity " + existingSpace.getPrettyName() + " not found");
        }
        this.identityManager.updateProfile(profile);
        existingSpace = this.spaceStorage.getSpaceById(existingSpace.getSpaceId());
        existingSpace.setBannerLastUpdated(Long.valueOf(System.currentTimeMillis()));
        this.spaceStorage.saveSpace(existingSpace, false);
        this.spaceLifeCycle.spaceBannerEdited(existingSpace, existingSpace.getEditor());
        return existingSpace;
    }

    public void updateSpaceAccessed(String remoteId, Space space) {
        if (this.isMember(space, remoteId)) {
            this.spaceStorage.updateSpaceAccessed(remoteId, space);
        }
    }

    public List<SpaceExternalInvitation> findSpaceExternalInvitationsBySpaceId(String spaceId) {
        return this.spaceStorage.findSpaceExternalInvitationsBySpaceId(spaceId);
    }

    public void saveSpaceExternalInvitation(String spaceId, String email, String tokenId) {
        this.spaceStorage.saveSpaceExternalInvitation(spaceId, email, tokenId);
    }

    public SpaceExternalInvitation getSpaceExternalInvitationById(String invitationId) {
        return this.spaceStorage.findSpaceExternalInvitationById(invitationId);
    }

    public List<Long> getSpaceCategoryIds() {
        return this.spaceStorage.getSpaceCategoryIds();
    }

    public void deleteSpaceExternalInvitation(String invitationId) {
        SpaceExternalInvitation spaceExternalInvitation = this.spaceStorage.findSpaceExternalInvitationById(invitationId);
        this.spaceStorage.deleteSpaceExternalInvitation(spaceExternalInvitation);
        RemindPasswordTokenService remindPasswordTokenService = (RemindPasswordTokenService)CommonsUtils.getService(RemindPasswordTokenService.class);
        if (remindPasswordTokenService != null) {
            remindPasswordTokenService.deleteToken(spaceExternalInvitation.getTokenId(), "external-registration");
        }
    }

    public List<String> findExternalInvitationsSpacesByEmail(String email) {
        return this.spaceStorage.findExternalInvitationsSpacesByEmail(email);
    }

    public void deleteExternalUserInvitations(String email) {
        this.spaceStorage.deleteExternalUserInvitations(email);
    }

    public boolean isSuperManager(String username) {
        return this.userAcl.isAdministrator(this.userAcl.getUserIdentity(username));
    }

    public boolean isSuperManager(Space space, String username) {
        if (space == null || space.getTemplateId() == 0L) {
            return this.isSuperManager(username);
        }
        SpaceTemplate spaceTemplate = this.getSpaceTemplateService().getSpaceTemplate(space.getTemplateId());
        Identity userIdentity = this.userAcl.getUserIdentity(username);
        if (spaceTemplate == null || spaceTemplate.isDeleted()) {
            return this.isSuperManager(username);
        }
        return this.isSuperManager(username) || CollectionUtils.isNotEmpty(spaceTemplate.getAdminPermissions()) && userIdentity != null && spaceTemplate.getAdminPermissions().stream().anyMatch(permission -> userIdentity.isMemberOf(this.getMembershipEntry((String)permission)));
    }

    public boolean canManageSpacePublicSite(Space space, String username) {
        return this.hasSpacePermission(space, space.getPublicSitePermissions(), username);
    }

    public boolean canManageSpaceLayout(Space space, String username) {
        return this.hasSpacePermission(space, space.getLayoutPermissions(), username);
    }

    public boolean isContentManager(String username) {
        if (this.userAcl.isAnonymousUser(username)) {
            return false;
        }
        if (this.isSuperManager(username)) {
            return true;
        }
        Identity identity = this.userAcl.getUserIdentity(username);
        return identity != null && identity.isMemberOf("/platform/web-contributors", "manager");
    }

    public boolean isContentPublisher(String username) {
        if (this.userAcl.isAnonymousUser(username)) {
            return false;
        }
        if (this.isSuperManager(username)) {
            return true;
        }
        Identity identity = this.userAcl.getUserIdentity(username);
        return identity != null && identity.isMemberOf("/platform/web-contributors", "publisher");
    }

    public Map<Long, Long> countSpacesByTemplate() {
        return this.spaceStorage.countSpacesByTemplate();
    }

    public void addSpaceListener(SpaceListenerPlugin plugin) {
        this.registerSpaceLifeCycleListener((SpaceLifeCycleListener)plugin);
    }

    private void copySpaceTemplateProperties(Space space, SpaceTemplate spaceTemplate, String username, List<String> invitees) throws SpaceException {
        this.setSpaceAccess(space, spaceTemplate);
        this.setSpaceDisplayName(space, invitees);
        this.setSpacePrettyName(space);
        String groupId = this.createSpaceGroup(space, username);
        SpaceServiceImpl.setDeletePermissions(space, spaceTemplate, groupId);
        this.setLayoutPermissions(space, spaceTemplate, groupId);
        this.setPublicSitePermissions(space, spaceTemplate, groupId);
        this.setSpaceDefaultRedactors(space, spaceTemplate, username, groupId);
    }

    private void setSpaceDefaultRedactors(Space space, SpaceTemplate spaceTemplate, String username, String groupId) {
        if (spaceTemplate.isSpaceAllowContentCreation()) {
            space.setRedactors(new String[]{username});
            SpaceUtils.addUserToGroupWithRedactorMembership(username, groupId);
        } else {
            space.setRedactors(new String[0]);
        }
    }

    private void setSpaceAccess(Space space, SpaceTemplate spaceTemplate) {
        if (!spaceTemplate.getSpaceFields().contains("access")) {
            if (StringUtils.isEmpty((CharSequence)space.getRegistration())) {
                space.setRegistration(spaceTemplate.getSpaceDefaultRegistration().name().toLowerCase());
            }
            if (StringUtils.isEmpty((CharSequence)space.getVisibility())) {
                space.setVisibility(spaceTemplate.getSpaceDefaultVisibility().name().toLowerCase());
            }
        }
    }

    private void setSpaceDisplayName(Space space, List<String> invitees) throws SpaceException {
        if (StringUtils.isBlank((CharSequence)space.getDisplayName())) {
            String moreLabel;
            if (CollectionUtils.isNotEmpty(invitees)) {
                invitees = new ArrayList<String>(invitees);
                invitees.removeAll(Arrays.asList(space.getMembers()));
            }
            String[] users = (String[])ArrayUtils.addAll((Object[])space.getMembers(), (Object[])(CollectionUtils.isEmpty(invitees) ? new String[]{} : invitees.toArray(new String[invitees.size()])));
            List<String> userFullNames = Arrays.stream(users).map(u -> {
                Profile profile = this.identityManager.getOrCreateUserIdentity(u).getProfile();
                return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{profile.getFullName()});
            }).limit(2L).toList();
            Object displayName = StringUtils.join(userFullNames, (String)", ");
            if (users.length > 2 && ((String)(displayName = (String)displayName + " " + ((String)StringUtils.firstNonBlank((CharSequence[])new String[]{moreLabel = this.resourceBundleService.getSharedString("space.name.more", this.localeConfigService.getDefaultLocaleConfig().getLocale()), "and {0} more"})).replace("{0}", String.valueOf(users.length - 2)))).length() > 200) {
                displayName = ((String)displayName).substring(0, 200);
            }
            space.setDisplayName((String)displayName);
        } else if (space.getDisplayName() == null || space.getDisplayName().length() < 3 || space.getDisplayName().length() > 200) {
            throw new SpaceException(SpaceException.Code.INVALID_SPACE_NAME);
        }
    }

    private void setSpacePrettyName(Space space) {
        space.setPrettyName(this.buildPrettyName(space.getPrettyName(), space.getDisplayName()));
    }

    private String createSpaceGroup(Space space, String username) throws SpaceException {
        String groupId = SpaceUtils.createGroup(space.getDisplayName(), space.getPrettyName(), username);
        space.setGroupId(groupId);
        space.setPrettyName(groupId.replace("/spaces/", ""));
        return groupId;
    }

    private void setLayoutPermissions(Space space, SpaceTemplate spaceTemplate, String groupId) {
        SpaceUtils.setPermissionsFromTemplate(spaceTemplate::getSpaceLayoutPermissions, arg_0 -> ((Space)space).setLayoutPermissions(arg_0), groupId);
    }

    private void setPublicSitePermissions(Space space, SpaceTemplate spaceTemplate, String groupId) {
        SpaceUtils.setPermissionsFromTemplate(spaceTemplate::getSpacePublicSitePermissions, arg_0 -> ((Space)space).setPublicSitePermissions(arg_0), groupId);
    }

    public static void setDeletePermissions(Space space, SpaceTemplate spaceTemplate, String groupId) {
        SpaceUtils.setPermissionsFromTemplate(spaceTemplate::getSpaceDeletePermissions, arg_0 -> ((Space)space).setDeletePermissions(arg_0), groupId);
    }

    private String checkSpaceEditorPermissions(Space space) {
        String editor = space.getEditor();
        if (StringUtils.isBlank((CharSequence)editor) || !this.canManageSpace(space, editor)) {
            throw new IllegalStateException("User " + editor + " is not authorized to change space.");
        }
        return editor;
    }

    private boolean hasSpacePermission(Space space, List<String> permissions, String username) {
        if (space.getTemplateId() == 0L && CollectionUtils.isEmpty(permissions)) {
            return this.canManageSpace(space, username);
        }
        if (CollectionUtils.isEmpty(permissions)) {
            return this.isSuperManager(space, username);
        }
        Identity userIdentity = this.userAcl.getUserIdentity(username);
        return this.isSuperManager(space, username) || this.isMember(space, username) && permissions.stream().anyMatch(permission -> userIdentity.isMemberOf(this.getMembershipEntry((String)permission)));
    }

    private void triggerSpaceUpdate(Space newSpace, Space oldSpace) {
        if (oldSpace != null) {
            List newCategoryIds;
            if (StringUtils.isBlank((CharSequence)newSpace.getEditor()) && ArrayUtils.isNotEmpty((Object[])oldSpace.getManagers())) {
                newSpace.setEditor(oldSpace.getManagers()[0]);
            }
            if (!StringUtils.equals((CharSequence)oldSpace.getDescription(), (CharSequence)newSpace.getDescription())) {
                this.spaceLifeCycle.spaceDescriptionEdited(newSpace, newSpace.getEditor());
            }
            if (!oldSpace.getVisibility().equals(newSpace.getVisibility())) {
                this.spaceLifeCycle.spaceAccessEdited(newSpace, newSpace.getEditor());
            }
            List categoryIds = oldSpace.getCategoryIds() == null ? Collections.emptyList() : oldSpace.getCategoryIds();
            List list = newCategoryIds = newSpace.getCategoryIds() == null ? Collections.emptyList() : newSpace.getCategoryIds();
            if (!CollectionUtils.isEqualCollection((Collection)categoryIds, (Collection)newCategoryIds)) {
                ArrayList categoryIdsToAdd = new ArrayList(newCategoryIds);
                categoryIdsToAdd.removeAll(categoryIds);
                categoryIdsToAdd.forEach(categoryId -> this.spaceLifeCycle.spaceCategoryAdded(newSpace, newSpace.getEditor(), categoryId.longValue()));
                ArrayList categoryIdsToRemove = new ArrayList(categoryIds);
                categoryIdsToRemove.removeAll(newCategoryIds);
                categoryIdsToRemove.forEach(categoryId -> this.spaceLifeCycle.spaceCategoryRemoved(newSpace, newSpace.getEditor(), categoryId.longValue()));
            }
            if (oldSpace.getPublicSiteId() == 0L && newSpace.getPublicSiteId() != oldSpace.getPublicSiteId()) {
                this.spaceLifeCycle.spacePublicSiteCreated(newSpace, newSpace.getEditor());
            } else if (newSpace.getPublicSiteId() != oldSpace.getPublicSiteId() || !StringUtils.equals((CharSequence)newSpace.getPublicSiteVisibility(), (CharSequence)oldSpace.getPublicSiteVisibility())) {
                this.spaceLifeCycle.spacePublicSiteUpdated(newSpace, newSpace.getEditor());
            }
            String oldRegistration = oldSpace.getRegistration();
            String registration = newSpace.getRegistration();
            if (oldRegistration == null && registration != null || oldRegistration != null && !oldRegistration.equals(registration)) {
                this.spaceLifeCycle.spaceRegistrationEdited(newSpace, newSpace.getEditor());
            }
        }
    }

    private List<String> getUsersToInvite(List<org.exoplatform.social.core.identity.model.Identity> identities) {
        if (identities == null) {
            return Collections.emptyList();
        }
        return identities.stream().filter(identity -> identity != null && StringUtils.isNotBlank((CharSequence)identity.getRemoteId()) && StringUtils.isNotBlank((CharSequence)identity.getProviderId())).map(identity -> this.identityManager.getOrCreateIdentity(identity.getProviderId(), identity.getRemoteId())).filter(Objects::nonNull).flatMap(identity -> {
            if (identity.isSpace()) {
                Space space = this.getSpaceByPrettyName(identity.getRemoteId());
                if (space != null) {
                    return Arrays.stream(space.getMembers());
                }
                return Stream.empty();
            }
            if (identity.isUser()) {
                return Stream.of(identity.getRemoteId());
            }
            return Stream.empty();
        }).distinct().toList();
    }

    private boolean isMandatory(GroupHandler groupHandler, Group group, List<String> mandatories) {
        if (mandatories.contains(group.getId())) {
            return true;
        }
        Collection children = groupHandler.findGroups(group);
        for (Group g : children) {
            if (!this.isMandatory(groupHandler, g, mandatories)) continue;
            return true;
        }
        return false;
    }

    private void duplicateBannerById(Space space, long bannerId, String username) {
        FileItem file = this.fileService.getFile(bannerId);
        BannerAttachment attachment = new BannerAttachment(null, file.getFileInfo().getName(), file.getFileInfo().getMimetype(), file.getAsStream(), System.currentTimeMillis());
        space.setBannerAttachment(attachment);
        this.updateSpaceBanner(space, username);
    }

    private Space addPending(Space space, String username) {
        Object[] pendingUsers = space.getPendingUsers();
        if (!ArrayUtils.contains((Object[])pendingUsers, (Object)username)) {
            pendingUsers = (String[])ArrayUtils.add((Object[])pendingUsers, (Object)username);
            space.setPendingUsers((String[])pendingUsers);
        }
        return space;
    }

    private Space removePending(Space space, String username) {
        Object[] pendingUsers = space.getPendingUsers();
        if (ArrayUtils.contains((Object[])pendingUsers, (Object)username)) {
            pendingUsers = (String[])ArrayUtils.removeAllOccurrences((Object[])pendingUsers, (Object)username);
            space.setPendingUsers((String[])pendingUsers);
        }
        return space;
    }

    private Space addInvited(Space space, String username) {
        Object[] invitedUsers = space.getInvitedUsers();
        if (!ArrayUtils.contains((Object[])invitedUsers, (Object)username)) {
            invitedUsers = (String[])ArrayUtils.add((Object[])invitedUsers, (Object)username);
            space.setInvitedUsers((String[])invitedUsers);
        }
        return space;
    }

    private MembershipEntry getMembershipEntry(String expression) {
        return expression.contains(":") ? MembershipEntry.parse((String)expression) : new MembershipEntry(expression);
    }

    private Space removeInvited(Space space, String username) {
        Object[] invitedUsers = space.getInvitedUsers();
        if (ArrayUtils.contains((Object[])invitedUsers, (Object)username)) {
            invitedUsers = (String[])ArrayUtils.removeAllOccurrences((Object[])invitedUsers, (Object)username);
            space.setInvitedUsers((String[])invitedUsers);
        }
        return space;
    }

    private OrganizationService getOrganizationService() {
        if (this.organizationService == null) {
            this.organizationService = (OrganizationService)ExoContainerContext.getService(OrganizationService.class);
        }
        return this.organizationService;
    }

    private SpaceTemplateService getSpaceTemplateService() {
        if (this.spaceTemplateService == null) {
            this.spaceTemplateService = (SpaceTemplateService)ExoContainerContext.getService(SpaceTemplateService.class);
        }
        return this.spaceTemplateService;
    }

    private String buildPrettyName(String ... names) {
        return Arrays.stream(names).filter(StringUtils::isNotBlank).map(displayName -> {
            String name = Utils.cleanString((String)displayName);
            int index = 0;
            while (this.getSpaceByPrettyName(name) != null) {
                name = Utils.cleanString((String)(displayName + " " + ++index));
            }
            return name;
        }).findFirst().orElseThrow();
    }
}

