/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.command;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.gatein.wci.RequestDispatchCallback;
import org.gatein.wci.command.CommandServlet;

public class CommandDispatcher {
    protected final String servletPath;

    public CommandDispatcher(String servletPath) {
        this.servletPath = servletPath;
    }

    public Object include(ServletContext targetServletContext, HttpServletRequest req, HttpServletResponse resp, RequestDispatchCallback callback, Object handback) throws ServletException, IOException {
        CallbackCommand cmd = new CallbackCommand(targetServletContext, callback, handback);
        return CommandServlet.include(this.servletPath, req, resp, cmd, targetServletContext);
    }

    public static class CallbackCommand {
        private final ServletContext servletContext;
        private final RequestDispatchCallback invocation;
        private final Object handback;

        public CallbackCommand(ServletContext servletContext, RequestDispatchCallback invocation, Object handback) {
            this.servletContext = servletContext;
            this.invocation = invocation;
            this.handback = handback;
        }

        public Object execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            return this.invocation.doCallback(this.servletContext, req, resp, this.handback);
        }
    }
}

