/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.rest;

import javax.ws.rs.core.MediaType;
import org.gatein.management.api.ContentType;

public class ContentTypeUtils {
    private static final ContentType[] CONTENT_TYPES = ContentType.values();
    private static final MediaType[] MEDIA_TYPES;

    private ContentTypeUtils() {
    }

    public static MediaType[] mediaTypes() {
        return MEDIA_TYPES;
    }

    public static ContentType getContentType(MediaType mediaType) {
        for (ContentType ct : CONTENT_TYPES) {
            if (!mediaType.getSubtype().equalsIgnoreCase(ct.name())) continue;
            return ct;
        }
        return null;
    }

    public static MediaType getMediaType(ContentType contentType) {
        ContentType[] contentTypes = CONTENT_TYPES;
        for (int i = 0; i < contentTypes.length; ++i) {
            if (contentTypes[i] != contentType) continue;
            return MEDIA_TYPES[i];
        }
        return null;
    }

    static {
        MediaType[] mediaTypes = new MediaType[CONTENT_TYPES.length];
        for (int i = 0; i < mediaTypes.length; ++i) {
            mediaTypes[i] = new MediaType("application", CONTENT_TYPES[i].name().toLowerCase());
        }
        MEDIA_TYPES = mediaTypes;
    }
}

