/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.service;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.portal.navigation.constant.SidebarItemType;
import io.meeds.portal.navigation.constant.SidebarMode;
import io.meeds.portal.navigation.constant.TopbarItemType;
import io.meeds.portal.navigation.model.NavigationConfiguration;
import io.meeds.portal.navigation.model.SidebarConfiguration;
import io.meeds.portal.navigation.model.SidebarItem;
import io.meeds.portal.navigation.model.TopbarApplication;
import io.meeds.portal.navigation.model.TopbarConfiguration;
import io.meeds.portal.navigation.service.NavigationConfigurationService;
import io.meeds.social.navigation.plugin.DefaultSidebarPlugin;
import io.meeds.social.navigation.plugin.SidebarPlugin;
import io.meeds.social.navigation.service.NavigationConfigurationServiceImpl$AjcClosure1;
import io.meeds.social.navigation.storage.NavigationConfigurationStorage;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.addons.AddOnService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class NavigationConfigurationServiceImpl
implements NavigationConfigurationService {
    public static final String NAVIGATION_CONFIGURATION_UPDATED_EVENT = "social.navigation.configuration.updated";
    private static final String TOPBAR_APPLICATION_ENABLED_PATTERN = "social.topbar.application.%s.enabled";
    private static final String TOPBAR_APPLICATION_MOBILE_PATTERN = "social.topbar.application.%s.mobile";
    private static final String TOP_NAVIGATION_ADDON_CONTAINER = "middle-topNavigation-container";
    private static final SidebarPlugin DEFAULT_MENU_PLUGIN;
    @Autowired
    private AddOnService addonContainerService;
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private NavigationConfigurationStorage navigationConfigurationStorage;
    @Autowired
    private List<SidebarPlugin> menuPlugins;
    @Autowired
    private Environment environment;
    private List<TopbarApplication> defaultTopbarApplications;
    private boolean allowUserHome = true;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    @ContainerTransactional
    public void init() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        NavigationConfigurationServiceImpl$AjcClosure1 navigationConfigurationServiceImpl$AjcClosure1 = new NavigationConfigurationServiceImpl$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(navigationConfigurationServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public NavigationConfiguration getConfiguration() {
        return this.getConfiguration(null, null, false);
    }

    public NavigationConfiguration getConfiguration(String username, Locale locale, boolean resolve) {
        NavigationConfiguration configuration = this.navigationConfigurationStorage.getConfiguration(this.defaultTopbarApplications);
        if (configuration == null) {
            return null;
        }
        configuration.getSidebar().setItems(configuration.getSidebar().getItems().stream().filter(item -> !resolve || this.getPlugin(item.getType()).itemExists(item, username)).map(item -> resolve ? this.expandSidebarItem((SidebarItem)item, username, locale) : item).toList());
        return configuration;
    }

    public TopbarConfiguration getTopbarConfiguration(String username, Locale locale) {
        return this.getConfiguration(username, locale, true).getTopbar();
    }

    public SidebarConfiguration getSidebarConfiguration(String username, Locale locale) {
        SidebarConfiguration sidebarConfiguration = this.getConfiguration(username, locale, true).getSidebar();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            SidebarMode mode = this.getSidebarUserMode(username, sidebarConfiguration);
            sidebarConfiguration.setUserMode(mode);
        }
        return sidebarConfiguration;
    }

    public SidebarMode getSidebarUserMode(String username) {
        NavigationConfiguration configuration = this.navigationConfigurationStorage.getConfiguration(this.defaultTopbarApplications);
        return this.getSidebarUserMode(username, configuration.getSidebar());
    }

    public void updateSidebarUserMode(String username, SidebarMode mode) {
        this.navigationConfigurationStorage.updateSidebarUserMode(username, mode);
    }

    public void updateConfiguration(NavigationConfiguration navigationConfiguration) {
        NavigationConfiguration existingConfiguration = this.getConfiguration();
        try {
            this.navigationConfigurationStorage.updateConfiguration(navigationConfiguration);
            this.listenerService.broadcast(NAVIGATION_CONFIGURATION_UPDATED_EVENT, (Object)existingConfiguration, (Object)navigationConfiguration);
        }
        finally {
            this.allowUserHome = navigationConfiguration.getSidebar().isAllowUserCustomHome();
        }
    }

    public List<TopbarApplication> getDefaultTopbarApplications() {
        if (this.defaultTopbarApplications == null) {
            this.defaultTopbarApplications = this.addonContainerService.getApplications(TOP_NAVIGATION_ADDON_CONTAINER).stream().map(this::toTopbarApplication).toList();
        }
        return this.defaultTopbarApplications;
    }

    public boolean isMetaSiteNavigation(String siteName) {
        if (this.getConfiguration() == null) {
            return false;
        }
        return this.getConfiguration().getSidebar().getItems().stream().anyMatch(sidebarItem -> sidebarItem.getProperties() != null && Objects.equals(sidebarItem.getProperties().get("siteName"), siteName) && SidebarItemType.SITE.equals((Object)sidebarItem.getType()));
    }

    private TopbarApplication toTopbarApplication(Application app) {
        String string;
        ApplicationState applicationState = app.getState();
        if (applicationState instanceof TransientApplicationState) {
            TransientApplicationState applicationState2 = (TransientApplicationState)applicationState;
            string = applicationState2.getContentId().split("/")[1];
        } else {
            string = "-";
        }
        String portletName = string;
        String applicationId = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{app.getId(), portletName});
        String applicationTitle = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{app.getTitle(), portletName});
        String applicationDescription = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{app.getDescription(), "-"});
        String applicationIcon = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{app.getIcon(), "far fa-question-circle"});
        return new TopbarApplication(applicationId, applicationTitle, applicationDescription, applicationIcon, TopbarItemType.APP, !StringUtils.equals((CharSequence)this.environment.getProperty(String.format(TOPBAR_APPLICATION_ENABLED_PATTERN, app.getId()), "true"), (CharSequence)"false"), !StringUtils.equals((CharSequence)this.environment.getProperty(String.format(TOPBAR_APPLICATION_MOBILE_PATTERN, app.getId()), "true"), (CharSequence)"false"), Collections.singletonMap("contentId", ((TransientApplicationState)app.getState()).getContentId()));
    }

    private SidebarMode getSidebarUserMode(String username, SidebarConfiguration sidebarConfiguration) {
        SidebarMode mode = this.navigationConfigurationStorage.getSidebarUserMode(username);
        if (!(sidebarConfiguration == null || mode != null && sidebarConfiguration.getAllowedModes().contains(mode))) {
            mode = sidebarConfiguration.getDefaultMode();
        }
        return mode;
    }

    private SidebarItem expandSidebarItem(SidebarItem item, String username, Locale locale) {
        return this.getPlugin(item.getType()).resolveProperties(item, username, locale);
    }

    private SidebarPlugin getPlugin(SidebarItemType type) {
        return this.menuPlugins == null ? DEFAULT_MENU_PLUGIN : this.menuPlugins.stream().filter(p -> p.getType() == type).findFirst().orElse(DEFAULT_MENU_PLUGIN);
    }

    @Generated
    public void setDefaultTopbarApplications(List<TopbarApplication> defaultTopbarApplications) {
        this.defaultTopbarApplications = defaultTopbarApplications;
    }

    @Generated
    public boolean isAllowUserHome() {
        return this.allowUserHome;
    }

    @Generated
    public void setAllowUserHome(boolean allowUserHome) {
        this.allowUserHome = allowUserHome;
    }

    static {
        NavigationConfigurationServiceImpl.ajc$preClinit();
        DEFAULT_MENU_PLUGIN = new DefaultSidebarPlugin();
    }

    static final /* synthetic */ void init_aroundBody0(NavigationConfigurationServiceImpl ajc$this, JoinPoint joinPoint) {
        ajc$this.defaultTopbarApplications = ajc$this.getDefaultTopbarApplications();
        NavigationConfiguration configuration = ajc$this.getConfiguration();
        if (configuration != null) {
            ajc$this.allowUserHome = configuration.getSidebar().isAllowUserCustomHome();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NavigationConfigurationServiceImpl.java", NavigationConfigurationServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "io.meeds.social.navigation.service.NavigationConfigurationServiceImpl", "", "", "", "void"), 98);
    }
}

