/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.rest;

import io.meeds.social.space.model.SpacePermissions;
import io.meeds.social.space.model.SpaceTemplatePatch;
import io.meeds.social.space.service.SpaceAdministrationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/space/administration"})
@Tag(name="/social/rest/space/administration", description="Managing spaces by platform administrators")
public class SpaceAdministrationRest {
    @Autowired
    private SpaceAdministrationService spacesAdministrationService;

    @GetMapping(value={"{spaceId}/permissions"})
    @Secured(value={"administrators"})
    @Operation(summary="Gets a space permissions settings", method="GET", description="This returns the space permissions settings: <br/><ul><li>Delete Permissions</li><li>Layout Permissions</li><li>Public Site Permissions</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Not found")})
    public SpacePermissions getSpacePermissions(@Parameter(description="Space template identifier") @PathVariable(value="spaceId") long spaceId) {
        try {
            return this.spacesAdministrationService.getSpacePermissions(spaceId);
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PutMapping(path={"{spaceId}/permissions"}, consumes={"application/json"})
    @Secured(value={"administrators"})
    @Operation(summary="Update a space permissions settings", method="PUT", description="This updates a space permissions settings: <br/><ul><li>Delete Permissions</li><li>Layout Permissions</li><li>Public Site Permissions</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Not found")})
    public void updateSpacePermissions(@Parameter(description="Space template identifier") @PathVariable(value="spaceId") long spaceId, @RequestBody(required=true) SpacePermissions permissions) {
        try {
            this.spacesAdministrationService.updateSpacePermissions(spaceId, permissions);
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PutMapping(path={"{spaceId}/template"}, consumes={"application/json"})
    @Secured(value={"administrators"})
    @Operation(summary="Update a space by applying a chosen template characteristics", method="PUT", description="This updates a space a space by applying a chosen template characteristics: <br/><ul><li>Layout</li><li>Editorial mode</li><li>Delete Permissions</li><li>Layout Permissions</li><li>Public Site Permissions</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Not found")})
    public void applySpaceTemplate(@Parameter(description="Space template identifier") @PathVariable(value="spaceId") long spaceId, @RequestBody(required=true) SpaceTemplatePatch templatePatch) {
        try {
            this.spacesAdministrationService.applySpaceTemplate(spaceId, templatePatch);
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }
}

