/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.model.ProfileLabel;
import org.exoplatform.social.core.profilelabel.ProfileLabelService;

@Path(value="v1/social/profile/label")
@Tag(name="v1/social/profile/label", description="Operations on labels")
public class ProfileLabelRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ProfileLabelRest.class);
    private final ProfileLabelService profileLabelService;

    public ProfileLabelRest(ProfileLabelService profileLabelService) {
        this.profileLabelService = profileLabelService;
    }

    @GET
    @Path(value="{type}/{id}/{language}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets  label for given object and language", method="GET", description="This returns label for given object and language")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getLabel(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Object type", required=true) @PathParam(value="type") String type, @Parameter(description="Object id", required=true) @PathParam(value="id") String id, @Parameter(description="language", required=true) @PathParam(value="language") String language) {
        try {
            ProfileLabel profileLabel = this.profileLabelService.findLabelByObjectTypeAndObjectIdAndLang(type, id, language);
            return Response.ok((Object)profileLabel).build();
        }
        catch (Exception e) {
            LOG.error("An error occurred while getting list of labels for object type {} and object id {} and language {}", new Object[]{type, id, language, e});
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="labels/{type}/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets all labels of given object", method="GET", description="This returns a list of labels for given object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getLabels(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Object type", required=true) @PathParam(value="type") String type, @Parameter(description="Object id", required=true) @PathParam(value="id") String id) {
        try {
            List profileLabels = this.profileLabelService.findLabelByObjectTypeAndObjectId(type, id);
            return Response.ok((Object)profileLabels).build();
        }
        catch (Exception e) {
            LOG.error("An error occurred while getting list of labels for object type {} and object id {}", new Object[]{type, id, e});
            return Response.status((int)500).build();
        }
    }

    @POST
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Creates a Profile label", method="POST", description="Creates a Profile label.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="409", description="Conflict")})
    public Response createLabel(@Context UriInfo uriInfo, @RequestBody(description="Profile label object to be created", required=true) ProfileLabel profileLabel) {
        if (profileLabel == null || profileLabel.getObjectType() == null || profileLabel.getLanguage() == null || profileLabel.getLabel() == null || profileLabel.getObjectId() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Profile label is null or an object property is not provided").build();
        }
        try {
            this.profileLabelService.createLabel(profileLabel);
            return Response.noContent().build();
        }
        catch (ObjectAlreadyExistsException ex) {
            LOG.warn("Cannot add a profile label with type {}, object Id {} and language {} , it is already created", new Object[]{profileLabel.getObjectType(), profileLabel.getObjectId(), profileLabel.getLanguage(), ex});
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (Exception ex) {
            LOG.warn("Failed to create a new profile label with type {}, object Id {} and language {}", new Object[]{profileLabel.getObjectType(), profileLabel.getObjectId(), profileLabel.getLanguage(), ex});
            return Response.status((int)500).build();
        }
    }

    @POST
    @Path(value="bulk")
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Creates a list of new Labels", method="POST", description="Creates a list of Labels.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation")})
    public Response createLabels(@Context UriInfo uriInfo, @Parameter(description="Object type", required=true) @RequestBody(description="Profile label object to be created", required=true) List<ProfileLabel> profileLabels) {
        if (profileLabels == null || profileLabels.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Labels list is empty").build();
        }
        try {
            for (ProfileLabel label : profileLabels) {
                this.profileLabelService.createLabel(label);
            }
            return Response.noContent().build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to create  the list of profile labels f", (Throwable)ex);
            return Response.status((int)500).build();
        }
    }

    @PUT
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Update a Profile label", method="PUT", description="update a Profile label.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response updateLabel(@Context UriInfo uriInfo, @RequestBody(description="Profile label object to be updated", required=true) ProfileLabel profileLabel) {
        if (profileLabel == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Profile label object is null").build();
        }
        try {
            this.profileLabelService.updateLabel(profileLabel);
            return Response.noContent().build();
        }
        catch (Exception ex) {
            LOG.warn("Failed to update the profile label with type {}, object Id {} and language {}", new Object[]{profileLabel.getObjectType(), profileLabel.getObjectId(), profileLabel.getLanguage(), ex});
            return Response.status((int)500).build();
        }
    }

    @PUT
    @Path(value="bulk")
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Update a Profile label", method="PUT", description="update a Profile label.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response updateLabels(@Context UriInfo uriInfo, @RequestBody(description="list of Labels to be updated", required=true) List<ProfileLabel> profileLabels) {
        if (profileLabels == null || profileLabels.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Profile label list is empty").build();
        }
        try {
            for (ProfileLabel label : profileLabels) {
                this.profileLabelService.updateLabel(label);
            }
            return Response.noContent().build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to merge profile labels for the object with type {} and Id {}", (Throwable)ex);
            return Response.status((int)500).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"administrators"})
    @Operation(summary="delete a label", method="DELETE", description="\"delete a label.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response deleteLabel(@Context UriInfo uriInfo, @RequestBody(description="Profile label object to be deleted", required=true) ProfileLabel profileLabel) {
        if (profileLabel == null || profileLabel.getId() == null || profileLabel.getId() == 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Profile label is null or id not provided").build();
        }
        try {
            this.profileLabelService.deleteLabel(profileLabel.getId().longValue());
            return Response.noContent().build();
        }
        catch (Exception ex) {
            LOG.warn("Failed to delete labels with type {}, object Id {} and language {}", new Object[]{profileLabel.getObjectType(), profileLabel.getObjectId(), profileLabel.getLanguage(), ex});
            return Response.status((int)500).build();
        }
    }

    @DELETE
    @Path(value="bulk")
    @RolesAllowed(value={"administrators"})
    @Operation(summary="delete a profile labels", method="DELETE", description="delete a list of Profile labels.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response deleteLabels(@Context UriInfo uriInfo, @RequestBody(description="list of Labels to be deleted", required=true) List<ProfileLabel> profileLabels) {
        if (profileLabels == null || profileLabels.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Profile label list is null or empty").build();
        }
        try {
            for (ProfileLabel label : profileLabels) {
                this.profileLabelService.deleteLabel(label.getId().longValue());
            }
            return Response.noContent().build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to delete list of profile labels", (Throwable)ex);
            return Response.status((int)500).build();
        }
    }
}

