/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.rest.client;

import io.meeds.tenant.hub.model.WomResponse;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.model.WomErrorMessage;
import io.meeds.wom.api.utils.JsonUtils;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.stereotype.Component;

@Component
public class WomConnectionService {
    private static final Log LOG = ExoLogger.getLogger(WomConnectionService.class);
    private static final int MAX_POOL_CONNECTIONS = Integer.parseInt(System.getProperty("meeds.http.clientPool.max", "5"));
    private HttpClient client;

    public String processGet(URI uri) throws WomException {
        return this.processRequest((HttpUriRequestBase)new HttpGet(uri));
    }

    public String processPost(URI uri, String jsonString) throws WomException {
        HttpPost request = new HttpPost(uri);
        StringEntity entity = new StringEntity(jsonString, ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)entity);
        return this.processRequest((HttpUriRequestBase)request);
    }

    public String processPut(URI uri, String jsonString) throws WomException {
        HttpPut request = new HttpPut(uri);
        StringEntity entity = new StringEntity(jsonString, ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)entity);
        return this.processRequest((HttpUriRequestBase)request);
    }

    public String processDelete(URI uri, String jsonString) throws WomException {
        HttpDelete request = new HttpDelete(uri);
        StringEntity entity = new StringEntity(jsonString, ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)entity);
        return this.processRequest((HttpUriRequestBase)request);
    }

    public String processRequest(HttpUriRequestBase request) throws WomException {
        boolean isSuccess;
        WomResponse response = (WomResponse)this.getHttpClient().execute((ClassicHttpRequest)request, this::handleHttpResponse);
        boolean bl = isSuccess = response != null && response.getCode() >= 200 && response.getCode() < 300;
        if (isSuccess) {
            return this.processSuccessResponse(response);
        }
        if (response != null && response.getCode() == 404) {
            return null;
        }
        this.processErrorResponse(response, request);
        return null;
    }

    private String processSuccessResponse(WomResponse response) {
        if (response.getCode() == 200 && StringUtils.isNotBlank((CharSequence)response.getEntity())) {
            return response.getEntity();
        }
        return null;
    }

    private void processErrorResponse(WomResponse response, HttpUriRequestBase request) throws WomException {
        if (response == null) {
            throw new WomException("wom.noResponse");
        }
        if (StringUtils.isNotBlank((CharSequence)response.getEntity())) {
            String errorMessage = response.getEntity();
            if (StringUtils.contains((CharSequence)errorMessage, (CharSequence)"wom.")) {
                if (StringUtils.contains((CharSequence)errorMessage, (CharSequence)"{")) {
                    try {
                        throw new WomException((WomErrorMessage)JsonUtils.fromJsonString((String)errorMessage, WomErrorMessage.class));
                    }
                    catch (WomException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.warn("Error parsing message '{}', throw the original error as it is", new Object[]{errorMessage, e});
                    }
                }
                throw new WomException(errorMessage);
            }
            throw new WomException(String.format("wom.errorResponse: %s. URL = %s %s", errorMessage, request.getMethod(), request.getUri()));
        }
        throw new WomException("wom.errorResponse:" + response.getCode());
    }

    private HttpClient getHttpClient() {
        if (this.client == null) {
            HttpClientConnectionManager clientConnectionManager = this.getClientConnectionManager();
            HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager(clientConnectionManager).setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy());
            this.client = httpClientBuilder.build();
        }
        return this.client;
    }

    private HttpClientConnectionManager getClientConnectionManager() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(MAX_POOL_CONNECTIONS);
        return connectionManager;
    }

    private WomResponse handleHttpResponse(ClassicHttpResponse httpResponse) {
        HttpEntity entity = httpResponse.getEntity();
        return new WomResponse(httpResponse.getCode(), entity == null ? null : EntityUtils.toString((HttpEntity)entity));
    }
}

