/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.ext.filter.impl;

import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;

public class UserACLFilter
implements UIExtensionFilter {
    protected List<String> permissions;

    @Override
    public boolean accept(Map<String, Object> context) throws Exception {
        if (this.permissions == null || this.permissions.isEmpty()) {
            return true;
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        UserACL userACL = (UserACL)container.getComponentInstance(UserACL.class);
        int length = this.permissions.size();
        for (int i = 0; i < length; ++i) {
            String permission = this.permissions.get(i);
            if (!userACL.hasPermission(ConversationState.getCurrent().getIdentity(), permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public UIExtensionFilterType getType() {
        return UIExtensionFilterType.MANDATORY;
    }

    @Override
    public void onDeny(Map<String, Object> context) throws Exception {
    }
}

