/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.Param;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.core.UIDropDownControl;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;

@ComponentConfigs(value={@ComponentConfig(template="system:/groovy/webui/form/UIFormInputIconSelector.gtmpl", events={@EventConfig(listeners={ChangeOptionSetActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeIconCategoryActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectIconActionListener.class}, phase=Event.Phase.DECODE)}, initParams={@ParamConfig(name="IconSet16x16", value="app:/WEB-INF/conf/uiconf/webui/component/IconSet16x16.groovy")}), @ComponentConfig(type=UIDropDownControl.class, id="IconDropDown", template="system:/groovy/webui/core/UIDropDownControlSelector.gtmpl", events={@EventConfig(listeners={SelectItemActionListener.class})})})
public class UIFormInputIconSelector
extends UIFormInputBase<String> {
    private List<String> optionSets = new ArrayList<String>();
    private List<IconSet> iconSets = new ArrayList<IconSet>();
    private String paramDefault = "IconSet16x16";
    private CategoryIcon selectedIconCategory;
    private IconSet selectedIconSet;
    private String selectedIcon;
    private String selectType = "page";
    public static final String[] SELECT_TYPE = new String[]{"portal", "page"};

    public UIFormInputIconSelector(String name, String bindingField) throws Exception {
        super(name, bindingField, String.class);
        this.setComponentConfig(UIFormInputIconSelector.class, null);
        this.addChild(UIDropDownControl.class, "IconDropDown", null);
        this.setValues(this.paramDefault);
        this.selectType = "page";
    }

    private List<SelectItemOption<String>> getDropOptions() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        for (String s : this.optionSets) {
            options.add(new SelectItemOption<String>(s));
        }
        return options;
    }

    public void setType(String type) {
        this.selectType = type;
    }

    public String getType() {
        return this.selectType;
    }

    public void setValues(String paramName) throws Exception {
        this.selectedIconCategory = null;
        this.selectedIconSet = null;
        this.selectedIcon = null;
        this.iconSets.clear();
        this.optionSets.clear();
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (context instanceof PortletRequestContext) {
            context = (WebuiRequestContext)context.getParentAppRequestContext();
        }
        for (Param param : this.getComponentConfig().getInitParams().getParams()) {
            if (param.getName().equals(paramName)) {
                CategoryIcon categoryIconSet = (CategoryIcon)param.getMapGroovyObject(context);
                if (this.selectedIconCategory == null) {
                    this.selectedIconCategory = categoryIconSet;
                }
                for (IconSet iconset : categoryIconSet.getCategory()) {
                    if (this.selectedIconSet == null) {
                        this.setSelectedIconSet(iconset);
                    }
                    IconCategory iconCategory = iconset.getIconCategory();
                    if (this.selectedIcon == null) {
                        this.setSelectedIcon((String)((List)iconCategory.getValue()).get(0));
                    }
                    this.iconSets.add(iconset);
                }
            }
            this.optionSets.add(param.getName());
            this.getChild(UIDropDownControl.class).setOptions(this.getDropOptions());
        }
    }

    public List<String> getOptionSets() {
        return this.optionSets;
    }

    public List<IconSet> getListIconSet() {
        return this.iconSets;
    }

    public CategoryIcon getSelectedCategory() {
        return this.selectedIconCategory;
    }

    public void setSelectedCategory(CategoryIcon category) {
        this.selectedIconCategory = category;
    }

    public IconSet getSelectedIconSet() {
        return this.selectedIconSet;
    }

    public void setSelectedIconSet(IconSet iconset) {
        this.selectedIconSet = iconset;
    }

    public List<String> getListIcon(IconSet set) {
        return (List)set.getIconCategory().getValue();
    }

    @Override
    public String getValue() {
        return this.getSelectedIcon();
    }

    @Override
    public UIFormInput setValue(String value) {
        this.selectedIcon = value;
        return this;
    }

    public void setSelectedIcon(String name) {
        this.selectedIcon = name;
    }

    public String getSelectedIcon() {
        if (this.selectedIcon != null) {
            return this.selectedIcon;
        }
        IconSet set = this.getSelectedIconSet();
        IconCategory iconCategory = set.getIconCategory();
        this.selectedIcon = (String)((List)iconCategory.getValue()).get(0);
        return this.selectedIcon;
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) {
        if (input == null || String.valueOf(input).length() < 1) {
            return;
        }
        this.selectedIcon = (String)input;
    }

    public static class CategoryIcon {
        private String name;
        private String sizeOption;
        private List<IconSet> category = new ArrayList<IconSet>();

        public CategoryIcon(String n, String s) {
            this.name = n;
            this.sizeOption = s;
        }

        public String getSizeOption() {
            return this.sizeOption;
        }

        public String getName() {
            return this.name;
        }

        public CategoryIcon addCategory(IconSet set) {
            this.category.add(set);
            return this;
        }

        public List<IconSet> getCategory() {
            return this.category;
        }
    }

    public static class IconSet {
        private String name;
        private IconCategory iconcate_ = null;
        private IconSet set_ = null;

        public IconSet(String n) {
            this.name = n;
        }

        public String getName() {
            return this.name;
        }

        public IconCategory getIconCategory() {
            return this.iconcate_;
        }

        public IconSet addCategories(IconCategory iconCate) {
            this.iconcate_ = iconCate;
            return this;
        }

        public IconSet getIconSet() {
            return this.set_;
        }

        public void addSets(IconSet set) {
            this.set_ = set;
        }
    }

    public static class IconCategory
    extends SelectItemOption<List<String>> {
        public IconCategory(String name) {
            super(name, new ArrayList());
        }

        public IconCategory addIcon(String icon) {
            ((List)this.value).add(icon);
            return this;
        }
    }

    public static class SelectItemActionListener
    extends EventListener<UIDropDownControl> {
        @Override
        public void execute(Event<UIDropDownControl> event) throws Exception {
            UIDropDownControl uiDropDown = event.getSource();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiDropDown);
        }
    }

    public static class SelectIconActionListener
    extends EventListener<UIFormInputIconSelector> {
        @Override
        public void execute(Event<UIFormInputIconSelector> event) throws Exception {
            UIFormInputIconSelector uiIconSelector = event.getSource();
            String iconName = event.getRequestContext().getRequestParameter("objectId");
            if (iconName.equals("Default")) {
                uiIconSelector.setSelectedIcon("Default");
                for (IconSet set : uiIconSelector.getListIconSet()) {
                    if (!set.getName().equals("misc")) continue;
                    uiIconSelector.setSelectedIconSet(set);
                }
                UIForm uiForm = uiIconSelector.getAncestorOfType(UIForm.class);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm);
                return;
            }
            uiIconSelector.setSelectedIcon(iconName);
            UIForm uiForm = uiIconSelector.getAncestorOfType(UIForm.class);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm);
        }
    }

    public static class ChangeIconCategoryActionListener
    extends EventListener<UIFormInputIconSelector> {
        @Override
        public void execute(Event<UIFormInputIconSelector> event) throws Exception {
            UIFormInputIconSelector uiIconSelector = event.getSource();
            String setName = event.getRequestContext().getRequestParameter("objectId");
            uiIconSelector.setSelectedIcon(null);
            for (IconSet set : uiIconSelector.getListIconSet()) {
                if (!set.getName().equals(setName)) continue;
                uiIconSelector.setSelectedIconSet(set);
            }
            UIForm uiForm = uiIconSelector.getAncestorOfType(UIForm.class);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm);
        }
    }

    public static class ChangeOptionSetActionListener
    extends EventListener<UIFormInputIconSelector> {
        @Override
        public void execute(Event<UIFormInputIconSelector> event) throws Exception {
            UIFormInputIconSelector uiForm = event.getSource();
            String paramName = event.getRequestContext().getRequestParameter("objectId");
            uiForm.setValues(paramName);
        }
    }
}

