/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.slm.Statistics;
import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Slm
extends Base {
    @Nullable
    private final Integer policyCount;
    @Nullable
    private final Statistics policyStats;
    public static final JsonpDeserializer<Slm> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Slm::setupSlmDeserializer);

    private Slm(Builder builder) {
        super(builder);
        this.policyCount = builder.policyCount;
        this.policyStats = builder.policyStats;
    }

    public static Slm of(Function<Builder, ObjectBuilder<Slm>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer policyCount() {
        return this.policyCount;
    }

    @Nullable
    public final Statistics policyStats() {
        return this.policyStats;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.policyCount != null) {
            generator.writeKey("policy_count");
            generator.write(this.policyCount.intValue());
        }
        if (this.policyStats != null) {
            generator.writeKey("policy_stats");
            this.policyStats.serialize(generator, mapper);
        }
    }

    protected static void setupSlmDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::policyCount, JsonpDeserializer.integerDeserializer(), "policy_count");
        op.add(Builder::policyStats, Statistics._DESERIALIZER, "policy_stats");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Slm> {
        @Nullable
        private Integer policyCount;
        @Nullable
        private Statistics policyStats;

        public final Builder policyCount(@Nullable Integer value) {
            this.policyCount = value;
            return this;
        }

        public final Builder policyStats(@Nullable Statistics value) {
            this.policyStats = value;
            return this;
        }

        public final Builder policyStats(Function<Statistics.Builder, ObjectBuilder<Statistics>> fn) {
            return this.policyStats(fn.apply(new Statistics.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Slm build() {
            this._checkSingleUse();
            return new Slm(this);
        }
    }
}

