/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.spi;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.model.SpaceExternalInvitation;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleListener;

public interface SpaceService {
    default public Space getSpaceByPrettyName(String spacePrettyName) {
        throw new UnsupportedOperationException();
    }

    default public Space getSpaceByGroupId(String groupId) {
        throw new UnsupportedOperationException();
    }

    default public Space getSpaceById(String spaceId) {
        try {
            return this.getSpaceById(Long.parseLong(spaceId));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    default public Space getSpaceById(long spaceId) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getAllSpacesWithListAccess() {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getAllSpacesByFilter(SpaceFilter spaceFilter) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getManagerSpaces(String username) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getManagerSpacesByFilter(String username, SpaceFilter spaceFilter) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getEditableSpacesByFilter(String username, SpaceFilter spaceFilter) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getMemberSpaces(String username) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getMemberSpacesByFilter(String username, SpaceFilter spaceFilter) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getFavoriteSpacesByFilter(String username, SpaceFilter spaceFilter) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getAccessibleSpacesWithListAccess(String username) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getAccessibleSpacesByFilter(String username, SpaceFilter spaceFilter) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getInvitedSpacesWithListAccess(String username) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getInvitedSpacesByFilter(String username, SpaceFilter spaceFilter) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getPendingSpacesWithListAccess(String username) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getPendingSpacesByFilter(String username, SpaceFilter spaceFilter) {
        throw new UnsupportedOperationException();
    }

    default public Space createSpace(Space space, String creatorUsername) {
        throw new UnsupportedOperationException();
    }

    default public Space updateSpace(Space existingSpace, List<Identity> identitiesToInvite) {
        throw new UnsupportedOperationException();
    }

    default public Space updateSpace(Space existingSpace) {
        throw new UnsupportedOperationException();
    }

    default public Space updateSpaceAvatar(Space existingSpace, String username) {
        throw new UnsupportedOperationException();
    }

    default public Space updateSpaceBanner(Space existingSpace, String username) {
        throw new UnsupportedOperationException();
    }

    default public void deleteSpace(Space space) throws SpaceException {
        throw new UnsupportedOperationException();
    }

    default public void deleteSpace(Space space, boolean deleteGroup) throws SpaceException {
    }

    default public void addPendingUser(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public void removePendingUser(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public boolean isPendingUser(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public void addInvitedUser(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public void removeInvitedUser(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public boolean isInvitedUser(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public void addMember(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public void removeMember(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public boolean isMember(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public void addRedactor(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public void removeRedactor(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public boolean isRedactor(Space space, String username) {
        return false;
    }

    default public void addPublisher(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public void removePublisher(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public boolean isPublisher(Space space, String username) {
        return false;
    }

    default public boolean hasRedactor(Space space) {
        return false;
    }

    default public boolean canRedactOnSpace(Space space, org.exoplatform.services.security.Identity viewer) {
        return viewer != null && this.canRedactOnSpace(space, viewer.getUserId());
    }

    default public boolean canRedactOnSpace(Space space, String username) {
        if (username == null) {
            return false;
        }
        if (this.isMember(space, username) && (!this.hasRedactor(space) || this.isRedactor(space, username) || this.isManager(space, username))) {
            return true;
        }
        return this.isSuperManager(space, username);
    }

    default public boolean canPublishOnSpace(Space space, String username) {
        if (username == null) {
            return false;
        }
        if (this.isMember(space, username) && (this.isPublisher(space, username) || this.isManager(space, username))) {
            return true;
        }
        return this.isSuperManager(space, username) || this.isContentPublisher(username);
    }

    default public boolean canManageSpace(Space space, String username) {
        if (username == null || space == null) {
            return false;
        }
        if (this.isMember(space, username) && this.isManager(space, username)) {
            return true;
        }
        return this.isSuperManager(space, username);
    }

    default public boolean canManageSpacePublicSite(Space space, String username) {
        return false;
    }

    default public boolean canManageSpaceLayout(Space space, String username) {
        return false;
    }

    default public boolean canDeleteSpace(Space space, String username) {
        return this.canManageSpace(space, username);
    }

    default public boolean canViewSpace(Space space, String username) {
        if (username == null) {
            return false;
        }
        if (this.isMember(space, username)) {
            return true;
        }
        return this.isSuperManager(space, username);
    }

    default public boolean canAccessSpacePublicSite(Space space, String username) {
        return false;
    }

    default public void setManager(Space space, String username, boolean isManager) {
        throw new UnsupportedOperationException();
    }

    default public boolean isManager(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public boolean isOnlyManager(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public boolean hasAccessPermission(Space space, String username) {
        return this.canViewSpace(space, username);
    }

    default public boolean hasSettingPermission(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public void registerSpaceListenerPlugin(SpaceListenerPlugin spaceListenerPlugin) {
        throw new UnsupportedOperationException();
    }

    default public void unregisterSpaceListenerPlugin(SpaceListenerPlugin spaceListenerPlugin) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getVisibleSpacesWithListAccess(String username, SpaceFilter spaceFilter) {
        throw new UnsupportedOperationException();
    }

    default public Space createSpace(Space space, String creator, List<Identity> identitiesToInvite) throws SpaceException {
        throw new UnsupportedOperationException();
    }

    default public Space createSpace(Space space) {
        throw new UnsupportedOperationException();
    }

    default public void renameSpace(Space space, String newDisplayName) {
        throw new UnsupportedOperationException();
    }

    default public void renameSpace(Space space, String newDisplayName, String username) throws SpaceException {
        throw new UnsupportedOperationException();
    }

    default public void deleteSpace(String spaceId) throws SpaceException {
        this.deleteSpace(this.getSpaceById(spaceId));
    }

    default public void addMember(String spaceId, String username) {
        this.addMember(this.getSpaceById(spaceId), username);
    }

    default public void removeMember(String spaceId, String username) {
        this.removeMember(this.getSpaceById(spaceId), username);
    }

    default public boolean isMember(String spaceId, String username) {
        return this.isMember(this.getSpaceById(spaceId), username);
    }

    default public boolean isIgnored(Space space, String username) {
        return false;
    }

    default public void setIgnored(String spaceId, String username) {
        throw new UnsupportedOperationException();
    }

    default public void updateSpaceAccessed(String remoteId, Space space) {
        throw new UnsupportedOperationException();
    }

    default public List<Space> getLastSpaces(int limit) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getLastAccessedSpace(String remoteId) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getLastAccessedSpaceByFilter(String username, SpaceFilter spaceFilter) {
        throw new UnsupportedOperationException();
    }

    default public void registerSpaceLifeCycleListener(SpaceLifeCycleListener listener) {
        throw new UnsupportedOperationException();
    }

    default public void unregisterSpaceLifeCycleListener(SpaceLifeCycleListener listener) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getVisitedSpaces(String remoteId) {
        throw new UnsupportedOperationException();
    }

    default public boolean isSuperManager(String username) {
        throw new UnsupportedOperationException();
    }

    default public boolean isSuperManager(long spaceId, String username) {
        return this.isSuperManager(this.getSpaceById(spaceId), username);
    }

    default public boolean isSuperManager(Space space, String username) {
        return this.isSuperManager(username);
    }

    default public boolean isContentManager(String username) {
        return this.isSuperManager(username);
    }

    default public boolean isContentPublisher(String username) {
        return this.isSuperManager(username);
    }

    default public void inviteIdentities(Space space, List<Identity> identitiesToInvite) {
        throw new UnsupportedOperationException();
    }

    default public boolean isSpaceContainsExternals(Long spaceId) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getPendingSpaceRequestsToManage(String remoteId) {
        throw new UnsupportedOperationException();
    }

    default public List<SpaceExternalInvitation> findSpaceExternalInvitationsBySpaceId(String spaceId) {
        throw new UnsupportedOperationException();
    }

    default public void saveSpaceExternalInvitation(String spaceId, String email, String tokenId) {
        throw new UnsupportedOperationException();
    }

    default public SpaceExternalInvitation getSpaceExternalInvitationById(String invitationId) {
        throw new UnsupportedOperationException();
    }

    default public void deleteSpaceExternalInvitation(String invitationId) {
        throw new UnsupportedOperationException();
    }

    default public List<String> findExternalInvitationsSpacesByEmail(String email) {
        throw new UnsupportedOperationException();
    }

    default public void deleteExternalUserInvitations(String email) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getCommonSpaces(String username, String otherUsername) {
        throw new UnsupportedOperationException();
    }

    default public List<String> getMemberSpacesIds(String username, int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    default public List<String> getManagerSpacesIds(String username, int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    default public Instant getSpaceMembershipDate(long spaceId, String username) {
        throw new UnsupportedOperationException();
    }

    default public void saveSpacePublicSite(String spaceId, String publicSiteVisibility, String username) throws ObjectNotFoundException, IllegalAccessException {
        throw new UnsupportedOperationException();
    }

    default public void saveSpacePublicSite(Space space, String publicSiteVisibility) {
        throw new UnsupportedOperationException();
    }

    default public String getSpacePublicSiteName(Space space) {
        throw new UnsupportedOperationException();
    }

    default public Map<Long, Long> countSpacesByTemplate() {
        throw new UnsupportedOperationException();
    }

    default public List<Long> getSpaceCategoryIds() {
        throw new UnsupportedOperationException();
    }
}

