/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.service;

import org.web3j.crypto.HSMPass;
import org.web3j.crypto.Hash;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.Sign;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.service.HSMRequestProcessor;
import org.web3j.service.TxSignService;

public class TxHSMSignService<T extends HSMPass>
implements TxSignService {
    private final T hsmPass;
    private final HSMRequestProcessor<T> hsmRequestProcessor;

    public TxHSMSignService(HSMRequestProcessor<T> hsmRequestProcessor, T hsmPass) {
        this.hsmPass = hsmPass;
        this.hsmRequestProcessor = hsmRequestProcessor;
    }

    @Override
    public byte[] sign(RawTransaction rawTransaction, long chainId) {
        boolean isLegacy = chainId > -1L && rawTransaction.getType().equals((Object)TransactionType.LEGACY);
        byte[] encodedTransaction = isLegacy ? TransactionEncoder.encode((RawTransaction)rawTransaction, (long)chainId) : TransactionEncoder.encode((RawTransaction)rawTransaction);
        byte[] messageHash = Hash.sha3((byte[])encodedTransaction);
        Sign.SignatureData signatureData = this.hsmRequestProcessor.callHSM(messageHash, this.hsmPass);
        if (isLegacy) {
            signatureData = TransactionEncoder.createEip155SignatureData((Sign.SignatureData)signatureData, (long)chainId);
        }
        byte[] finalBytes = TransactionEncoder.encode((RawTransaction)rawTransaction, (Sign.SignatureData)signatureData);
        return finalBytes;
    }

    @Override
    public String getAddress() {
        return this.hsmPass.getAddress();
    }
}

