/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.PropertyValueException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.action.internal.CollectionRecreateAction;
import org.hibernate.action.internal.CollectionRemoveAction;
import org.hibernate.action.internal.CollectionUpdateAction;
import org.hibernate.action.internal.EntityActionVetoException;
import org.hibernate.action.internal.EntityDeleteAction;
import org.hibernate.action.internal.EntityIdentityInsertAction;
import org.hibernate.action.internal.EntityInsertAction;
import org.hibernate.action.internal.EntityUpdateAction;
import org.hibernate.action.internal.OrphanRemovalAction;
import org.hibernate.action.internal.QueuedOperationCollectionAction;
import org.hibernate.action.internal.UnresolvedEntityInsertActions;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.action.spi.Executable;
import org.hibernate.cache.CacheException;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.spi.ComparableExecutable;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExecutableList;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;

public class ActionQueue {
    private static final @UnknownKeyFor @NonNull @Initialized CoreMessageLogger LOG = CoreLogging.messageLogger(ActionQueue.class);
    private final @UnknownKeyFor @NonNull @Initialized SessionImplementor session;
    private @UnknownKeyFor @NonNull @Initialized UnresolvedEntityInsertActions unresolvedInsertions;
    private @UnknownKeyFor @NonNull @Initialized ExecutableList<@UnknownKeyFor @NonNull @Initialized AbstractEntityInsertAction> insertions;
    private @UnknownKeyFor @NonNull @Initialized ExecutableList<@UnknownKeyFor @NonNull @Initialized EntityDeleteAction> deletions;
    private @UnknownKeyFor @NonNull @Initialized ExecutableList<@UnknownKeyFor @NonNull @Initialized EntityUpdateAction> updates;
    private @UnknownKeyFor @NonNull @Initialized ExecutableList<@UnknownKeyFor @NonNull @Initialized CollectionRecreateAction> collectionCreations;
    private @UnknownKeyFor @NonNull @Initialized ExecutableList<@UnknownKeyFor @NonNull @Initialized CollectionUpdateAction> collectionUpdates;
    private @UnknownKeyFor @NonNull @Initialized ExecutableList<@UnknownKeyFor @NonNull @Initialized QueuedOperationCollectionAction> collectionQueuedOps;
    private @UnknownKeyFor @NonNull @Initialized ExecutableList<@UnknownKeyFor @NonNull @Initialized CollectionRemoveAction> collectionRemovals;
    private @UnknownKeyFor @NonNull @Initialized ExecutableList<@UnknownKeyFor @NonNull @Initialized CollectionRemoveAction> orphanCollectionRemovals;
    private @UnknownKeyFor @NonNull @Initialized ExecutableList<@UnknownKeyFor @NonNull @Initialized OrphanRemovalAction> orphanRemovals;
    private transient @UnknownKeyFor @NonNull @Initialized boolean isTransactionCoordinatorShared;
    private @UnknownKeyFor @NonNull @Initialized AfterTransactionCompletionProcessQueue afterTransactionProcesses;
    private @UnknownKeyFor @NonNull @Initialized BeforeTransactionCompletionProcessQueue beforeTransactionProcesses;
    private static final @UnknownKeyFor @NonNull @Initialized OrderedActions @UnknownKeyFor @NonNull @Initialized [] ORDERED_OPERATIONS = OrderedActions.values();

    public ActionQueue(@UnknownKeyFor @NonNull @Initialized SessionImplementor session) {
        this.session = session;
        this.isTransactionCoordinatorShared = false;
    }

    public void clear() {
        for (OrderedActions value : ORDERED_OPERATIONS) {
            ExecutableList<?> list = value.getActions(this);
            if (list == null) continue;
            list.clear();
        }
        if (this.unresolvedInsertions != null) {
            this.unresolvedInsertions.clear();
        }
    }

    public void addAction(@UnknownKeyFor @NonNull @Initialized EntityInsertAction action) {
        LOG.tracev("Adding an EntityInsertAction for [{0}] object", action.getEntityName());
        this.addInsertAction(action);
    }

    private void addInsertAction(@UnknownKeyFor @NonNull @Initialized AbstractEntityInsertAction insert) {
        NonNullableTransientDependencies nonNullableTransientDependencies;
        if (insert.isEarlyInsert()) {
            LOG.tracev("Executing inserts before finding non-nullable transient entities for early insert: [{0}]", insert);
            this.executeInserts();
        }
        if ((nonNullableTransientDependencies = insert.findNonNullableTransientEntities()) == null) {
            LOG.tracev("Adding insert with no non-nullable, transient entities: [{0}]", insert);
            this.addResolvedEntityInsertAction(insert);
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Adding insert with non-nullable, transient entities; insert=[{0}], dependencies=[{1}]", insert, nonNullableTransientDependencies.toLoggableString(insert.getSession()));
            }
            if (this.unresolvedInsertions == null) {
                this.unresolvedInsertions = new UnresolvedEntityInsertActions();
            }
            this.unresolvedInsertions.addUnresolvedEntityInsertAction(insert, nonNullableTransientDependencies);
        }
    }

    private void addResolvedEntityInsertAction(@UnknownKeyFor @NonNull @Initialized AbstractEntityInsertAction insert) {
        if (insert.isEarlyInsert()) {
            LOG.trace("Executing insertions before resolved early-insert");
            this.executeInserts();
            LOG.debug("Executing identity-insert immediately");
            this.execute(insert);
        } else {
            LOG.trace("Adding resolved non-early insert action.");
            OrderedActions.EntityInsertAction.ensureInitialized(this);
            this.insertions.add(insert);
        }
        if (!insert.isVeto()) {
            insert.makeEntityManaged();
            if (this.unresolvedInsertions != null) {
                for (AbstractEntityInsertAction resolvedAction : this.unresolvedInsertions.resolveDependentActions(insert.getInstance(), this.session)) {
                    this.addResolvedEntityInsertAction(resolvedAction);
                }
            }
        } else {
            throw new EntityActionVetoException("The EntityInsertAction was vetoed.", insert);
        }
    }

    public void addAction(@UnknownKeyFor @NonNull @Initialized EntityIdentityInsertAction action) {
        LOG.tracev("Adding an EntityIdentityInsertAction for [{0}] object", action.getEntityName());
        this.addInsertAction(action);
    }

    public void addAction(@UnknownKeyFor @NonNull @Initialized EntityDeleteAction action) {
        OrderedActions.EntityDeleteAction.ensureInitialized(this);
        this.deletions.add(action);
    }

    public void addAction(@UnknownKeyFor @NonNull @Initialized OrphanRemovalAction action) {
        OrderedActions.OrphanRemovalAction.ensureInitialized(this);
        this.orphanRemovals.add(action);
    }

    public void addAction(@UnknownKeyFor @NonNull @Initialized EntityUpdateAction action) {
        OrderedActions.EntityUpdateAction.ensureInitialized(this);
        this.updates.add(action);
    }

    public void addAction(@UnknownKeyFor @NonNull @Initialized CollectionRecreateAction action) {
        OrderedActions.CollectionRecreateAction.ensureInitialized(this);
        this.collectionCreations.add(action);
    }

    public void addAction(@UnknownKeyFor @NonNull @Initialized CollectionRemoveAction action) {
        if (this.orphanRemovals != null && action.getAffectedOwner() != null && this.session.getPersistenceContextInternal().getEntry(action.getAffectedOwner()).getStatus().isDeletedOrGone()) {
            for (OrphanRemovalAction orphanRemoval : this.orphanRemovals) {
                if (orphanRemoval.getInstance() != action.getAffectedOwner()) continue;
                OrderedActions.OrphanCollectionRemoveAction.ensureInitialized(this);
                this.orphanCollectionRemovals.add(action);
                return;
            }
        }
        OrderedActions.CollectionRemoveAction.ensureInitialized(this);
        this.collectionRemovals.add(action);
    }

    public void addAction(@UnknownKeyFor @NonNull @Initialized CollectionUpdateAction action) {
        OrderedActions.CollectionUpdateAction.ensureInitialized(this);
        this.collectionUpdates.add(action);
    }

    public void addAction(@UnknownKeyFor @NonNull @Initialized QueuedOperationCollectionAction action) {
        OrderedActions.QueuedOperationCollectionAction.ensureInitialized(this);
        this.collectionQueuedOps.add(action);
    }

    public void addAction(@UnknownKeyFor @NonNull @Initialized BulkOperationCleanupAction action) {
        this.registerCleanupActions(action);
    }

    private void registerCleanupActions(@UnknownKeyFor @NonNull @Initialized Executable executable) {
        if (executable.getBeforeTransactionCompletionProcess() != null) {
            if (this.beforeTransactionProcesses == null) {
                this.beforeTransactionProcesses = new BeforeTransactionCompletionProcessQueue(this.session);
            }
            this.beforeTransactionProcesses.register(executable.getBeforeTransactionCompletionProcess());
        }
        if (this.session.getFactory().getSessionFactoryOptions().isQueryCacheEnabled()) {
            this.invalidateSpaces(executable.getPropertySpaces());
        }
        if (executable.getAfterTransactionCompletionProcess() != null) {
            if (this.afterTransactionProcesses == null) {
                this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
            }
            this.afterTransactionProcesses.register(executable.getAfterTransactionCompletionProcess());
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasUnresolvedEntityInsertActions() {
        return this.unresolvedInsertions != null && !this.unresolvedInsertions.isEmpty();
    }

    public void checkNoUnresolvedActionsAfterOperation() throws @UnknownKeyFor @NonNull @Initialized PropertyValueException {
        if (this.unresolvedInsertions != null) {
            this.unresolvedInsertions.checkNoUnresolvedActionsAfterOperation();
        }
    }

    public void registerProcess(@UnknownKeyFor @NonNull @Initialized AfterTransactionCompletionProcess process) {
        if (this.afterTransactionProcesses == null) {
            this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
        }
        this.afterTransactionProcesses.register(process);
    }

    public void registerProcess(@UnknownKeyFor @NonNull @Initialized BeforeTransactionCompletionProcess process) {
        if (this.beforeTransactionProcesses == null) {
            this.beforeTransactionProcesses = new BeforeTransactionCompletionProcessQueue(this.session);
        }
        this.beforeTransactionProcesses.register(process);
    }

    public void executeInserts() throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        if (this.insertions != null && !this.insertions.isEmpty()) {
            this.executeActions(this.insertions);
        }
    }

    public void executeActions() throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        if (this.hasUnresolvedEntityInsertActions()) {
            throw new IllegalStateException("About to execute actions, but there are unresolved entity insert actions.");
        }
        for (OrderedActions action : ORDERED_OPERATIONS) {
            this.executeActions(action.getActions(this));
        }
    }

    public void prepareActions() throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        this.prepareActions(this.collectionRemovals);
        this.prepareActions(this.collectionUpdates);
        this.prepareActions(this.collectionCreations);
        this.prepareActions(this.collectionQueuedOps);
    }

    private void prepareActions(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized ExecutableList<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> queue) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        if (queue == null) {
            return;
        }
        for (Executable executable : queue) {
            executable.beforeExecutions();
        }
    }

    public void afterTransactionCompletion(@UnknownKeyFor @NonNull @Initialized boolean success) {
        if (!this.isTransactionCoordinatorShared && this.afterTransactionProcesses != null) {
            this.afterTransactionProcesses.afterTransactionCompletion(success);
        }
    }

    public void beforeTransactionCompletion() {
        if (!this.isTransactionCoordinatorShared && this.beforeTransactionProcesses != null) {
            this.beforeTransactionProcesses.beforeTransactionCompletion();
            this.session.getJdbcCoordinator().executeBatch();
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean areInsertionsOrDeletionsQueued() {
        return this.insertions != null && !this.insertions.isEmpty() || this.hasUnresolvedEntityInsertActions() || this.deletions != null && !this.deletions.isEmpty() || this.orphanRemovals != null && !this.orphanRemovals.isEmpty();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean areTablesToBeUpdated(@UnknownKeyFor @NonNull @Initialized Set<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Serializable> tables) {
        if (tables.isEmpty()) {
            return false;
        }
        for (OrderedActions action : ORDERED_OPERATIONS) {
            ExecutableList<?> list = action.getActions(this);
            if (!ActionQueue.areTablesToBeUpdated(list, tables)) continue;
            return true;
        }
        if (this.unresolvedInsertions == null) {
            return false;
        }
        return ActionQueue.areTablesToBeUpdated(this.unresolvedInsertions, tables);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean areTablesToBeUpdated(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized ExecutableList<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> actions, @UnknownKeyFor @NonNull @Initialized Set<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Serializable> tableSpaces) {
        if (actions == null || actions.isEmpty()) {
            return false;
        }
        for (Serializable actionSpace : actions.getQuerySpaces()) {
            if (!tableSpaces.contains(actionSpace)) continue;
            LOG.debugf("Changes must be flushed to space: %s", actionSpace);
            return true;
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean areTablesToBeUpdated(@UnknownKeyFor @NonNull @Initialized UnresolvedEntityInsertActions actions, @UnknownKeyFor @NonNull @Initialized Set<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Serializable> tableSpaces) {
        for (Executable executable : actions.getDependentEntityInsertActions()) {
            String[] spaces;
            for (String space : spaces = executable.getPropertySpaces()) {
                if (!tableSpaces.contains(space)) continue;
                LOG.debugf("Changes must be flushed to space: %s", space);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends ComparableExecutable> void executeActions(@Nullable @UnknownKeyFor @Initialized ExecutableList<E> list) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        if (list == null || list.isEmpty()) {
            return;
        }
        try {
            for (ComparableExecutable e : list) {
                try {
                    e.execute();
                }
                finally {
                    if (e.getBeforeTransactionCompletionProcess() != null) {
                        if (this.beforeTransactionProcesses == null) {
                            this.beforeTransactionProcesses = new BeforeTransactionCompletionProcessQueue(this.session);
                        }
                        this.beforeTransactionProcesses.register(e.getBeforeTransactionCompletionProcess());
                    }
                    if (e.getAfterTransactionCompletionProcess() == null) continue;
                    if (this.afterTransactionProcesses == null) {
                        this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
                    }
                    this.afterTransactionProcesses.register(e.getAfterTransactionCompletionProcess());
                }
            }
        }
        finally {
            if (this.session.getFactory().getSessionFactoryOptions().isQueryCacheEnabled()) {
                this.invalidateSpaces(list.getQuerySpaces().toArray(new String[0]));
            }
        }
        list.clear();
        this.session.getJdbcCoordinator().executeBatch();
    }

    public <E extends Executable & Comparable<?>> void execute(E executable) {
        try {
            executable.execute();
        }
        finally {
            this.registerCleanupActions(executable);
        }
    }

    private void invalidateSpaces(@UnknownKeyFor @NonNull @Initialized String @Nullable @UnknownKeyFor @Initialized [] spaces) {
        if (spaces != null && spaces.length > 0) {
            for (String space : spaces) {
                if (this.afterTransactionProcesses == null) {
                    this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
                }
                this.afterTransactionProcesses.addSpaceToInvalidate(space);
            }
            this.session.getFactory().getCache().getTimestampsCache().preInvalidate(spaces, this.session);
        }
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "ActionQueue[insertions=" + ActionQueue.toString(this.insertions) + " updates=" + ActionQueue.toString(this.updates) + " deletions=" + ActionQueue.toString(this.deletions) + " orphanRemovals=" + ActionQueue.toString(this.orphanRemovals) + " collectionCreations=" + ActionQueue.toString(this.collectionCreations) + " collectionRemovals=" + ActionQueue.toString(this.collectionRemovals) + " collectionUpdates=" + ActionQueue.toString(this.collectionUpdates) + " collectionQueuedOps=" + ActionQueue.toString(this.collectionQueuedOps) + " unresolvedInsertDependencies=" + this.unresolvedInsertions + "]";
    }

    private static @UnknownKeyFor @NonNull @Initialized String toString(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized ExecutableList<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> q) {
        return q == null ? "ExecutableList{size=0}" : q.toString();
    }

    public @UnknownKeyFor @NonNull @Initialized int numberOfCollectionRemovals() {
        if (this.collectionRemovals == null) {
            return 0;
        }
        return this.collectionRemovals.size();
    }

    public @UnknownKeyFor @NonNull @Initialized int numberOfCollectionUpdates() {
        if (this.collectionUpdates == null) {
            return 0;
        }
        return this.collectionUpdates.size();
    }

    public @UnknownKeyFor @NonNull @Initialized int numberOfCollectionCreations() {
        if (this.collectionCreations == null) {
            return 0;
        }
        return this.collectionCreations.size();
    }

    public @UnknownKeyFor @NonNull @Initialized int numberOfDeletions() {
        int del = this.deletions == null ? 0 : this.deletions.size();
        int orph = this.orphanRemovals == null ? 0 : this.orphanRemovals.size();
        return del + orph;
    }

    public @UnknownKeyFor @NonNull @Initialized int numberOfUpdates() {
        if (this.updates == null) {
            return 0;
        }
        return this.updates.size();
    }

    public @UnknownKeyFor @NonNull @Initialized int numberOfInsertions() {
        if (this.insertions == null) {
            return 0;
        }
        return this.insertions.size();
    }

    public @UnknownKeyFor @NonNull @Initialized TransactionCompletionProcesses getTransactionCompletionProcesses() {
        if (this.beforeTransactionProcesses == null) {
            this.beforeTransactionProcesses = new BeforeTransactionCompletionProcessQueue(this.session);
        }
        if (this.afterTransactionProcesses == null) {
            this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
        }
        return new TransactionCompletionProcesses(this.beforeTransactionProcesses, this.afterTransactionProcesses);
    }

    public void setTransactionCompletionProcesses(@UnknownKeyFor @NonNull @Initialized TransactionCompletionProcesses processes, @UnknownKeyFor @NonNull @Initialized boolean isTransactionCoordinatorShared) {
        this.isTransactionCoordinatorShared = isTransactionCoordinatorShared;
        this.beforeTransactionProcesses = processes.beforeTransactionCompletionProcesses;
        this.afterTransactionProcesses = processes.afterTransactionCompletionProcesses;
    }

    public void sortCollectionActions() {
        if (this.isOrderUpdatesEnabled()) {
            if (this.collectionCreations != null) {
                this.collectionCreations.sort();
            }
            if (this.collectionUpdates != null) {
                this.collectionUpdates.sort();
            }
            if (this.collectionQueuedOps != null) {
                this.collectionQueuedOps.sort();
            }
            if (this.collectionRemovals != null) {
                this.collectionRemovals.sort();
            }
        }
    }

    public void sortActions() {
        if (this.isOrderUpdatesEnabled() && this.updates != null) {
            this.updates.sort();
        }
        if (this.isOrderInsertsEnabled() && this.insertions != null) {
            this.insertions.sort();
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isOrderUpdatesEnabled() {
        return this.session.getFactory().getSessionFactoryOptions().isOrderUpdatesEnabled();
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isOrderInsertsEnabled() {
        return this.session.getFactory().getSessionFactoryOptions().isOrderInsertsEnabled();
    }

    public void clearFromFlushNeededCheck(@UnknownKeyFor @NonNull @Initialized int previousCollectionRemovalSize) {
        if (this.collectionCreations != null) {
            this.collectionCreations.clear();
        }
        if (this.collectionUpdates != null) {
            this.collectionUpdates.clear();
        }
        if (this.collectionQueuedOps != null) {
            this.collectionQueuedOps.clear();
        }
        if (this.updates != null) {
            this.updates.clear();
        }
        if (this.collectionRemovals != null && this.collectionRemovals.size() > previousCollectionRemovalSize) {
            this.collectionRemovals.removeLastN(this.collectionRemovals.size() - previousCollectionRemovalSize);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasAfterTransactionActions() {
        return this.isTransactionCoordinatorShared ? false : this.afterTransactionProcesses != null && this.afterTransactionProcesses.hasActions();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasBeforeTransactionActions() {
        return this.isTransactionCoordinatorShared ? false : this.beforeTransactionProcesses != null && this.beforeTransactionProcesses.hasActions();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasAnyQueuedActions() {
        return this.hasUnresolvedEntityInsertActions() || this.nonempty(this.updates) || this.nonempty(this.insertions) || this.nonempty(this.deletions) || this.nonempty(this.collectionUpdates) || this.nonempty(this.collectionQueuedOps) || this.nonempty(this.collectionRemovals) || this.nonempty(this.collectionCreations);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean nonempty(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized ExecutableList<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> list) {
        return list != null && !list.isEmpty();
    }

    public void unScheduleUnloadedDeletion(@UnknownKeyFor @NonNull @Initialized Object newEntity) {
        EntityPersister entityPersister = this.session.getEntityPersister(null, newEntity);
        Object identifier = entityPersister.getIdentifier(newEntity, this.session);
        if (this.deletions != null) {
            for (int i = 0; i < this.deletions.size(); ++i) {
                EntityDeleteAction action = this.deletions.get(i);
                if (action.getInstance() != null || !action.getEntityName().equals(entityPersister.getEntityName()) || !entityPersister.getIdentifierMapping().areEqual(action.getId(), identifier, this.session)) continue;
                this.session.getPersistenceContextInternal().removeDeletedUnloadedEntityKey(this.session.generateEntityKey(identifier, entityPersister));
                this.deletions.remove(i);
                return;
            }
        }
        throw new AssertionFailure("Unable to perform un-delete for unloaded entity delete " + entityPersister.getEntityName());
    }

    public void unScheduleDeletion(@UnknownKeyFor @NonNull @Initialized EntityEntry entry, @UnknownKeyFor @NonNull @Initialized Object rescuedEntity) {
        EntityDeleteAction action;
        int i;
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(rescuedEntity);
        if (lazyInitializer != null && !lazyInitializer.isUninitialized()) {
            rescuedEntity = lazyInitializer.getImplementation(this.session);
        }
        if (this.deletions != null) {
            for (i = 0; i < this.deletions.size(); ++i) {
                action = this.deletions.get(i);
                if (action.getInstance() != rescuedEntity) continue;
                this.deletions.remove(i);
                return;
            }
        }
        if (this.orphanRemovals != null) {
            for (i = 0; i < this.orphanRemovals.size(); ++i) {
                action = this.orphanRemovals.get(i);
                if (action.getInstance() != rescuedEntity) continue;
                this.orphanRemovals.remove(i);
                return;
            }
        }
        throw new AssertionFailure("Unable to perform un-delete for instance " + entry.getEntityName());
    }

    public void serialize(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream oos) throws @UnknownKeyFor @NonNull @Initialized IOException {
        LOG.trace("Serializing action-queue");
        if (this.unresolvedInsertions == null) {
            this.unresolvedInsertions = new UnresolvedEntityInsertActions();
        }
        this.unresolvedInsertions.serialize(oos);
        for (OrderedActions action : ORDERED_OPERATIONS) {
            ExecutableList<?> l = action.getActions(this);
            if (l == null) {
                oos.writeBoolean(false);
                continue;
            }
            oos.writeBoolean(true);
            l.writeExternal(oos);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized ActionQueue deserialize(@UnknownKeyFor @NonNull @Initialized ObjectInputStream ois, @UnknownKeyFor @NonNull @Initialized EventSource session) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.trace("Deserializing action-queue");
        }
        ActionQueue rtn = new ActionQueue(session);
        rtn.unresolvedInsertions = UnresolvedEntityInsertActions.deserialize(ois, session);
        for (OrderedActions action : ORDERED_OPERATIONS) {
            ExecutableList<?> l = action.getActions(rtn);
            boolean notNull = ois.readBoolean();
            if (!notNull) continue;
            if (l == null) {
                action.ensureInitialized(rtn);
                l = action.getActions(rtn);
            }
            l.readExternal(ois);
            if (traceEnabled) {
                LOG.tracev("Deserialized [{0}] entries", l.size());
            }
            l.afterDeserialize(session);
        }
        return rtn;
    }

    private static class InsertActionSorter
    implements ExecutableList.Sorter<AbstractEntityInsertAction> {
        public static final @UnknownKeyFor @NonNull @Initialized InsertActionSorter INSTANCE = new InsertActionSorter();

        @Override
        public void sort(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AbstractEntityInsertAction> insertions) {
            int lastScheduleSize;
            int i;
            int insertInfoCount = insertions.size();
            InsertInfo[] insertInfos = new InsertInfo[insertInfoCount];
            IdentityHashMap<Object, InsertInfo> insertInfosByEntity = new IdentityHashMap<Object, InsertInfo>(insertInfos.length);
            for (i = 0; i < insertInfoCount; ++i) {
                AbstractEntityInsertAction insertAction = insertions.get(i);
                InsertInfo insertInfo = new InsertInfo(insertAction, i);
                insertInfosByEntity.put(insertAction.getInstance(), insertInfo);
                insertInfos[i] = insertInfo;
            }
            for (i = 0; i < insertInfoCount; ++i) {
                insertInfos[i].buildDirectDependencies(insertInfosByEntity);
            }
            for (i = 0; i < insertInfoCount; ++i) {
                insertInfos[i].propagateChildDependencies();
            }
            HashSet<InsertInfo> visited = new HashSet<InsertInfo>();
            LinkedHashMap<String, EntityInsertGroup> insertInfosByEntityName = new LinkedHashMap<String, EntityInsertGroup>();
            for (int i2 = 0; i2 < insertInfoCount; ++i2) {
                InsertInfo insertInfo = insertInfos[i2];
                insertInfo.buildTransitiveDependencies(visited);
                String entityName = insertInfo.insertAction.getPersister().getEntityName();
                EntityInsertGroup entityInsertGroup = (EntityInsertGroup)insertInfosByEntityName.get(entityName);
                if (entityInsertGroup == null) {
                    entityInsertGroup = new EntityInsertGroup(entityName);
                    insertInfosByEntityName.put(entityName, entityInsertGroup);
                }
                entityInsertGroup.add(insertInfo);
            }
            HashSet<String> scheduledEntityNames = new HashSet<String>(insertInfosByEntityName.size());
            int schedulePosition = 0;
            do {
                lastScheduleSize = scheduledEntityNames.size();
                Iterator iterator = insertInfosByEntityName.values().iterator();
                while (iterator.hasNext()) {
                    EntityInsertGroup insertGroup = (EntityInsertGroup)iterator.next();
                    if (!scheduledEntityNames.containsAll(insertGroup.dependentEntityNames)) continue;
                    schedulePosition = this.schedule(insertInfos, insertGroup.insertInfos, schedulePosition);
                    scheduledEntityNames.add(insertGroup.entityName);
                    iterator.remove();
                }
            } while (lastScheduleSize != scheduledEntityNames.size());
            if (!insertInfosByEntityName.isEmpty()) {
                LOG.warn("The batch containing " + insertions.size() + " statements could not be sorted. This might indicate a circular entity relationship.");
            }
            insertions.clear();
            for (InsertInfo insertInfo : insertInfos) {
                insertions.add(insertInfo.insertAction);
            }
        }

        private @UnknownKeyFor @NonNull @Initialized int schedule(@UnknownKeyFor @NonNull @Initialized InsertInfo @UnknownKeyFor @NonNull @Initialized [] insertInfos, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized InsertInfo> insertInfosToSchedule, @UnknownKeyFor @NonNull @Initialized int schedulePosition) {
            int i;
            InsertInfo[] newInsertInfos = new InsertInfo[insertInfos.length];
            BitSet bitSet = new BitSet(insertInfos.length);
            int smallestScheduledIndex = -1;
            int biggestScheduledIndex = -1;
            for (int i2 = 0; i2 < insertInfosToSchedule.size(); ++i2) {
                int index = insertInfosToSchedule.get((int)i2).index;
                bitSet.set(index);
                smallestScheduledIndex = Math.min(smallestScheduledIndex, index);
                biggestScheduledIndex = Math.max(biggestScheduledIndex, index);
            }
            int nextSchedulePosition = schedulePosition + insertInfosToSchedule.size();
            if (smallestScheduledIndex == schedulePosition && biggestScheduledIndex == nextSchedulePosition) {
                return nextSchedulePosition;
            }
            int shiftSchedulePosition = nextSchedulePosition;
            for (i = 0; i < insertInfosToSchedule.size(); ++i) {
                InsertInfo insertInfoToSchedule = insertInfosToSchedule.get(i);
                int targetSchedulePosition = schedulePosition + i;
                newInsertInfos[targetSchedulePosition] = insertInfoToSchedule;
                insertInfoToSchedule.index = targetSchedulePosition;
                InsertInfo oldInsertInfo = insertInfos[targetSchedulePosition];
                if (bitSet.get(targetSchedulePosition)) continue;
                oldInsertInfo.index = shiftSchedulePosition;
                bitSet.set(targetSchedulePosition);
                newInsertInfos[shiftSchedulePosition++] = oldInsertInfo;
            }
            ++biggestScheduledIndex;
            for (i = bitSet.nextClearBit(schedulePosition); i < biggestScheduledIndex; ++i) {
                if (bitSet.get(i)) continue;
                InsertInfo insertInfo = insertInfos[i];
                insertInfo.index = shiftSchedulePosition;
                newInsertInfos[shiftSchedulePosition++] = insertInfo;
            }
            System.arraycopy(newInsertInfos, schedulePosition, insertInfos, schedulePosition, biggestScheduledIndex - schedulePosition);
            return nextSchedulePosition;
        }

        public static class EntityInsertGroup {
            private final @UnknownKeyFor @NonNull @Initialized String entityName;
            private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized InsertInfo> insertInfos = new ArrayList<InsertInfo>();
            private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> dependentEntityNames = new HashSet<String>();

            public EntityInsertGroup(@UnknownKeyFor @NonNull @Initialized String entityName) {
                this.entityName = entityName;
            }

            public void add(@UnknownKeyFor @NonNull @Initialized InsertInfo insertInfo) {
                this.insertInfos.add(insertInfo);
                if (insertInfo.transitiveIncomingDependencies != null) {
                    for (InsertInfo dependency : insertInfo.transitiveIncomingDependencies) {
                        this.dependentEntityNames.add(dependency.insertAction.getEntityName());
                    }
                }
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return "EntityInsertGroup{entityName='" + this.entityName + "'}";
            }
        }

        private static class InsertInfo {
            private final @UnknownKeyFor @NonNull @Initialized AbstractEntityInsertAction insertAction;
            private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized InsertInfo> transitiveIncomingDependencies;
            private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized InsertInfo> outgoingDependencies;
            private @UnknownKeyFor @NonNull @Initialized int index;

            public InsertInfo(@UnknownKeyFor @NonNull @Initialized AbstractEntityInsertAction insertAction, @UnknownKeyFor @NonNull @Initialized int index) {
                this.insertAction = insertAction;
                this.index = index;
            }

            public void buildDirectDependencies(@UnknownKeyFor @NonNull @Initialized IdentityHashMap<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized InsertInfo> insertInfosByEntity) {
                Object[] propertyValues = this.insertAction.getState();
                Type[] propertyTypes = this.insertAction.getPersister().getPropertyTypes();
                int propertyTypesLength = propertyTypes.length;
                for (int i = 0; i < propertyTypesLength; ++i) {
                    this.addDirectDependency(propertyTypes[i], propertyValues[i], insertInfosByEntity);
                }
            }

            public void propagateChildDependencies() {
                if (this.outgoingDependencies != null) {
                    for (InsertInfo childDependency : this.outgoingDependencies) {
                        if (childDependency.transitiveIncomingDependencies == null) {
                            childDependency.transitiveIncomingDependencies = new HashSet<InsertInfo>();
                        }
                        childDependency.transitiveIncomingDependencies.add(this);
                    }
                }
            }

            public void buildTransitiveDependencies(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized InsertInfo> visited) {
                if (this.transitiveIncomingDependencies != null) {
                    visited.addAll(this.transitiveIncomingDependencies);
                    for (InsertInfo insertInfo : this.transitiveIncomingDependencies.toArray(new InsertInfo[0])) {
                        insertInfo.addTransitiveDependencies(this, visited);
                    }
                    visited.clear();
                }
            }

            public void addTransitiveDependencies(@UnknownKeyFor @NonNull @Initialized InsertInfo origin, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized InsertInfo> visited) {
                if (this.transitiveIncomingDependencies != null) {
                    for (InsertInfo insertInfo : this.transitiveIncomingDependencies) {
                        if (!visited.add(insertInfo)) continue;
                        origin.transitiveIncomingDependencies.add(insertInfo);
                        insertInfo.addTransitiveDependencies(origin, visited);
                    }
                }
            }

            private void addDirectDependency(@UnknownKeyFor @NonNull @Initialized Type type, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized IdentityHashMap<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized InsertInfo> insertInfosByEntity) {
                block7: {
                    block9: {
                        block6: {
                            InsertInfo insertInfo;
                            block8: {
                                if (!type.isEntityType() || value == null) break block6;
                                EntityType entityType = (EntityType)type;
                                insertInfo = insertInfosByEntity.get(value);
                                if (insertInfo == null) break block7;
                                if (!entityType.isOneToOne() || entityType.getForeignKeyDirection() != ForeignKeyDirection.TO_PARENT) break block8;
                                if (entityType.isReferenceToPrimaryKey()) break block7;
                                if (this.outgoingDependencies == null) {
                                    this.outgoingDependencies = new HashSet<InsertInfo>();
                                }
                                this.outgoingDependencies.add(insertInfo);
                                break block7;
                            }
                            if (this.transitiveIncomingDependencies == null) {
                                this.transitiveIncomingDependencies = new HashSet<InsertInfo>();
                            }
                            this.transitiveIncomingDependencies.add(insertInfo);
                            break block7;
                        }
                        if (!type.isCollectionType() || value == null) break block9;
                        CollectionType collectionType = (CollectionType)type;
                        PluralAttributeMapping pluralAttributeMapping = this.insertAction.getSession().getFactory().getMappingMetamodel().getCollectionDescriptor(collectionType.getRole()).getAttributeMapping();
                        if (!pluralAttributeMapping.getCollectionDescriptor().isOneToMany() || !(pluralAttributeMapping.getElementDescriptor() instanceof EntityCollectionPart)) break block7;
                        Iterator<?> elementsIterator = collectionType.getElementsIterator(value);
                        while (elementsIterator.hasNext()) {
                            Object element = elementsIterator.next();
                            InsertInfo insertInfo = insertInfosByEntity.get(element);
                            if (insertInfo == null) continue;
                            if (this.outgoingDependencies == null) {
                                this.outgoingDependencies = new HashSet<InsertInfo>();
                            }
                            this.outgoingDependencies.add(insertInfo);
                        }
                        break block7;
                    }
                    if (type.isComponentType() && value != null) {
                        CompositeType compositeType = (CompositeType)type;
                        EventSource session = this.insertAction.getSession();
                        Object[] componentValues = compositeType.getPropertyValues(value, session);
                        for (int j = 0; j < componentValues.length; ++j) {
                            Type componentValueType = compositeType.getSubtypes()[j];
                            Object componentValue = componentValues[j];
                            this.addDirectDependency(componentValueType, componentValue, insertInfosByEntity);
                        }
                    }
                }
            }

            @EnsuresNonNullIf(expression={"#1"}, result=true)
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                InsertInfo that = (InsertInfo)o;
                return this.insertAction.equals(that.insertAction);
            }

            @Pure
            public @UnknownKeyFor @NonNull @Initialized int hashCode() {
                return this.insertAction.hashCode();
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return "InsertInfo{insertAction=" + this.insertAction + "}";
            }
        }
    }

    public static class TransactionCompletionProcesses {
        private final @UnknownKeyFor @NonNull @Initialized BeforeTransactionCompletionProcessQueue beforeTransactionCompletionProcesses;
        private final @UnknownKeyFor @NonNull @Initialized AfterTransactionCompletionProcessQueue afterTransactionCompletionProcesses;

        private TransactionCompletionProcesses(@UnknownKeyFor @NonNull @Initialized BeforeTransactionCompletionProcessQueue beforeTransactionCompletionProcessQueue, @UnknownKeyFor @NonNull @Initialized AfterTransactionCompletionProcessQueue afterTransactionCompletionProcessQueue) {
            this.beforeTransactionCompletionProcesses = beforeTransactionCompletionProcessQueue;
            this.afterTransactionCompletionProcesses = afterTransactionCompletionProcessQueue;
        }
    }

    private static class AfterTransactionCompletionProcessQueue
    extends AbstractTransactionCompletionProcessQueue<AfterTransactionCompletionProcess> {
        private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> querySpacesToInvalidate = new HashSet<String>();

        private AfterTransactionCompletionProcessQueue(@UnknownKeyFor @NonNull @Initialized SessionImplementor session) {
            super(session);
        }

        public void addSpaceToInvalidate(@UnknownKeyFor @NonNull @Initialized String space) {
            this.querySpacesToInvalidate.add(space);
        }

        public void afterTransactionCompletion(@UnknownKeyFor @NonNull @Initialized boolean success) {
            AfterTransactionCompletionProcess process;
            while ((process = (AfterTransactionCompletionProcess)this.processes.poll()) != null) {
                try {
                    process.doAfterTransactionCompletion(success, this.session);
                }
                catch (CacheException ce) {
                    LOG.unableToReleaseCacheLock(ce);
                }
                catch (Exception e) {
                    throw new HibernateException("Unable to perform afterTransactionCompletion callback: " + e.getMessage(), e);
                }
            }
            if (this.session.getFactory().getSessionFactoryOptions().isQueryCacheEnabled()) {
                this.session.getFactory().getCache().getTimestampsCache().invalidate(this.querySpacesToInvalidate.toArray(new String[0]), this.session);
            }
            this.querySpacesToInvalidate.clear();
        }
    }

    private static class BeforeTransactionCompletionProcessQueue
    extends AbstractTransactionCompletionProcessQueue<BeforeTransactionCompletionProcess> {
        private BeforeTransactionCompletionProcessQueue(@UnknownKeyFor @NonNull @Initialized SessionImplementor session) {
            super(session);
        }

        public void beforeTransactionCompletion() {
            BeforeTransactionCompletionProcess process;
            while ((process = (BeforeTransactionCompletionProcess)this.processes.poll()) != null) {
                try {
                    process.doBeforeTransactionCompletion(this.session);
                }
                catch (HibernateException he) {
                    throw he;
                }
                catch (Exception e) {
                    throw new HibernateException("Unable to perform beforeTransactionCompletion callback: " + e.getMessage(), e);
                }
            }
        }
    }

    private static abstract class AbstractTransactionCompletionProcessQueue<@UnknownKeyFor T> {
        protected @UnknownKeyFor @NonNull @Initialized SessionImplementor session;
        protected @UnknownKeyFor @NonNull @Initialized ConcurrentLinkedQueue<@NonNull T> processes = new ConcurrentLinkedQueue();

        private AbstractTransactionCompletionProcessQueue(@UnknownKeyFor @NonNull @Initialized SessionImplementor session) {
            this.session = session;
        }

        public void register(@Nullable T process) {
            if (process != null) {
                this.processes.add(process);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized boolean hasActions() {
            return !this.processes.isEmpty();
        }
    }

    private static enum OrderedActions {
        OrphanCollectionRemoveAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.orphanCollectionRemovals;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.orphanCollectionRemovals == null) {
                    instance.orphanCollectionRemovals = new ExecutableList(instance.isOrderUpdatesEnabled());
                }
            }
        }
        ,
        OrphanRemovalAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.orphanRemovals;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.orphanRemovals == null) {
                    instance.orphanRemovals = new ExecutableList(false);
                }
            }
        }
        ,
        EntityInsertAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.insertions;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.insertions == null) {
                    instance.insertions = instance.isOrderInsertsEnabled() ? new ExecutableList<AbstractEntityInsertAction>(InsertActionSorter.INSTANCE) : new ExecutableList(false);
                }
            }
        }
        ,
        EntityUpdateAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.updates;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.updates == null) {
                    instance.updates = new ExecutableList(instance.isOrderUpdatesEnabled());
                }
            }
        }
        ,
        QueuedOperationCollectionAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.collectionQueuedOps;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.collectionQueuedOps == null) {
                    instance.collectionQueuedOps = new ExecutableList(instance.isOrderUpdatesEnabled());
                }
            }
        }
        ,
        CollectionRemoveAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.collectionRemovals;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.collectionRemovals == null) {
                    instance.collectionRemovals = new ExecutableList(instance.isOrderUpdatesEnabled());
                }
            }
        }
        ,
        CollectionUpdateAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.collectionUpdates;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.collectionUpdates == null) {
                    instance.collectionUpdates = new ExecutableList(instance.isOrderUpdatesEnabled());
                }
            }
        }
        ,
        CollectionRecreateAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.collectionCreations;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.collectionCreations == null) {
                    instance.collectionCreations = new ExecutableList(instance.isOrderUpdatesEnabled());
                }
            }
        }
        ,
        EntityDeleteAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.deletions;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.deletions == null) {
                    instance.deletions = new ExecutableList(false);
                }
            }
        };


        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ExecutableList<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getActions(@UnknownKeyFor @NonNull @Initialized ActionQueue var1);

        public abstract void ensureInitialized(@UnknownKeyFor @NonNull @Initialized ActionQueue var1);
    }
}

