/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.portlet;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.webui.application.UIPortlet;

public class GenericDispatchedViewPortlet
extends GenericPortlet {
    private String viewDispatchedPath;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.viewDispatchedPath = config.getInitParameter("portlet-view-dispatched-file-path");
        if (StringUtils.isBlank((CharSequence)this.viewDispatchedPath)) {
            throw new IllegalStateException("Portlet init parameter 'portlet-view-dispatched-file-path' is mandatory");
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletRequestDispatcher prd = this.getPortletContext().getRequestDispatcher(this.viewDispatchedPath);
        PortletPreferences preferences = request.getPreferences();
        if (preferences != null) {
            Set preferencesEntries = preferences.getMap().entrySet();
            for (Map.Entry entry : preferencesEntries) {
                request.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
        request.setAttribute("portletStorageId", (Object)UIPortlet.getCurrentUIPortlet().getStorageId());
        prd.include(request, response);
    }
}

