/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.model.PageTemplate;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.storage.PageTemplateStorage;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.social.attachment.AttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PageTemplateService {
    private static final Log LOG = ExoLogger.getLogger(PageTemplateService.class);
    @Autowired
    private LayoutAclService layoutAclService;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private LocaleConfigService localeConfigService;
    @Autowired
    private PageTemplateStorage pageTemplateStorage;

    public List<PageTemplate> getPageTemplates() {
        return this.getPageTemplates(null, false);
    }

    public List<PageTemplate> getPageTemplates(boolean expand) {
        return this.getPageTemplates(null, expand);
    }

    public List<PageTemplate> getPageTemplates(Locale locale, boolean expand) {
        return this.getPageTemplates(locale, expand, true);
    }

    public List<PageTemplate> getPageTemplates(Locale locale, boolean expand, boolean retrieveContent) {
        List<PageTemplate> pageTemplates = this.pageTemplateStorage.getPageTemplates();
        if (expand) {
            pageTemplates.forEach(pageTemplate -> this.computePageTemplateAttributes(locale, (PageTemplate)pageTemplate, retrieveContent));
        }
        return pageTemplates;
    }

    public PageTemplate getPageTemplate(long id, Locale locale, boolean expand) {
        return this.getPageTemplate(id, locale, expand, false);
    }

    public PageTemplate getPageTemplate(long id, Locale locale, boolean expand, boolean retrieveContent) {
        PageTemplate pageTemplate = this.pageTemplateStorage.getPageTemplate(id);
        if (expand) {
            this.computePageTemplateAttributes(locale, pageTemplate, retrieveContent);
        }
        return pageTemplate;
    }

    public PageTemplate getPageTemplate(long id) {
        return this.pageTemplateStorage.getPageTemplate(id);
    }

    public PageTemplate createPageTemplate(PageTemplate pageTemplate, String username) throws IllegalAccessException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't authorized to create a page template");
        }
        return this.createPageTemplate(pageTemplate);
    }

    public PageTemplate createPageTemplate(PageTemplate pageTemplate) {
        return this.pageTemplateStorage.createPageTemplate(pageTemplate);
    }

    public void deletePageTemplate(long templateId, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't authorized to create a page template");
        }
        PageTemplate pageTemplate = this.getPageTemplate(templateId);
        if (pageTemplate == null) {
            throw new ObjectNotFoundException("Page template doesn't exist");
        }
        if (pageTemplate.isSystem()) {
            throw new IllegalAccessException("Can't delete a system page template");
        }
        this.deletePageTemplate(templateId);
    }

    public void deletePageTemplate(long templateId) throws ObjectNotFoundException {
        try {
            this.attachmentService.deleteAttachments("pageTemplate", String.valueOf(templateId));
        }
        catch (Exception e) {
            LOG.debug((Object)"Error while deleting attachments of deleted Page Template", (Throwable)e);
        }
        try {
            this.translationService.deleteTranslationLabels("pageTemplate", templateId);
        }
        catch (ObjectNotFoundException e) {
            LOG.debug((Object)"Error while deleting translation labels of deleted Page Template", (Throwable)e);
        }
        this.pageTemplateStorage.deletePageTemplate(templateId);
    }

    public PageTemplate updatePageTemplate(PageTemplate pageTemplate, String username) throws ObjectNotFoundException, IllegalAccessException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't authorized to update a page template");
        }
        return this.updatePageTemplate(pageTemplate);
    }

    public PageTemplate updatePageTemplate(PageTemplate pageTemplate) throws ObjectNotFoundException {
        return this.pageTemplateStorage.updatePageTemplate(pageTemplate);
    }

    private String getLabel(long templateId, String fieldName, Locale locale) {
        if (locale == null) {
            locale = this.localeConfigService.getDefaultLocaleConfig().getLocale();
        }
        try {
            TranslationField translationField = this.translationService.getTranslationField("pageTemplate", templateId, fieldName);
            if (translationField != null && MapUtils.isNotEmpty((Map)translationField.getLabels())) {
                String label = (String)translationField.getLabels().get(locale);
                if (label == null) {
                    Locale defaultLocale = this.localeConfigService.getDefaultLocaleConfig().getLocale();
                    label = (String)translationField.getLabels().get(defaultLocale);
                }
                if (label == null) {
                    label = (String)translationField.getLabels().values().iterator().next();
                }
                return label;
            }
            return null;
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    private void computePageTemplateAttributes(Locale locale, PageTemplate pageTemplate, boolean retrieveContent) {
        pageTemplate.setName(this.getLabel(pageTemplate.getId(), "title", locale));
        pageTemplate.setDescription(this.getLabel(pageTemplate.getId(), "description", locale));
        List attachmentFileIds = this.attachmentService.getAttachmentFileIds("pageTemplate", String.valueOf(pageTemplate.getId()));
        if (CollectionUtils.isNotEmpty((Collection)attachmentFileIds)) {
            pageTemplate.setIllustrationId(Long.parseLong((String)attachmentFileIds.get(0)));
        }
        if (!retrieveContent) {
            pageTemplate.setContent(null);
        }
    }
}

