/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.listener.websocket;

import io.meeds.analytics.api.service.AnalyticsService;
import io.meeds.analytics.api.websocket.AnalyticsWebSocketService;
import io.meeds.analytics.model.AnalyticsWebSocketMessage;
import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.model.StatisticWatcher;
import io.meeds.analytics.utils.AnalyticsUtils;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
public class WebSocketUIStatisticListener
extends Listener<AnalyticsWebSocketService, AnalyticsWebSocketMessage> {
    private static final Log LOG = ExoLogger.getLogger(WebSocketUIStatisticListener.class);
    private static final List<String> EVENT_NAMES = Arrays.asList("analytics.websocket.messageReceived");
    @Autowired
    private AnalyticsService analyticsService;
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        EVENT_NAMES.forEach(name -> this.listenerService.addListener(name, (ListenerBase)this));
    }

    public void onEvent(Event<AnalyticsWebSocketService, AnalyticsWebSocketMessage> event) throws Exception {
        AnalyticsWebSocketMessage message = (AnalyticsWebSocketMessage)event.getData();
        long userId = AnalyticsUtils.getUserIdentityId((String)message.getUserName());
        if (userId <= 0L) {
            LOG.debug("User not found in state, userId= {} ", new Object[]{userId});
            return;
        }
        StatisticData statisticData = new StatisticData();
        if (StringUtils.isNotBlank((CharSequence)message.getSpaceId())) {
            space = AnalyticsUtils.getSpaceById((String)message.getSpaceId());
            AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
        } else if (StringUtils.isNotBlank((CharSequence)message.getSpacePrettyName())) {
            space = AnalyticsUtils.getSpaceByPrettyName((String)message.getSpacePrettyName());
            AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
        }
        String module = null;
        String subModule = null;
        String operation = null;
        HashMap<String, String> data = message.getParameters();
        if (data == null) {
            data = new HashMap<String, String>();
        }
        if (StringUtils.isNotBlank((CharSequence)message.getName())) {
            StatisticWatcher uiWatcher = this.analyticsService.getUIWatcher(message.getName());
            if (uiWatcher == null) {
                module = "portal";
                subModule = "ui";
            } else {
                module = uiWatcher.getModule() == null ? "portal" : uiWatcher.getModule();
                subModule = uiWatcher.getSubModule() == null ? "ui" : uiWatcher.getSubModule();
                operation = uiWatcher.getOperation();
                if (uiWatcher.getParameters() != null && !uiWatcher.getParameters().isEmpty()) {
                    data.putAll(uiWatcher.getParameters());
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)message.getModule())) {
            module = message.getModule();
        }
        if (StringUtils.isNotBlank((CharSequence)message.getSubModule())) {
            subModule = message.getSubModule();
        }
        if (StringUtils.isNotBlank((CharSequence)message.getOperation())) {
            operation = message.getOperation();
        }
        statisticData.setModule(module);
        statisticData.setSubModule(subModule);
        statisticData.setOperation(operation);
        statisticData.setUserId(userId);
        if (StringUtils.isNotBlank((CharSequence)message.getPortalUri())) {
            data.put("portalUri", message.getPortalUri());
        }
        if (StringUtils.isNotBlank((CharSequence)message.getName())) {
            data.put("watcher", message.getName());
        }
        Set dataParameters = data.entrySet();
        for (Map.Entry dataParameter : dataParameters) {
            String dataParameterName = (String)dataParameter.getKey();
            String dataParameterValue = (String)dataParameter.getValue();
            if (StringUtils.contains((CharSequence)dataParameterValue, (CharSequence)",")) {
                List<String> dataParameterValues = Arrays.asList(StringUtils.split((String)dataParameterValue, (String)","));
                statisticData.addParameter(dataParameterName, dataParameterValues);
                continue;
            }
            statisticData.addParameter(dataParameterName, (Object)dataParameterValue);
        }
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }
}

