/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.UserUtil;

public class SpaceTaskDataInitializer
extends SpaceListenerPlugin {
    private ProjectService projectService;
    private StatusService statusServ;

    public SpaceTaskDataInitializer(ProjectService pServ, StatusService statusServ) {
        this.projectService = pServ;
        this.statusServ = statusServ;
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        List<String> memberships = UserUtil.getSpaceMemberships(space.getGroupId());
        HashSet<String> managers = new HashSet<String>(Arrays.asList(memberships.get(0)));
        HashSet<String> participators = new HashSet<String>(Arrays.asList(memberships.get(1)));
        ProjectDto project = ProjectUtil.newProjectInstanceDto(space.getDisplayName(), "", managers, participators);
        project = this.projectService.createProject(project);
        this.statusServ.createInitialStatuses(project);
    }
}

