/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.listener;

import io.meeds.social.category.model.CategoryObject;
import io.meeds.social.space.category.service.SpaceCategoryService;
import jakarta.annotation.PostConstruct;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CategoryLinkModifiedListener
implements ListenerBase<Long, CategoryObject> {
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private SpaceCategoryService spaceCategoryService;
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("category.link.added", (ListenerBase)this);
        this.listenerService.addListener("category.link.removed", (ListenerBase)this);
    }

    public void onEvent(Event<Long, CategoryObject> event) throws Exception {
        Space space;
        CategoryObject object = (CategoryObject)event.getData();
        boolean isSpace = StringUtils.equals((CharSequence)object.getType(), (CharSequence)"space");
        if (isSpace && (space = this.spaceService.getSpaceById(Long.parseLong(object.getId()))) != null) {
            List<Long> categoryIds = this.spaceCategoryService.getSpaceCategoryIds(space.getSpaceId());
            space.setCategoryIds(categoryIds);
            this.spaceService.updateSpace(space);
        }
    }
}

