/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.listener;

import io.meeds.social.category.model.Category;
import io.meeds.social.category.service.CategoryService;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CategoryModifiedIndexingListener
implements ListenerBase<Category, Object> {
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private IndexingService indexingService;
    @Autowired
    private CategoryService categoryService;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("social.category.created", (ListenerBase)this);
        this.listenerService.addListener("social.category.updated", (ListenerBase)this);
        this.listenerService.addListener("social.category.deleted", (ListenerBase)this);
    }

    public void onEvent(Event<Category, Object> event) throws Exception {
        switch (event.getEventName()) {
            case "social.category.created": {
                this.indexingService.index("category", String.valueOf(((Category)event.getSource()).getId()));
                break;
            }
            case "social.category.updated": {
                this.reindexTree(((Category)event.getSource()).getId());
                break;
            }
            case "social.category.deleted": {
                this.indexingService.unindex("category", String.valueOf(((Category)event.getSource()).getId()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected event name: " + event.getEventName());
            }
        }
    }

    private void reindexTree(long id) {
        this.indexingService.reindex("category", String.valueOf(id));
        List subCategoryIds = this.categoryService.getSubcategoryIds(id, 0L, -1L, -1L);
        if (CollectionUtils.isNotEmpty((Collection)subCategoryIds)) {
            subCategoryIds.forEach(this::reindexTree);
        }
    }
}

