/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.storage.elasticsearch;

import io.meeds.social.category.model.CategorySearchFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CategorySearchConnector {
    private static final String CATEGORY_INDEX = "category_alias";
    private static final Log LOG = ExoLogger.getLogger(CategorySearchConnector.class);
    private static final String SEARCH_QUERY_TERM = "    {\n      \"from\": \"@offset@\",\n      \"size\": \"@limit@\",\n      @sort_query@\n      \"query\":{\n        \"bool\":{\n          @term_query@\n          \"must\":[\n            @owner_id_query@\n            @parent_id_query@\n            @permissions_query@\n          ]\n        }\n      },\n      \"fields\": [],\n      \"_source\": false\n    }\n";
    private static final String COUNT_QUERY_TERM = "    {\n      \"query\":{\n        \"bool\":{\n          @term_query@\n          \"must\":[\n            @owner_id_query@\n            @parent_id_query@\n            @permissions_query@\n          ]\n        }\n      }\n    }\n";
    public static final String TERM_QUERY = "  \"filter\":{\n    \"query_string\":{\n      \"fields\": [\"@name_field@\"],\n      \"default_operator\": \"AND\",\n      \"query\": \"@term@\"\n    }\n  },\n";
    public static final String OWNER_ID_QUERY = "{\n  \"term\":{\n    \"ownerId\": @ownerId@\n  }\n}\n";
    public static final String PARENT_ID_QUERY = "{\n  \"term\":{\n    \"parentId\": @parentId@\n  }\n}\n";
    public static final String PERMISSIONS_QUERY = "{\n  \"terms\":{\n    \"@permissions_field@\": [@permissions@]\n  }\n}\n";
    public static final String SORT_QUERY_BY_NAME = "\"sort\" : [\n  { \"@sort_field@.raw\" : \"@sort_direction@\" }\n],\n";
    public static final String SORT_QUERY_BY_SCORE = "\"sort\" : [\n  \"_score\"\n],\n";
    private static final String OFFSET_REPLACEMENT = "@offset@";
    private static final String LIMIT_REPLACEMENT = "@limit@";
    private static final String NAME_REPLACEMENT = "@name_field@";
    private static final String TERM_REPLACEMENT = "@term@";
    private static final String TERM_QUERY_REPLACEMENT = "@term_query@";
    private static final String SORT_QUERY_REPLACEMENT = "@sort_query@";
    private static final String OWNER_ID_REPLACEMENT = "@ownerId@";
    private static final String OWNER_ID_QUERY_REPLACEMENT = "@owner_id_query@";
    private static final String PARENT_ID_REPLACEMENT = "@parentId@";
    private static final String PARENT_ID_QUERY_REPLACEMENT = "@parent_id_query@";
    private static final String PERMISSIONS_REPLACEMENT = "@permissions@";
    private static final String PERMISSIONS_FIELD_REPLACEMENT = "@permissions_field@";
    private static final String PERMISSIONS_QUERY_REPLACEMENT = "@permissions_query@";
    private static final String SORT_FIELD_QUERY_REPLACEMENT = "@sort_field@";
    private static final String SORT_DIRECTION_QUERY_REPLACEMENT = "@sort_direction@";
    private static final String STRING_VALUE_FORMAT = "\"%s\"";
    private static final String NAME_FORMAT = "name-%s";
    private static final int DEFAULT_LIMIT = 100;
    @Autowired
    private ElasticSearchingClient client;

    public List<Long> search(CategorySearchFilter filter, List<Long> identityIds, Locale locale) {
        String esQuery = this.buildSearchQuery(SEARCH_QUERY_TERM, filter, identityIds, locale);
        String jsonResponse = this.client.sendRequest(esQuery, CATEGORY_INDEX);
        return this.buildResult(jsonResponse);
    }

    public int count(CategorySearchFilter filter, List<Long> identityIds, Locale locale) {
        String esQuery = this.buildSearchQuery(COUNT_QUERY_TERM, filter, identityIds, locale);
        String jsonResponse = this.client.countRequest(esQuery, CATEGORY_INDEX);
        return this.buildCount(jsonResponse);
    }

    private String buildSearchQuery(String queryBase, CategorySearchFilter filter, List<Long> identityIds, Locale locale) {
        String append = "";
        String esQuery = queryBase.replace(OFFSET_REPLACEMENT, String.valueOf(filter.getOffset())).replace(LIMIT_REPLACEMENT, String.valueOf(filter.getLimit() < 1L ? 100L : filter.getLimit()));
        if (filter.getParentId() > 0L) {
            esQuery = esQuery.replace(PARENT_ID_QUERY_REPLACEMENT, PARENT_ID_QUERY.replace(PARENT_ID_REPLACEMENT, String.format(STRING_VALUE_FORMAT, filter.getParentId())));
            esQuery = esQuery.replace(OWNER_ID_QUERY_REPLACEMENT, "");
            append = ",";
        } else if (filter.getOwnerId() > 0L) {
            esQuery = esQuery.replace(OWNER_ID_QUERY_REPLACEMENT, OWNER_ID_QUERY.replace(OWNER_ID_REPLACEMENT, String.format(STRING_VALUE_FORMAT, filter.getOwnerId())));
            esQuery = esQuery.replace(PARENT_ID_QUERY_REPLACEMENT, "");
            append = ",";
        } else {
            esQuery = esQuery.replace(PARENT_ID_QUERY_REPLACEMENT, "");
            esQuery = esQuery.replace(OWNER_ID_QUERY_REPLACEMENT, "");
        }
        esQuery = CollectionUtils.isNotEmpty(identityIds) ? esQuery.replace(PERMISSIONS_QUERY_REPLACEMENT, append + PERMISSIONS_QUERY.replace(PERMISSIONS_REPLACEMENT, String.format(STRING_VALUE_FORMAT, StringUtils.join(identityIds, (String)"\",\""))).replace(PERMISSIONS_FIELD_REPLACEMENT, filter.isLinkPermission() ? "linkPermissionIds" : "accessPermissionIds")) : esQuery.replace(PERMISSIONS_QUERY_REPLACEMENT, "");
        esQuery = StringUtils.isNotBlank((CharSequence)filter.getTerm()) ? esQuery.replace(TERM_QUERY_REPLACEMENT, TERM_QUERY.replace(NAME_REPLACEMENT, String.format(NAME_FORMAT, locale.toLanguageTag())).replace(TERM_REPLACEMENT, this.escape(filter.getTerm()))) : esQuery.replace(TERM_QUERY_REPLACEMENT, "");
        if (filter.isSortByName()) {
            esQuery = esQuery.replace(SORT_QUERY_REPLACEMENT, SORT_QUERY_BY_NAME);
            esQuery = esQuery.replace(SORT_FIELD_QUERY_REPLACEMENT, String.format(NAME_FORMAT, locale.toLanguageTag()));
            esQuery = esQuery.replace(SORT_DIRECTION_QUERY_REPLACEMENT, "asc");
        } else {
            esQuery = esQuery.replace(SORT_QUERY_REPLACEMENT, SORT_QUERY_BY_SCORE);
        }
        return esQuery;
    }

    private List<Long> buildResult(String jsonResponse) {
        Map json;
        JSONParser parser = new JSONParser();
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return Collections.emptyList();
        }
        ArrayList<Long> results = new ArrayList<Long>();
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        for (Object jsonHit : jsonHits) {
            try {
                JSONObject jsonHitObject = (JSONObject)jsonHit;
                Long id = this.parseLong(jsonHitObject, "_id");
                results.add(id);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error processing category search result item, ignore it from results", (Throwable)e);
            }
        }
        return results;
    }

    private int buildCount(String jsonResponse) {
        JSONParser parser = new JSONParser();
        try {
            Map json = (Map)parser.parse(jsonResponse);
            String countString = json.getOrDefault("count", "0").toString();
            return Integer.parseInt(countString);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
    }

    private Long parseLong(JSONObject hitSource, String key) {
        String value = (String)hitSource.get((Object)key);
        return StringUtils.isBlank((CharSequence)value) ? null : Long.valueOf(Long.parseLong(value));
    }

    private String escape(String term) {
        return term.replaceAll("([\\Q+-!():^[]\"{}~*?|&/\\E])", " ").trim();
    }
}

