/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.provider.JAXBContextComponentPlugin;

@Provider
@Consumes(value={"application/xml", "text/xml", "application/xhtml+xml"})
@Produces(value={"application/xml", "text/xml", "application/xhtml+xml", "application/vnd.sun.wadl+xml"})
public class JAXBContextResolver
implements ContextResolver<JAXBContextResolver> {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.rest.core.JAXBContextResolver");
    private final ConcurrentHashMap<Class, JAXBContext> jaxbContexts = new ConcurrentHashMap();

    public JAXBContextResolver getContext(Class<?> type) {
        return this;
    }

    public JAXBContext getJAXBContext(Class<?> clazz) throws JAXBException {
        JAXBContext jaxbctx = this.jaxbContexts.get(clazz);
        if (jaxbctx == null) {
            try {
                jaxbctx = JAXBContext.newInstance((Class[])new Class[]{clazz});
            }
            catch (JAXBException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof JAXBException) {
                    throw (JAXBException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            JAXBContext currentCtx = this.jaxbContexts.putIfAbsent(clazz, jaxbctx);
            if (currentCtx != null) {
                jaxbctx = currentCtx;
            }
        }
        return jaxbctx;
    }

    public JAXBContext createJAXBContext(Class<?> clazz) throws JAXBException {
        JAXBContext jaxbctx;
        try {
            jaxbctx = JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
        catch (JAXBException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof JAXBException) {
                throw (JAXBException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        this.addJAXBContext(jaxbctx, clazz);
        return jaxbctx;
    }

    public void addJAXBContext(JAXBContext jaxbctx, Class<?> clazz) {
        this.jaxbContexts.put(clazz, jaxbctx);
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof JAXBContextComponentPlugin) {
            for (Class<?> c : ((JAXBContextComponentPlugin)plugin).getJAXBContexts()) {
                try {
                    this.createJAXBContext(c);
                }
                catch (JAXBException e) {
                    LOG.error((Object)("Failed add JAXBContext for class " + c.getName()), (Throwable)e);
                }
            }
        }
    }
}

