/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.notification.plugin;

import io.meeds.wallet.model.ContractDetail;
import io.meeds.wallet.model.FundsRequest;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.utils.WalletUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FundsRequestNotificationPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(FundsRequestNotificationPlugin.class);

    public FundsRequestNotificationPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return "FundsRequestNotificationPlugin";
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        String message;
        Wallet requestSenderDetail = (Wallet)ctx.value(WalletUtils.FUNDS_REQUEST_SENDER_DETAIL_PARAMETER);
        Wallet requestSenderAccountDetail = (Wallet)ctx.value(WalletUtils.SENDER_ACCOUNT_DETAIL_PARAMETER);
        Wallet requestReceiverAccountDetail = (Wallet)ctx.value(WalletUtils.RECEIVER_ACCOUNT_DETAIL_PARAMETER);
        FundsRequest fundsRequest = (FundsRequest)ctx.value(WalletUtils.FUNDS_REQUEST_PARAMETER);
        List toList = WalletUtils.getNotificationReceiversUsers((Wallet)requestReceiverAccountDetail, (String)requestSenderDetail.getId());
        if (toList == null || toList.isEmpty()) {
            return null;
        }
        String walletLink = WalletUtils.getWalletLink((String)fundsRequest.getReceipientType(), (String)fundsRequest.getReceipient());
        String requestAcceptURL = walletLink + "?receiver=" + requestSenderAccountDetail.getId() + "&receiver_type=" + requestSenderAccountDetail.getType() + "&amount=" + fundsRequest.getAmount();
        ContractDetail contractDetail = WalletUtils.getContractDetail();
        String symbol = contractDetail == null ? null : contractDetail.getSymbol();
        String string = message = fundsRequest.getMessage() == null ? "" : fundsRequest.getMessage();
        if (StringUtils.isNotBlank((CharSequence)message)) {
            try {
                message = HTMLSanitizer.sanitize((String)message);
            }
            catch (Exception e) {
                LOG.warn("error sanitizing wallet transaction message {}. Use empty message", new Object[]{message, e});
                message = "";
            }
        }
        return NotificationInfo.instance().to(toList).with("amount", String.valueOf(fundsRequest.getAmount())).with("account_type", requestSenderAccountDetail.getType()).with("avatar", CommonsUtils.getCurrentDomain() + requestSenderAccountDetail.getAvatar()).with("senderUrl", WalletUtils.getPermanentLink((Wallet)requestSenderAccountDetail)).with("receiverUrl", WalletUtils.getPermanentLink((Wallet)requestReceiverAccountDetail)).with("fundsAcceptUrl", requestAcceptURL).with("userFullname", requestSenderDetail.getName()).with("userUrl", WalletUtils.getPermanentLink((Wallet)requestSenderDetail)).with("sender", requestSenderAccountDetail.getName()).with("senderIdentityId", String.valueOf(requestSenderAccountDetail.getTechnicalId())).with("receiver", requestReceiverAccountDetail.getName()).with("receiverIdentityId", String.valueOf(requestReceiverAccountDetail.getTechnicalId())).with("symbol", symbol).with("message", message).key(this.getKey()).end();
    }
}

