/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.rest;

import io.meeds.pwa.model.UserPushSubscription;
import io.meeds.pwa.service.PwaSubscriptionService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@RequestMapping(value={"subscriptions"})
@Tag(name="subscriptions", description="Managing PWA Subscriptions")
public class PwaPushSubscriptionRest {
    private static final Pattern MOBILE_PATTERN = Pattern.compile("(mobi|phone|blackberry|opera mini|fennec|minimo|symbian|psp|nintendo ds)", 2);
    private static final Pattern TABLET_PATTERN = Pattern.compile("(tablet|ipad|playbook|silk)|(android(?!.*mobi))", 2);
    @Autowired
    private PwaSubscriptionService pwaSubscriptionService;

    @PostMapping
    @Secured(value={"users"})
    @Operation(summary="Create a new subscription", description="This will save the newly Push Service subscription information to user settings", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Subscription created")})
    public void subscribe(WebRequest request, @RequestBody UserPushSubscription subscription) {
        subscription.setDeviceType(this.getDeviceType(request));
        this.pwaSubscriptionService.createSubscription(subscription, request.getRemoteUser());
    }

    @DeleteMapping
    @Secured(value={"users"})
    @Operation(summary="Deletes an existing subscription", description="This will delete a Push Service subscription information", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Subscription deleted")})
    public void unsubscribe(WebRequest request, @RequestBody UserPushSubscription subscription) {
        subscription.setDeviceType(this.getDeviceType(request));
        this.pwaSubscriptionService.deleteSubscription(subscription.getId(), request.getRemoteUser());
    }

    public String getDeviceType(WebRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (StringUtils.isNotBlank((CharSequence)userAgent)) {
            if (this.isTablet(userAgent)) {
                return "Tablet";
            }
            if (this.isMobile(userAgent)) {
                return "Mobile";
            }
            return "Desktop";
        }
        return "Robot";
    }

    private boolean isTablet(String userAgent) {
        return TABLET_PATTERN.matcher(userAgent).find();
    }

    private boolean isMobile(String userAgent) {
        return MOBILE_PATTERN.matcher(userAgent).find();
    }
}

