/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.spi;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import org.gatein.common.net.media.MediaType;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.spi.PortletInvocationContext;

public abstract class AbstractPortletInvocationContext
implements PortletInvocationContext {
    protected final MediaType responseContentType;

    protected AbstractPortletInvocationContext() {
        this(MediaType.TEXT_HTML);
    }

    protected AbstractPortletInvocationContext(MediaType responseContentType) {
        this.responseContentType = responseContentType;
    }

    public abstract HttpServletRequest getClientRequest() throws IllegalStateException;

    public abstract HttpServletResponse getClientResponse() throws IllegalStateException;

    public String encodeResourceURL(String url) throws IllegalArgumentException {
        if (url == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("/")) {
            return this.getClientResponse().encodeURL(url);
        }
        throw new IllegalArgumentException("Invalid URL " + url);
    }

    public MediaType getResponseContentType() {
        return this.responseContentType;
    }

    public void renderURL(Writer writer, ContainerURL containerURL, URLFormat format) throws IOException {
        String renderedURL = this.renderURL(containerURL, format);
        writer.write(renderedURL);
    }
}

