/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.entity;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.social.core.activity.model.ActivityFile;
import org.exoplatform.social.core.activity.model.ActivityShareAction;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.rest.entity.BaseEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.LinkEntity;
import org.exoplatform.social.rest.entity.MetadataItemEntity;

public class ActivityEntity
extends BaseEntity {
    private static final long serialVersionUID = 8770364706590680865L;

    public ActivityEntity() {
    }

    public ActivityEntity(ExoSocialActivity activity) {
        super(activity.getId());
        this.setTitle(activity.getTitle());
        this.setTitleId(activity.getTitleId());
        this.setBody(activity.getBody());
        this.setLink(activity.getPermaLink());
        this.setType(activity.getType());
        this.setFiles(activity.getFiles());
        this.setHidden(activity.isHidden());
        this.setSharedActions(activity.getShareActions());
        this.setTemplateParams(activity.getTemplateParams());
    }

    public ActivityEntity setIdentity(LinkEntity identity) {
        this.setProperty("identity", identity.getData());
        return this;
    }

    public String getIdentity() {
        return this.getString("identity");
    }

    public ActivityEntity setTitle(String title) {
        this.setProperty("title", title);
        return this;
    }

    public String getTitle() {
        return this.getString("title");
    }

    public ActivityEntity setTitleId(String title) {
        this.setProperty("titleId", title);
        return this;
    }

    public String getTitleId() {
        return this.getString("titleId");
    }

    public ActivityEntity setBody(String body) {
        this.setProperty("body", body);
        return this;
    }

    public String getBody() {
        return this.getString("body");
    }

    public ActivityEntity setOwner(DataEntity owner) {
        this.setProperty("owner", owner);
        return this;
    }

    public String getOwner() {
        return this.getString("owner");
    }

    public ActivityEntity setLink(String link) {
        this.setProperty("link", link);
        return this;
    }

    public String getLink() {
        return this.getString("link");
    }

    public ActivityEntity setAttachments(List<DataEntity> attachments) {
        this.setProperty("attachments", attachments);
        return this;
    }

    public ActivityEntity setType(String type) {
        this.setProperty("type", type);
        return this;
    }

    public String getType() {
        return this.getString("type");
    }

    public ActivityEntity setCreateDate(String createDate) {
        this.setProperty("createDate", createDate);
        return this;
    }

    public String getCreateDate() {
        return this.getString("createDate");
    }

    public ActivityEntity setUpdateDate(String updateDate) {
        this.setProperty("updateDate", updateDate);
        return this;
    }

    public String getUpdateDate() {
        return this.getString("updateDate");
    }

    public void setPinned(boolean pinned) {
        this.setProperty("pinned", pinned);
    }

    public boolean isPinned() {
        return (Boolean)this.getProperty("pinned");
    }

    public void setHidden(boolean hidden) {
        this.setProperty("hidden", hidden);
    }

    public boolean isHidden() {
        return (Boolean)this.getProperty("hidden");
    }

    public String getPinDate() {
        return this.getString("pinDate");
    }

    public ActivityEntity setPinDate(String pinDate) {
        this.setProperty("pinDate", pinDate);
        return this;
    }

    public Long getPinAuthorId() {
        return Long.parseLong(this.getString("pinAuthorId"));
    }

    public ActivityEntity setPinAuthorId(Long pinAuthorId) {
        this.setProperty("pinAuthorId", pinAuthorId);
        return this;
    }

    public ActivityEntity setPriority(String priority) {
        this.setProperty("priority", priority);
        return this;
    }

    public String getPriority() {
        return this.getString("priority");
    }

    public ActivityEntity setRead(String read) {
        this.setProperty("read", read);
        return this;
    }

    public String getRead() {
        return this.getString("read");
    }

    public ActivityEntity setMentions(List<DataEntity> mentions) {
        this.setProperty("mentions", mentions);
        return this;
    }

    public ActivityEntity setLikes(LinkEntity likes) {
        this.setProperty("likes", likes.getData());
        return this;
    }

    public String getLikes() {
        return this.getString("likes");
    }

    public ActivityEntity setLikesCount(int count) {
        this.setProperty("likesCount", String.valueOf(count));
        return this;
    }

    public int getLikesCount() {
        Object count = this.getProperty("likesCount");
        return count == null ? 0 : Integer.parseInt(count.toString());
    }

    public ActivityEntity setComments(LinkEntity comments) {
        this.setProperty("comments", comments.getData());
        return this;
    }

    public String getComments() {
        return this.getString("comments");
    }

    public ActivityEntity setCommentsCount(int count) {
        this.setProperty("commentsCount", String.valueOf(count));
        return this;
    }

    public int getCommentsCount() {
        Object count = this.getProperty("commentsCount");
        return count == null ? 0 : Integer.parseInt(count.toString());
    }

    public void setHasLiked(boolean hasLiked) {
        this.setProperty("hasLiked", String.valueOf(hasLiked));
    }

    public boolean isHasLiked() {
        Object hasLiked = this.getProperty("hasLiked");
        return hasLiked != null && Boolean.parseBoolean(hasLiked.toString());
    }

    public void setHasCommented(boolean hasCommented) {
        this.setProperty("hasCommented", String.valueOf(hasCommented));
    }

    public boolean isHasCommented() {
        Object hasCommented = this.getProperty("hasCommented");
        return hasCommented != null && Boolean.parseBoolean(hasCommented.toString());
    }

    public void setCanEdit(boolean canEdit) {
        this.setProperty("canEdit", String.valueOf(canEdit));
    }

    public boolean isCanEdit() {
        Object canEdit = this.getProperty("canEdit");
        return canEdit != null && Boolean.parseBoolean(canEdit.toString());
    }

    public void setCanDelete(boolean canDelete) {
        this.setProperty("canDelete", String.valueOf(canDelete));
    }

    public boolean isCanDelete() {
        Object canDelete = this.getProperty("canDelete");
        return canDelete != null && Boolean.parseBoolean(canDelete.toString());
    }

    public void setCanPin(boolean canPin) {
        this.setProperty("canPin", canPin);
    }

    public ActivityEntity setActivityStream(DataEntity activityStream) {
        this.setProperty("activityStream", activityStream);
        return this;
    }

    public DataEntity getActivityStream() {
        return (DataEntity)this.getProperty("activityStream");
    }

    public ActivityEntity setTemplateParams(Map<String, String> templateParamsIn) {
        DataEntity templateParams = new DataEntity();
        templateParamsIn.forEach(templateParams::setProperty);
        this.setProperty("templateParams", templateParams);
        return this;
    }

    public DataEntity getTemplateParams() {
        return (DataEntity)this.getProperty("templateParams");
    }

    public ActivityEntity setSharedActions(Set<ActivityShareAction> shareActions) {
        this.setProperty("shareActions", shareActions);
        return this;
    }

    public Set<ActivityShareAction> getShareActions() {
        return (Set)this.getProperty("shareActions");
    }

    public List<ActivityFile> getFiles() {
        return (List)this.getProperty("files");
    }

    public ActivityEntity setMetadatas(Map<String, List<MetadataItemEntity>> metadatas) {
        this.setProperty("metadatas", metadatas);
        return this;
    }

    public Map<String, List<MetadataItemEntity>> getMetadatas() {
        return (Map)this.getProperty("metadatas");
    }

    public ActivityEntity setFiles(List<ActivityFile> files) {
        if (CollectionUtils.isNotEmpty(files)) {
            files = files.stream().filter(file -> !file.isDeleted()).collect(Collectors.toList());
        }
        this.setProperty("files", files);
        return this;
    }

    public ActivityEntity setOriginalActivity(DataEntity originalActivity) {
        this.setProperty("originalActivity", originalActivity);
        return this;
    }

    public DataEntity getOriginalActivity() {
        return (DataEntity)this.getProperty("originalActivity");
    }

    public ActivityEntity setTargetSpaces(List<String> targetSpaces) {
        this.setProperty("targetSpaces", targetSpaces);
        return this;
    }

    public List<String> getTargetSpaces() {
        return (List)this.getProperty("targetSpaces");
    }
}

