/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao.jpa;

import io.meeds.social.space.constant.SpaceMembershipStatus;
import io.meeds.social.space.constant.SpaceVisibility;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.jpa.search.XSpaceFilter;
import org.exoplatform.social.core.jpa.storage.entity.SpaceEntity;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.model.Space;

public class SpaceDAO
extends GenericDAOJPAImpl<SpaceEntity, Long> {
    private static final List<SpaceMembershipStatus> VISIBLE_STATUSES = Arrays.asList(SpaceMembershipStatus.MEMBER, SpaceMembershipStatus.INVITED);
    private static final String PARAM_PUBLIC_VISIBILITY = "publicVisibility";
    private static final String PARAM_IDS = "ids";
    private static final String PARAM_TEMPLATE_IDS = "templateIds";
    private static final String PARAM_EXCLUDED_IDS = "excludedIds";
    private static final String PARAM_PRIVATE_VISIBILITY = "privateVisibility";
    private static final String PARAM_USER_ID = "userId";
    private static final String PARAM_STATUSES = "statuses";
    private static final String PARAM_VISIBLE_STATUSES = "visibleStatuses";
    private static final String PARAM_MANAGING_TEMPLATE_IDS = "managingTemplateIds";
    private static final String PARAM_CATEGORY_IDS = "categoryIds";
    private static final String PARAM_KEYWORD = "keyword";
    private static final String PARAM_VISIBILITY = "visibility";
    private static final String PARAM_REGISTRATION = "registration";
    private static final String PARAM_HIDDEN_VISIBILITY = "hiddenVisibility";
    private static final String QUERY_FILTER_FIND_PREFIX = "Space.findSpaces";
    private static final String QUERY_FILTER_COUNT_PREFIX = "Space.countSpaces";
    private final Map<String, Boolean> filterNamedQueries = new ConcurrentHashMap<String, Boolean>();

    public List<Long> getLastSpaces(int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.getLastSpaces", Tuple.class);
        query.setMaxResults(limit);
        List resultList = query.getResultList();
        if (resultList == null || resultList.isEmpty()) {
            return Collections.emptyList();
        }
        return resultList.stream().map(tuple -> (Long)tuple.get(0, Long.class)).toList();
    }

    public SpaceEntity getSpaceByGroupId(String groupId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.getSpaceByGroupId", SpaceEntity.class);
        query.setParameter("groupId", (Object)groupId);
        try {
            return (SpaceEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public SpaceEntity getSpaceByPrettyName(String spacePrettyName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.getSpaceByPrettyName", SpaceEntity.class);
        query.setParameter("prettyName", (Object)spacePrettyName);
        query.setMaxResults(1);
        try {
            return (SpaceEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public List<SpaceEntity> getCommonSpaces(String userId, String otherUserId, int offset, int limit) {
        if (userId == null || userId.equals("")) {
            throw new IllegalArgumentException("the userId is null or equals to 0");
        }
        if (otherUserId == null || otherUserId.equals("")) {
            throw new IllegalArgumentException("the otherUserId is null or equals to 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset must be positive");
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be > 0");
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.getCommonSpacesBetweenTwoUsers", SpaceEntity.class);
        query.setParameter(PARAM_USER_ID, (Object)userId);
        query.setParameter("otherUserId", (Object)otherUserId);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    public int countCommonSpaces(String userId, String otherUserId) {
        if (userId == null || userId.equals("")) {
            throw new IllegalArgumentException("userId is null or equals to 0");
        }
        if (otherUserId == null || otherUserId.equals("")) {
            throw new IllegalArgumentException("otherUserId is null or equals to 0");
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.countCommonSpacesBetweenTwoUsers", Long.class);
        query.setParameter(PARAM_USER_ID, (Object)userId);
        query.setParameter("otherUserId", (Object)otherUserId);
        return ((Long)query.getSingleResult()).intValue();
    }

    public Map<Long, Long> countSpacesByTemplate() {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.countSpacesByTemplate", Tuple.class);
        List resultList = query.getResultList();
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return Collections.emptyMap();
        }
        return resultList.stream().collect(Collectors.toMap(t -> (Long)t.get(0, Long.class), t -> (Long)t.get(1, Long.class)));
    }

    public List<Long> getSpaceIdsByFilter(XSpaceFilter filter, long offset, long limit) {
        return this.findSpaceIdsByFilter(filter, offset, limit);
    }

    public int getSpacesCountByFilter(XSpaceFilter filter) {
        return this.countSpacesByFilter(filter);
    }

    public List<Long> findSpaceIdsByFilter(XSpaceFilter filter, long offset, long limit) {
        List result;
        TypedQuery<Tuple> query = this.buildQueryFromFilter(filter, Tuple.class, false);
        if (offset > 0L) {
            query.setFirstResult((int)offset);
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (CollectionUtils.isEmpty((Collection)(result = query.getResultList()))) {
            return Collections.emptyList();
        }
        return result.stream().map(t -> (Long)t.get(0, Long.class)).toList();
    }

    public int countSpacesByFilter(XSpaceFilter filter) {
        TypedQuery<Long> query = this.buildQueryFromFilter(filter, Long.class, true);
        return ((Long)query.getSingleResult()).intValue();
    }

    public List<Long> getSpaceCategoryIds() {
        return this.getEntityManager().createNamedQuery("SpaceEntity.getSpaceCategoryIds", Long.class).getResultList();
    }

    private <T> TypedQuery<T> buildQueryFromFilter(XSpaceFilter filter, Class<T> clazz, boolean count) {
        TypedQuery query;
        ArrayList<String> suffixes = new ArrayList<String>();
        ArrayList<String> predicates = new ArrayList<String>();
        ArrayList<String> parameterNames = new ArrayList<String>();
        this.buildPredicates(filter, suffixes, predicates, parameterNames);
        String queryName = this.getQueryFilterName(suffixes, count);
        if (this.filterNamedQueries.containsKey(queryName)) {
            query = this.getEntityManager().createNamedQuery(queryName, clazz);
        } else {
            String queryContent = this.getQueryFilterContent(filter, predicates, parameterNames, count);
            query = this.getEntityManager().createQuery(queryContent, clazz);
            this.getEntityManager().getEntityManagerFactory().addNamedQuery(queryName, (Query)query);
            this.filterNamedQueries.put(queryName, true);
        }
        this.addQueryFilterParameters(filter, query, parameterNames);
        return query;
    }

    private <T> void addQueryFilterParameters(XSpaceFilter filter, TypedQuery<T> query, List<String> parameterNames) {
        if (parameterNames.contains(PARAM_KEYWORD)) {
            query.setParameter(PARAM_KEYWORD, (Object)("%" + StringUtils.lowerCase((String)filter.getSpaceNameSearchCondition()) + "%"));
        }
        if (parameterNames.contains(PARAM_PUBLIC_VISIBILITY)) {
            query.setParameter(PARAM_PUBLIC_VISIBILITY, (Object)SpaceVisibility.PUBLIC);
        }
        if (parameterNames.contains(PARAM_PRIVATE_VISIBILITY)) {
            query.setParameter(PARAM_PRIVATE_VISIBILITY, (Object)SpaceVisibility.PRIVATE);
        }
        if (parameterNames.contains(PARAM_HIDDEN_VISIBILITY)) {
            query.setParameter(PARAM_HIDDEN_VISIBILITY, (Object)SpaceVisibility.HIDDEN);
        }
        if (parameterNames.contains(PARAM_IDS)) {
            if (CollectionUtils.isNotEmpty(filter.getIds())) {
                query.setParameter(PARAM_IDS, filter.getIds());
            } else {
                query.setParameter(PARAM_IDS, filter.getIncludeSpaces().stream().map(Space::getSpaceId).toList());
            }
        }
        if (parameterNames.contains(PARAM_TEMPLATE_IDS)) {
            query.setParameter(PARAM_TEMPLATE_IDS, (Object)filter.getTemplateIds());
        }
        if (parameterNames.contains(PARAM_EXCLUDED_IDS)) {
            query.setParameter(PARAM_EXCLUDED_IDS, (Object)filter.getExcludedIds());
        }
        if (parameterNames.contains(PARAM_USER_ID)) {
            query.setParameter(PARAM_USER_ID, (Object)filter.getRemoteId());
        }
        if (parameterNames.contains(PARAM_STATUSES)) {
            query.setParameter(PARAM_STATUSES, (Object)filter.getStatusList());
        }
        if (parameterNames.contains(PARAM_VISIBLE_STATUSES)) {
            query.setParameter(PARAM_VISIBLE_STATUSES, VISIBLE_STATUSES);
        }
        if (parameterNames.contains(PARAM_MANAGING_TEMPLATE_IDS)) {
            query.setParameter(PARAM_MANAGING_TEMPLATE_IDS, (Object)filter.getManagingTemplateIds());
        }
        if (parameterNames.contains(PARAM_CATEGORY_IDS)) {
            query.setParameter(PARAM_CATEGORY_IDS, (Object)filter.getCategoryIds());
        }
        if (parameterNames.contains(PARAM_VISIBILITY)) {
            query.setParameter(PARAM_VISIBILITY, (Object)filter.getVisibility());
        }
        if (parameterNames.contains(PARAM_REGISTRATION)) {
            query.setParameter(PARAM_REGISTRATION, (Object)filter.getRegistration());
        }
    }

    private String getQueryFilterName(List<String> suffixes, boolean count) {
        Object queryName = suffixes.isEmpty() ? (count ? QUERY_FILTER_COUNT_PREFIX : QUERY_FILTER_FIND_PREFIX) : (count ? QUERY_FILTER_COUNT_PREFIX : QUERY_FILTER_FIND_PREFIX) + "By" + StringUtils.join(suffixes, (String)"And");
        return queryName;
    }

    private String getQueryFilterContent(XSpaceFilter spaceFilter, List<String> predicates, List<String> parameterNames, boolean count) {
        Object querySelect = count ? "SELECT COUNT(DISTINCT s.id) FROM SocSpaceEntity s " : "SELECT DISTINCT(s.id), " + this.getSortField(spaceFilter) + " FROM SocSpaceEntity s ";
        boolean lastAccess = this.isLastAccess(spaceFilter);
        if (parameterNames.contains(PARAM_USER_ID) || lastAccess) {
            querySelect = StringUtils.isNotBlank((CharSequence)spaceFilter.getRemoteId()) && lastAccess ? (String)querySelect + " INNER JOIN s.members sm ON sm.userId = :userId AND sm.status = io.meeds.social.space.constant.SpaceMembershipStatus.MEMBER " : (String)querySelect + " INNER JOIN s.members sm ";
        }
        if (CollectionUtils.isNotEmpty((Collection)spaceFilter.getCategoryIds())) {
            querySelect = (String)querySelect + " INNER JOIN s.categories cat ON cat.categoryId in :categoryIds";
        }
        Object queryContent = predicates.isEmpty() ? querySelect : (String)querySelect + " WHERE " + StringUtils.join(predicates, (String)" AND ");
        if (!count) {
            queryContent = (String)queryContent + " ORDER BY " + this.getSortField(spaceFilter) + (this.isSortDescending(spaceFilter) ? " DESC " : " ASC ");
        }
        return queryContent;
    }

    private void buildPredicates(XSpaceFilter spaceFilter, List<String> suffixes, List<String> predicates, List<String> parameterNames) {
        if (CollectionUtils.isNotEmpty((Collection)spaceFilter.getTemplateIds())) {
            suffixes.add("TemplateId");
            predicates.add("s.templateId IN :templateIds");
            parameterNames.add(PARAM_TEMPLATE_IDS);
        }
        if (spaceFilter.getVisibility() != null) {
            suffixes.add("Visibility");
            predicates.add("s.visibility = :visibility");
            parameterNames.add(PARAM_VISIBILITY);
        }
        if (spaceFilter.getRegistration() != null) {
            suffixes.add("Registration");
            predicates.add("s.registration = :registration");
            parameterNames.add(PARAM_REGISTRATION);
        }
        if (CollectionUtils.isNotEmpty(spaceFilter.getIds()) || CollectionUtils.isNotEmpty((Collection)spaceFilter.getIncludeSpaces())) {
            suffixes.add("SpaceIds");
            predicates.add("s.id IN :ids");
            parameterNames.add(PARAM_IDS);
        }
        if (CollectionUtils.isNotEmpty((Collection)spaceFilter.getCategoryIds())) {
            suffixes.add("CategoryIds");
            parameterNames.add(PARAM_CATEGORY_IDS);
        }
        if (CollectionUtils.isNotEmpty((Collection)spaceFilter.getExcludedIds())) {
            suffixes.add("ExcludeSpaceIds");
            predicates.add("s.id NOT IN :excludedIds");
            parameterNames.add(PARAM_EXCLUDED_IDS);
        }
        if (StringUtils.isNotBlank((CharSequence)spaceFilter.getSpaceNameSearchCondition())) {
            suffixes.add("Keyword");
            predicates.add("(s.prettyName LIKE :keyword OR s.displayName LIKE :keyword OR s.description LIKE :keyword)");
            parameterNames.add(PARAM_KEYWORD);
        }
        if (this.isLastAccess(spaceFilter) && StringUtils.isNotBlank((CharSequence)spaceFilter.getRemoteId())) {
            suffixes.add("UserId");
            parameterNames.add(PARAM_USER_ID);
        }
        this.buildPermissionPredicates(spaceFilter, suffixes, predicates, parameterNames);
        this.buildSortSuffixes(spaceFilter, suffixes);
    }

    private void buildPermissionPredicates(XSpaceFilter spaceFilter, List<String> suffixes, List<String> predicates, List<String> parameterNames) {
        if (CollectionUtils.isNotEmpty((Collection)spaceFilter.getStatusList())) {
            if (spaceFilter.isIncludePrivate() || spaceFilter.isNotHidden()) {
                if (spaceFilter.getRemoteId() == null || StringUtils.equals((CharSequence)spaceFilter.getRemoteId(), (CharSequence)IdentityConstants.ANONIM)) {
                    suffixes.add("SpacePrivate");
                    predicates.add("s.visibility <> :hiddenVisibility");
                    parameterNames.add(PARAM_HIDDEN_VISIBILITY);
                } else if (CollectionUtils.isEmpty((Collection)spaceFilter.getManagingTemplateIds())) {
                    suffixes.add("SpacePrivateOrStatuses");
                    predicates.add("(s.visibility <> :hiddenVisibility OR (sm.userId = :userId AND sm.status IN :statuses))");
                    parameterNames.add(PARAM_HIDDEN_VISIBILITY);
                    parameterNames.add(PARAM_USER_ID);
                    parameterNames.add(PARAM_STATUSES);
                } else if (!spaceFilter.getManagingTemplateIds().contains(0L)) {
                    suffixes.add("SpacePrivateOrStatusesOrManaging");
                    predicates.add("(s.visibility <> :hiddenVisibility OR s.templateId IN :managingTemplateIds OR (sm.userId = :userId AND sm.status IN :statuses))");
                    parameterNames.add(PARAM_HIDDEN_VISIBILITY);
                    parameterNames.add(PARAM_USER_ID);
                    parameterNames.add(PARAM_STATUSES);
                    parameterNames.add(PARAM_MANAGING_TEMPLATE_IDS);
                }
            } else if (spaceFilter.getRemoteId() == null || StringUtils.equals((CharSequence)spaceFilter.getRemoteId(), (CharSequence)IdentityConstants.ANONIM)) {
                suffixes.add("SpacePrivate");
                predicates.add("s.visibility <> :hiddenVisibility");
                parameterNames.add(PARAM_HIDDEN_VISIBILITY);
            } else if (CollectionUtils.isEmpty((Collection)spaceFilter.getManagingTemplateIds())) {
                suffixes.add("SpaceWithStatuses");
                predicates.add("sm.userId = :userId AND sm.status IN :statuses");
                parameterNames.add(PARAM_USER_ID);
                parameterNames.add(PARAM_STATUSES);
            } else if (!spaceFilter.getManagingTemplateIds().contains(0L)) {
                suffixes.add("SpaceWithStatusesOrManaging");
                predicates.add("(s.templateId IN :managingTemplateIds OR (sm.userId = :userId AND sm.status IN :statuses))");
                parameterNames.add(PARAM_USER_ID);
                parameterNames.add(PARAM_STATUSES);
                parameterNames.add(PARAM_MANAGING_TEMPLATE_IDS);
            }
        } else if (spaceFilter.getRemoteId() != null) {
            if (StringUtils.equals((CharSequence)spaceFilter.getRemoteId(), (CharSequence)IdentityConstants.ANONIM)) {
                suffixes.add("SpacePrivate");
                predicates.add("s.visibility <> :hiddenVisibility");
                parameterNames.add(PARAM_HIDDEN_VISIBILITY);
            } else if (CollectionUtils.isEmpty((Collection)spaceFilter.getManagingTemplateIds())) {
                suffixes.add("SpaceWithVisibleStatus");
                predicates.add("(s.visibility <> :hiddenVisibility OR (sm.userId = :userId AND sm.status IN :visibleStatuses))");
                parameterNames.add(PARAM_HIDDEN_VISIBILITY);
                parameterNames.add(PARAM_USER_ID);
                parameterNames.add(PARAM_VISIBLE_STATUSES);
            } else {
                suffixes.add("SpaceWithVisibleStatusOrManaging");
                predicates.add("(s.visibility <> :hiddenVisibility OR s.templateId IN :managingTemplateIds OR (sm.userId = :userId AND sm.status IN :visibleStatuses))");
                parameterNames.add(PARAM_HIDDEN_VISIBILITY);
                parameterNames.add(PARAM_MANAGING_TEMPLATE_IDS);
                parameterNames.add(PARAM_USER_ID);
                parameterNames.add(PARAM_VISIBLE_STATUSES);
            }
        }
    }

    private void buildSortSuffixes(XSpaceFilter spaceFilter, List<String> suffixes) {
        String sortField = this.getSortField(spaceFilter);
        suffixes.add("OrderBy");
        suffixes.add(StringUtils.capitalize((String)sortField.replace("s.", "").replace("sm.", "")));
        if (this.isSortDescending(spaceFilter)) {
            suffixes.add("DESC");
        } else {
            suffixes.add("ASC");
        }
    }

    private String getSortField(XSpaceFilter spaceFilter) {
        Sorting sorting = spaceFilter.getSorting();
        if (this.isLastAccess(spaceFilter)) {
            return "sm.lastAccess";
        }
        if (sorting.sortBy.equals((Object)Sorting.SortBy.DATE)) {
            return "s.createdDate";
        }
        return "s.displayName";
    }

    private boolean isSortDescending(XSpaceFilter spaceFilter) {
        return this.isLastAccess(spaceFilter) || spaceFilter.getSorting() == null || spaceFilter.getSorting().orderBy.equals((Object)Sorting.OrderBy.DESC);
    }

    private boolean isLastAccess(XSpaceFilter spaceFilter) {
        return spaceFilter.isLastAccess() || spaceFilter.getSorting() != null && spaceFilter.getSorting().sortBy.equals((Object)Sorting.SortBy.LASTVISITED);
    }
}

