/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.hateoas.server.core.DefaultMethodInvocation;
import org.springframework.hateoas.server.core.LastInvocationAware;
import org.springframework.hateoas.server.core.MethodInvocation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentLruCache;
import org.springframework.util.ReflectionUtils;

public class DummyInvocationUtils {
    private static final ThreadLocal<ConcurrentLruCache<CacheKey, Object>> CACHE = ThreadLocal.withInitial(() -> new ConcurrentLruCache(256, it -> {
        InvocationRecordingMethodInterceptor interceptor = new InvocationRecordingMethodInterceptor(it.type, it.arguments);
        return DummyInvocationUtils.getProxyWithInterceptor(it.type, interceptor, it.type.getClassLoader());
    }));

    public static <T> T methodOn(Class<T> type, Object ... parameters) {
        Assert.notNull(type, (String)"Given type must not be null!");
        return (T)CACHE.get().get((Object)CacheKey.of(type, parameters));
    }

    @Nullable
    public static LastInvocationAware getLastInvocationAware(Object source) {
        if (InvocationRecordingMethodInterceptor.class.isInstance(source)) {
            return (LastInvocationAware)LastInvocationAware.class.cast(source);
        }
        return (LastInvocationAware)(Advised.class.isInstance(source) ? ((Advised)source).getAdvisors()[0].getAdvice() : source);
    }

    public static LastInvocationAware getLastInvocationAware(Method method, Object[] parameters) {
        return DummyInvocationUtils.getLastInvocationAware(method.getDeclaringClass(), method, parameters);
    }

    public static LastInvocationAware getLastInvocationAware(Class<?> type, Method method, Object[] parameters) {
        return new DefaultMethodInvocation(type, method, parameters);
    }

    public static void resetCache() {
        CACHE.remove();
    }

    private static <T> T getProxyWithInterceptor(Class<?> type, InvocationRecordingMethodInterceptor interceptor, ClassLoader classLoader) {
        if (type.equals(Object.class)) {
            return (T)interceptor;
        }
        ProxyFactory factory = new ProxyFactory();
        factory.addAdvice((Advice)interceptor);
        factory.addInterface(LastInvocationAware.class);
        if (type.isInterface()) {
            factory.addInterface(type);
        } else {
            factory.setOptimize(true);
            factory.setTargetClass(type);
            factory.setProxyTargetClass(true);
        }
        return (T)factory.getProxy(classLoader);
    }

    private static final class CacheKey {
        private final Class<?> type;
        private final Object[] arguments;

        private CacheKey(Class<?> type, Object[] arguments) {
            this.type = type;
            this.arguments = arguments;
        }

        public static CacheKey of(Class<?> type, Object[] arguments) {
            return new CacheKey(type, arguments);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.type, cacheKey.type) && Arrays.equals(this.arguments, cacheKey.arguments);
        }

        public int hashCode() {
            int result = Objects.hash(this.type);
            result = 31 * result + Arrays.hashCode(this.arguments);
            return result;
        }

        public String toString() {
            return "DummyInvocationUtils.CacheKey(type=" + this.type + ", arguments=" + Arrays.deepToString(this.arguments) + ")";
        }
    }

    private static class InvocationRecordingMethodInterceptor
    implements MethodInterceptor,
    LastInvocationAware {
        private final Class<?> targetType;
        private final Object[] objectParameters;
        private MethodInvocation invocation;

        InvocationRecordingMethodInterceptor(Class<?> targetType, Object ... parameters) {
            Assert.notNull(targetType, (String)"Target type must not be null!");
            Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
            this.targetType = targetType;
            this.objectParameters = (Object[])parameters.clone();
        }

        @Nullable
        public Object invoke(org.aopalliance.intercept.MethodInvocation invocation) {
            Method method = invocation.getMethod();
            if (ReflectionUtils.isObjectMethod((Method)method)) {
                return ReflectionUtils.invokeMethod((Method)method, (Object)invocation.getThis(), (Object[])invocation.getArguments());
            }
            this.invocation = new DefaultMethodInvocation(this.targetType, method, invocation.getArguments());
            Class<?> returnType = method.getReturnType();
            ClassLoader classLoader = method.getDeclaringClass().getClassLoader();
            return returnType.cast(DummyInvocationUtils.getProxyWithInterceptor(returnType, this, classLoader));
        }

        @Override
        public MethodInvocation getLastInvocation() {
            return this.invocation;
        }

        @Override
        public Iterator<Object> getObjectParameters() {
            return Arrays.asList(this.objectParameters).iterator();
        }
    }
}

