/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.jakarta.JakartaServletDiskFileUpload;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.provider.EntityProvider;

@Provider
@Consumes(value={"multipart/*"})
public class MultipartFormDataEntityProvider
implements EntityProvider<Iterator<? extends FileItem>> {
    @Context
    private HttpServletRequest httpRequest;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (type == Iterator.class && genericType instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)genericType;
            Type[] ta = t.getActualTypeArguments();
            return ta.length == 1 && ta[0] == FileItem.class;
        }
        return false;
    }

    public Iterator<? extends FileItem> readFrom(Class<Iterator<? extends FileItem>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            ApplicationContext context = ApplicationContextImpl.getCurrent();
            int bufferSize = context.getProperties().get("ws.rs.buffersize") == null ? 204800 : Integer.parseInt((String)context.getProperties().get("ws.rs.buffersize"));
            File repo = new File((String)context.getProperties().get("ws.rs.tmpdir"));
            DiskFileItemFactory factory = ((DiskFileItemFactory.Builder)((DiskFileItemFactory.Builder)((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setBufferSize(bufferSize)).setFile(repo)).setCharset(StandardCharsets.UTF_8)).get();
            JakartaServletDiskFileUpload servletUpload = new JakartaServletDiskFileUpload(factory);
            servletUpload.setHeaderCharset(StandardCharsets.UTF_8);
            List fileItems = servletUpload.parseRequest(this.httpRequest);
            return fileItems == null ? Collections.emptyIterator() : fileItems.iterator();
        }
        catch (FileUploadException e) {
            throw new IOException("Can't process multipart data item ", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't process multipart data item ", e);
        }
    }

    public long getSize(Iterator<? extends FileItem> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return false;
    }

    public void writeTo(Iterator<? extends FileItem> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        throw new UnsupportedOperationException();
    }
}

