/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.dao;

import io.meeds.appcenter.entity.ApplicationEntity;
import io.meeds.appcenter.entity.FavoriteApplicationEntity;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Component;

@Component
public interface ApplicationDAO
extends JpaRepository<ApplicationEntity, Long> {
    @Query(value="SELECT app FROM ApplicationEntity app\nWHERE app.active = TRUE\nAND app.isMandatory = TRUE\n")
    public List<ApplicationEntity> getMandatoryActiveApps();

    @Query(value="SELECT app FROM ApplicationEntity app\n")
    public List<ApplicationEntity> getApplications(Sort var1);

    default public List<ApplicationEntity> getApplications() {
        return this.getApplications(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"title").ignoreCase()}));
    }

    @Query(value="SELECT app FROM ApplicationEntity app\nWHERE LOWER(app.title) LIKE %?1%\nOR LOWER(app.description) like %?1%\nOR LOWER(app.url) LIKE %?1%\nORDER BY LOWER(app.title)\n")
    public List<ApplicationEntity> getApplications(String var1, Sort var2);

    default public List<ApplicationEntity> getApplications(String keyword) {
        return this.getApplications(keyword, Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"title").ignoreCase()}));
    }

    @Query(value="SELECT app FROM ApplicationEntity app\nWHERE app.system = TRUE\n")
    public List<ApplicationEntity> getSystemApplications();

    @Query(value="SELECT app FROM ApplicationEntity app\nWHERE app.title = ?1\n")
    public ApplicationEntity getApplicationByTitle(String var1);

    default public List<ApplicationEntity> findAll() {
        return this.findAll(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"title").ignoreCase()}));
    }

    @Query(value="SELECT new FavoriteApplicationEntity(favoriteApp.id, app, favoriteApp.userName, favoriteApp.order)\nFROM ApplicationEntity app\nLEFT JOIN FavoriteApplicationEntity favoriteApp       ON app.id = favoriteApp.application.id AND favoriteApp.userName = :userName\nWHERE app.active = TRUE AND (favoriteApp.id IS NOT NULL OR app.isMandatory = TRUE)\nORDER BY favoriteApp.order NULLS LAST, app.isMandatory DESC\n")
    public Page<FavoriteApplicationEntity> findFavoriteAndMandatoryApplications(@Param(value="userName") String var1, Pageable var2);
}

