/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search;

import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.search.ProfileIndexDocument;
import org.exoplatform.social.core.jpa.storage.dao.ConnectionDAO;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertyOption;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.relationship.model.Relationship;

public class ProfileIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    public static final String TYPE = "profile";
    private static final Log LOG = ExoLogger.getLogger(ProfileIndexingServiceConnector.class);
    private final IdentityManager identityManager;
    private final ConnectionDAO connectionDAO;
    private final IdentityDAO identityDAO;
    private final ProfilePropertyService profilePropertyService;
    private final TranslationService translationService;
    private static final String HIDDEN_VALUE = "hidden";
    private static final String PROFILE_PROPERTY_FIELD_NAME = "optionValue";
    private static final String PROFILE_PROPERTY_OBJECT_TYPE = "propertySettingOption";

    public ProfileIndexingServiceConnector(InitParams initParams, IdentityManager identityManager, IdentityDAO identityDAO, ConnectionDAO connectionDAO, ProfilePropertyService profilePropertyService, TranslationService translationService) {
        super(initParams);
        this.identityManager = identityManager;
        this.identityDAO = identityDAO;
        this.connectionDAO = connectionDAO;
        this.profilePropertyService = profilePropertyService;
        this.translationService = translationService;
    }

    public Document create(String id) {
        return this.getDocument(id);
    }

    public Document update(String id) {
        return this.getDocument(id);
    }

    public String getConnectorName() {
        return TYPE;
    }

    private String buildConnectionString(Identity identity, Relationship.Type type) {
        int offset;
        StringBuilder sb = new StringBuilder();
        int limit = 200;
        List<Long> list = null;
        long id = Long.parseLong(identity.getId());
        boolean inSender = true;
        boolean inReceiver = true;
        if (type == Relationship.Type.OUTGOING) {
            inSender = false;
            type = Relationship.Type.PENDING;
        } else if (type == Relationship.Type.INCOMING) {
            inReceiver = false;
            type = Relationship.Type.PENDING;
        }
        if (inSender) {
            offset = 0;
            do {
                list = this.connectionDAO.getSenderIds(id, type, offset, 200);
                sb = this.append(sb, list);
                offset += 200;
            } while (list != null && list.size() >= 200);
        }
        if (inReceiver) {
            offset = 0;
            do {
                list = this.connectionDAO.getReceiverIds(id, type, offset, 200);
                sb = this.append(sb, list);
                offset += 200;
            } while (list != null && list.size() >= 200);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private StringBuilder append(StringBuilder sb, List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return sb;
        }
        int len = ids.size() * 10;
        if (sb.capacity() < sb.length() + len) {
            sb = new StringBuilder(sb.capacity() + len).append((CharSequence)sb);
        }
        for (Long id : ids) {
            sb.append(id).append(",");
        }
        return sb;
    }

    public List<String> getAllIds(int offset, int limit) {
        List<Long> ids = this.identityDAO.getAllIdsByProvider("organization", offset, limit);
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>(ids.size());
        for (Long id : ids) {
            result.add(String.valueOf(id));
        }
        return result;
    }

    public String getMapping() {
        StringBuilder profileSettingsFieldsMapping = new StringBuilder();
        for (ProfilePropertySetting propertySetting : this.profilePropertyService.getPropertySettings()) {
            if (!propertySetting.isVisible() || !propertySetting.isEditable() || propertySetting.isMultiValued() || propertySetting.getParentId() != null || propertySetting.isHasChildProperties() || "email".equals(propertySetting.getPropertyName())) continue;
            profileSettingsFieldsMapping.append("    \"").append(propertySetting.getPropertyName().equals("fullName") ? "name" : propertySetting.getPropertyName()).append("\" : {").append("      \"type\" : \"text\",").append("      \"index_options\": \"offsets\",").append("      \"fields\": {").append("        \"raw\": {").append("          \"type\": \"keyword\"").append("        },").append("        \"whitespace\": {").append("          \"type\": \"text\",").append("          \"analyzer\": \"whitespace_lowercase_asciifolding\"").append("        }").append("      }").append("    },\n");
        }
        StringBuilder mapping = new StringBuilder().append("{").append("  \"dynamic_templates\": [\n    {\n    \"strings_dynamic_mapping\": {\n        \"match_mapping_type\": \"string\",\n        \"mapping\": {\n          \"type\": \"text\",\n          \"fields\": {\n            \"raw\": {\n            \"type\": \"keyword\"\n          },\n          \"whitespace\": {\n            \"type\": \"text\",\n            \"analyzer\": \"whitespace_lowercase_asciifolding\"\n          }\n        },\n        \"index_options\": \"offsets\"\n        }\n      }\n    }\n  ],\n").append("  \"properties\" : {\n").append("    \"userName\" : {\"type\" : \"keyword\"},\n").append((CharSequence)profileSettingsFieldsMapping).append("    \"email\" : {\"type\" : \"keyword\"},\n").append("    \"connections\" : {\"type\" : \"long\"},\n").append("    \"avatarUrl\" : {\"type\" : \"text\", \"index\": false},\n").append("    \"skills\" : {\"type\" : \"text\", \"index_options\": \"offsets\"},\n").append("    \"aboutMe\" : {\"type\" : \"text\", \"index_options\": \"offsets\"},\n").append("    \"lastUpdatedDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"}\n").append("  }\n").append("}");
        return mapping.toString();
    }

    private Document getDocument(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("id is mandatory");
        }
        long ts = System.currentTimeMillis();
        LOG.debug("get profile document for identity id={}", new Object[]{id});
        Identity identity = this.identityManager.getIdentity(id);
        Profile profile = identity.getProfile();
        boolean isExternal = profile.getProperty("external") != null && profile.getProperty("external").equals("true");
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("name", profile.getFullName());
        fields.put("firstName", (String)profile.getProperty("firstName"));
        fields.put("lastName", (String)profile.getProperty("lastName"));
        fields.put("position", ProfileIndexingServiceConnector.removeAccents(profile.getPosition()));
        fields.put("aboutMe", ProfileIndexingServiceConnector.removeAccents(profile.getAboutMe()));
        fields.put("skills", ProfileIndexingServiceConnector.removeAccents((String)profile.getProperty("skills")));
        fields.put("avatarUrl", profile.getAvatarUrl());
        fields.put("userName", identity.getRemoteId());
        fields.put("email", profile.getEmail());
        fields.put("external", String.valueOf(isExternal));
        if (profile.getProperty("lastLoginTime") != null) {
            fields.put("lastLoginTime", profile.getProperty("lastLoginTime").toString());
        }
        if (profile.getProperty("enrollmentDate") != null) {
            fields.put("enrollmentDate", profile.getProperty("enrollmentDate").toString());
        }
        Date createdDate = new Date(profile.getCreatedTime());
        for (ProfilePropertySetting profilePropertySetting : this.profilePropertyService.getPropertySettings()) {
            String value;
            List multiValues;
            String value2;
            if (!profilePropertySetting.isVisible() || fields.containsKey(profilePropertySetting.getPropertyName())) continue;
            Object propertyValue = profile.getProperty(profilePropertySetting.getPropertyName());
            if (propertyValue instanceof String && StringUtils.isNotEmpty((CharSequence)(value2 = (String)propertyValue))) {
                this.addPropertyToDocumentFields(fields, profilePropertySetting.getPropertyName(), this.parseValue(profilePropertySetting, value2), Long.parseLong(id));
                continue;
            }
            if (!(propertyValue instanceof List) || !CollectionUtils.isNotEmpty((Collection)(multiValues = (List)propertyValue)) || !StringUtils.isNotEmpty((CharSequence)(value = multiValues.stream().filter(property -> property.get("value") != null).map(property -> this.parseValue(profilePropertySetting, (String)property.get("value"))).collect(Collectors.joining(",", "", ""))))) continue;
            this.addPropertyToDocumentFields(fields, profilePropertySetting.getPropertyName(), ProfileIndexingServiceConnector.removeAccents(value), Long.parseLong(id));
        }
        String connectionsStr = this.buildConnectionString(identity, Relationship.Type.CONFIRMED);
        if (!connectionsStr.isEmpty()) {
            fields.put("connections", "@@@[" + connectionsStr + "]@@@");
        }
        ProfileIndexDocument document = new ProfileIndexDocument(id, null, createdDate, null, fields);
        LOG.info("profile document generated for identity id={} remote_id={} duration_ms={}", new Object[]{id, identity.getRemoteId(), System.currentTimeMillis() - ts});
        return document;
    }

    private void addPropertyToDocumentFields(Map<String, String> fields, String propertyName, String value, long userIdentityId) {
        if (this.isPropertyHidden(propertyName, userIdentityId).booleanValue()) {
            fields.put(propertyName.replace(".", "_"), HIDDEN_VALUE);
        } else {
            fields.put(propertyName.replace(".", "_"), value);
        }
    }

    private Boolean isPropertyHidden(String propertyName, long userIdentityId) {
        ProfilePropertySetting propertySetting = this.profilePropertyService.getProfileSettingByName(propertyName);
        if (propertySetting != null) {
            return this.profilePropertyService.getHiddenProfilePropertyIds(userIdentityId).contains(propertySetting.getId());
        }
        return false;
    }

    private static String removeAccents(String string) {
        if (StringUtils.isNotBlank((CharSequence)string)) {
            string = Normalizer.normalize(string, Normalizer.Form.NFD);
            string = string.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        }
        return string;
    }

    private String parseValue(ProfilePropertySetting profilePropertySetting, String value) {
        if (!profilePropertySetting.isDropdownList()) {
            return value;
        }
        String optionValue = profilePropertySetting.getPropertyOptions().stream().filter(option -> option.getId() == Long.parseLong(value)).findFirst().map(ProfilePropertyOption::getValue).orElse(value);
        try {
            TranslationField translationField = this.translationService.getTranslationField(PROFILE_PROPERTY_OBJECT_TYPE, Long.parseLong(value), PROFILE_PROPERTY_FIELD_NAME);
            if (translationField != null && !translationField.getLabels().isEmpty()) {
                String translations = String.join((CharSequence)"-", translationField.getLabels().values());
                return String.join((CharSequence)"-", optionValue, translations);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error parsing profile property value translations", (Throwable)e);
        }
        return optionValue;
    }
}

