/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.link.rest;

import io.meeds.social.link.model.Link;
import io.meeds.social.link.model.LinkSetting;
import io.meeds.social.link.rest.model.LinkSettingRestEntity;
import io.meeds.social.link.rest.util.LinkEntityBuilder;
import io.meeds.social.link.service.LinkService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.rest.api.RestUtils;

@Path(value="/social/links")
@Tag(name="/social/links", description="Managing links for Links Application")
public class LinkRest
implements ResourceContainer {
    private static final CacheControl CACHE_CONTROL = new CacheControl();
    private static final CacheControl IMG_CACHE_CONTROL = new CacheControl();
    private static final int CACHE_IN_SECONDS = 31536000;
    private static final long CACHE_IN_MILLI_SECONDS = 31536000000L;
    private static final Log LOG = ExoLogger.getLogger(LinkRest.class);
    private LinkService linkService;

    public LinkRest(LinkService linkService) {
        this.linkService = linkService;
    }

    @GET
    @Path(value="{name}")
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves a link application settings with associated links", description="Retrieves a link application settings with associated links", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="304", description="Not modified"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getLinkSetting(@Context Request request, @Parameter(description="Link name", required=true) @PathParam(value="name") String name, @Parameter(description="User language", required=false) @QueryParam(value="lang") String lang) {
        try {
            LinkSetting linkSetting = this.linkService.getLinkSetting(name, lang, RestUtils.getCurrentUserAclIdentity());
            if (linkSetting == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            EntityTag eTag = new EntityTag(String.valueOf(linkSetting.hashCode()));
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                builder = Response.ok((Object)this.getLinkSettingEntity(linkSetting, lang));
            }
            builder.lastModified(new Date(linkSetting.getLastModified()));
            builder.tag(eTag);
            builder.cacheControl(CACHE_CONTROL);
            return builder.build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("Error accessing setting {} for user {}", new Object[]{name, RestUtils.getCurrentUser(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    @PUT
    @Path(value="{name}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Saves a link application settings with associated links", description="Saves a link application settings with associated links", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized")})
    public Response saveLinkSetting(LinkSettingRestEntity linkSettingEntity) {
        try {
            LinkSetting linkSetting = LinkEntityBuilder.toLinkSetting(linkSettingEntity);
            List<Link> linksToSave = LinkEntityBuilder.toLinks(linkSettingEntity);
            linkSetting = this.linkService.saveLinkSetting(linkSetting, linksToSave, RestUtils.getCurrentUserAclIdentity());
            return Response.ok((Object)this.getLinkSettingEntity(linkSetting, null)).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("Error saving setting '{}' by user '{}'", new Object[]{linkSettingEntity, RestUtils.getCurrentUser(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="{name}/{id}/icon")
    @Operation(summary="Gets a link icon specified by setting name and link id", method="GET", description="Gets a link icon specified by setting name and link id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="304", description="Not modified"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getLinkIcon(@Context Request request, @Parameter(description="Link setting name", required=true) @PathParam(value="name") String name, @Parameter(description="Link id", required=true) @PathParam(value="id") long id) {
        try {
            LinkSetting linkSetting = this.linkService.getLinkSetting(name, null, RestUtils.getCurrentUserAclIdentity());
            if (linkSetting == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            EntityTag eTag = new EntityTag(String.valueOf(linkSetting.getLastModified()));
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                InputStream stream = this.linkService.getLinkIconStream(linkSetting.getName(), id);
                if (stream == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                builder = Response.ok((Object)stream, (String)"image/png");
                builder.lastModified(new Date(linkSetting.getLastModified()));
                builder.tag(eTag);
                builder.cacheControl(IMG_CACHE_CONTROL);
                builder.expires(new Date(System.currentTimeMillis() + 31536000000L));
            }
            return builder.build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("Error getting icon for link '{}/{}' by user '{}'", new Object[]{name, id, RestUtils.getCurrentUser(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (IOException e) {
            LOG.warn("Error getting icon for link '{}/{}' by user '{}'", new Object[]{name, id, RestUtils.getCurrentUser(), e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private LinkSettingRestEntity getLinkSettingEntity(LinkSetting linkSetting, String lang) {
        List links = this.linkService.getLinks(linkSetting.getName(), lang, true);
        return LinkEntityBuilder.build(linkSetting, links);
    }

    static {
        CACHE_CONTROL.setNoCache(true);
        IMG_CACHE_CONTROL.setMaxAge(31536000);
    }
}

