/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.i18n;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.i18n.ResourceBundleFactory;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class ResourceBundleManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<Locale, BundleRef> localeBundles;
    private final ResourceBundle defaultBundle;
    private final ResourceBundleFactory resourceBundleFactory;

    public ResourceBundleManager(ResourceBundle defaultBundle, ResourceBundleFactory resourceBundleFactory) throws IllegalArgumentException {
        if (resourceBundleFactory == null) {
            throw new IllegalArgumentException("Need a resource bundle factory");
        }
        this.localeBundles = new ConcurrentHashMap<Locale, BundleRef>();
        this.defaultBundle = defaultBundle;
        this.resourceBundleFactory = resourceBundleFactory;
    }

    public LocalizedString getLocalizedValue(String key, String defaultValue) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("No null key accepted");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("No null default value accepted");
        }
        HashMap<Locale, String> m = new HashMap<Locale, String>();
        for (Map.Entry entry : this.localeBundles.entrySet()) {
            try {
                Locale locale = (Locale)entry.getKey();
                ResourceBundle container = ((BundleRef)entry.getValue()).bundle;
                if (container == null) continue;
                String localizedDisplayName = container.getString(key);
                m.put(locale, localizedDisplayName);
            }
            catch (MissingResourceException ignore) {}
        }
        if (!m.containsKey(Locale.ENGLISH)) {
            m.put(Locale.ENGLISH, defaultValue);
        }
        return new LocalizedString(m, Locale.ENGLISH);
    }

    public ResourceBundle getResourceBundle(Locale locale) throws IllegalArgumentException {
        if (locale == null) {
            throw new IllegalArgumentException("Locale cannot be null");
        }
        BundleRef ref = (BundleRef)this.localeBundles.get(locale);
        if (ref != null) {
            return ref.bundle;
        }
        this.log.debug((Object)("Want to load bundle for locale " + locale));
        ResourceBundle bundle = this.resourceBundleFactory.getBundle(locale);
        if (bundle != null) {
            this.log.debug((Object)("Obtained bundle " + bundle + " with locale " + bundle.getLocale() + " for locale " + locale));
        } else {
            this.log.debug((Object)("No bundle obtained for locale " + locale + " will use default bundle " + this.defaultBundle + " instead"));
        }
        this.localeBundles.put(locale, new BundleRef(bundle));
        return bundle;
    }

    private static class BundleRef {
        final ResourceBundle bundle;

        private BundleRef(ResourceBundle bundle) {
            this.bundle = bundle;
        }
    }
}

