/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.activity;

import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.service.KudosService;
import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.social.core.ActivityTypePlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.utils.MentionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KudosActivityTypePlugin
extends ActivityTypePlugin {
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private KudosService kudosService;

    public KudosActivityTypePlugin() {
        super(KudosActivityTypePlugin.initParams());
    }

    @PostConstruct
    public void init() {
        this.activityManager.addActivityTypePlugin((ActivityTypePlugin)this);
    }

    public boolean isEnableNotification(ExoSocialActivity activity, String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return false;
        }
        Kudos kudos = this.kudosService.getKudosByActivityId(Long.parseLong(activity.getId().replace("comment", "")));
        return kudos != null && !"space".equals(kudos.getReceiverType()) && !StringUtils.equals((CharSequence)kudos.getReceiverId(), (CharSequence)username) && !StringUtils.equals((CharSequence)kudos.getSenderId(), (CharSequence)username);
    }

    public String getActivityTitle(ExoSocialActivity activity) {
        Kudos kudos = this.kudosService.getKudosByActivityId(Long.parseLong(activity.getId().replace("comment", "")));
        return kudos == null ? activity.getTitle() : MentionUtils.substituteUsernames((String)kudos.getMessage());
    }

    private static InitParams initParams() {
        InitParams initParams = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("type");
        param.setValue("exokudos:activity");
        initParams.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("enableNotification");
        param.setValue("true");
        initParams.addParameter((Parameter)param);
        return initParams;
    }
}

