/*
 * Decompiled with CFR 0.152.
 */
package nl.martijndwars.webpush;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import nl.martijndwars.webpush.Base64Encoder;
import nl.martijndwars.webpush.Subscription;
import nl.martijndwars.webpush.Urgency;
import nl.martijndwars.webpush.Utils;
import org.bouncycastle.jce.interfaces.ECPublicKey;

public class Notification {
    private final String endpoint;
    private final ECPublicKey userPublicKey;
    private final byte[] userAuth;
    private final byte[] payload;
    private Urgency urgency;
    private String topic;
    private final int ttl;
    private static final int ONE_DAY_DURATION_IN_SECONDS = 86400;
    private static int DEFAULT_TTL = 2419200;

    public Notification(String endpoint, ECPublicKey userPublicKey, byte[] userAuth, byte[] payload, int ttl, Urgency urgency, String topic) {
        this.endpoint = endpoint;
        this.userPublicKey = userPublicKey;
        this.userAuth = userAuth;
        this.payload = payload;
        this.ttl = ttl;
        this.urgency = urgency;
        this.topic = topic;
    }

    public Notification(String endpoint, PublicKey userPublicKey, byte[] userAuth, byte[] payload, int ttl) {
        this(endpoint, (ECPublicKey)userPublicKey, userAuth, payload, ttl, null, null);
    }

    public Notification(String endpoint, String userPublicKey, String userAuth, byte[] payload, int ttl) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        this(endpoint, Utils.loadPublicKey(userPublicKey), Base64Encoder.decode(userAuth), payload, ttl);
    }

    public Notification(String endpoint, PublicKey userPublicKey, byte[] userAuth, byte[] payload) {
        this(endpoint, userPublicKey, userAuth, payload, DEFAULT_TTL);
    }

    public Notification(String endpoint, String userPublicKey, String userAuth, byte[] payload) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        this(endpoint, Utils.loadPublicKey(userPublicKey), Base64Encoder.decode(userAuth), payload);
    }

    public Notification(String endpoint, String userPublicKey, String userAuth, String payload) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        this(endpoint, Utils.loadPublicKey(userPublicKey), Base64Encoder.decode(userAuth), payload.getBytes(StandardCharsets.UTF_8));
    }

    public Notification(String endpoint, String userPublicKey, String userAuth, String payload, Urgency urgency) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        this(endpoint, Utils.loadPublicKey(userPublicKey), Base64Encoder.decode(userAuth), payload.getBytes(StandardCharsets.UTF_8));
        this.urgency = urgency;
    }

    public Notification(Subscription subscription, String payload) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        this(subscription.endpoint, subscription.keys.p256dh, subscription.keys.auth, payload);
    }

    public Notification(Subscription subscription, String payload, Urgency urgency) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        this(subscription.endpoint, subscription.keys.p256dh, subscription.keys.auth, payload);
        this.urgency = urgency;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public ECPublicKey getUserPublicKey() {
        return this.userPublicKey;
    }

    public byte[] getUserAuth() {
        return this.userAuth;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public boolean hasPayload() {
        return this.getPayload().length > 0;
    }

    public boolean hasUrgency() {
        return this.urgency != null;
    }

    public boolean hasTopic() {
        return this.topic != null;
    }

    public boolean isGcm() {
        return this.getEndpoint().indexOf("https://android.googleapis.com/gcm/send") == 0;
    }

    public boolean isFcm() {
        return this.getEndpoint().indexOf("https://fcm.googleapis.com/fcm/send") == 0;
    }

    public int getTTL() {
        return this.ttl;
    }

    public Urgency getUrgency() {
        return this.urgency;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getOrigin() throws MalformedURLException {
        URL url = new URL(this.getEndpoint());
        return url.getProtocol() + "://" + url.getHost();
    }

    public static NotificationBuilder builder() {
        return new NotificationBuilder();
    }

    static /* synthetic */ int access$100() {
        return DEFAULT_TTL;
    }

    public static class NotificationBuilder {
        private String endpoint = null;
        private ECPublicKey userPublicKey = null;
        private byte[] userAuth = null;
        private byte[] payload = null;
        private int ttl = Notification.access$100();
        private Urgency urgency = null;
        private String topic = null;

        private NotificationBuilder() {
        }

        public Notification build() {
            return new Notification(this.endpoint, this.userPublicKey, this.userAuth, this.payload, this.ttl, this.urgency, this.topic);
        }

        public NotificationBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public NotificationBuilder userPublicKey(PublicKey publicKey) {
            this.userPublicKey = (ECPublicKey)publicKey;
            return this;
        }

        public NotificationBuilder userPublicKey(String publicKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
            this.userPublicKey = (ECPublicKey)Utils.loadPublicKey(publicKey);
            return this;
        }

        public NotificationBuilder userPublicKey(byte[] publicKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
            this.userPublicKey = (ECPublicKey)Utils.loadPublicKey(publicKey);
            return this;
        }

        public NotificationBuilder userAuth(String userAuth) {
            this.userAuth = Base64Encoder.decode(userAuth);
            return this;
        }

        public NotificationBuilder userAuth(byte[] userAuth) {
            this.userAuth = userAuth;
            return this;
        }

        public NotificationBuilder payload(byte[] payload) {
            this.payload = payload;
            return this;
        }

        public NotificationBuilder payload(String payload) {
            this.payload = payload.getBytes(StandardCharsets.UTF_8);
            return this;
        }

        public NotificationBuilder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public NotificationBuilder urgency(Urgency urgency) {
            this.urgency = urgency;
            return this;
        }

        public NotificationBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }
    }
}

