/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.notification.utils;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;

public class NotificationUtils {
    public static String getUserFullName(String userName) throws Exception {
        OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
        UserHandler userHandler = organizationService.getUserHandler();
        User user = userHandler.findUserByName(userName);
        if (user == null) {
            throw new Exception("An error occured when trying to retreive a user with username " + userName);
        }
        return user.getFullName();
    }

    public static String getNotificationActivityLink(Space space, String activityId, boolean canView) {
        String activityLink = "";
        activityLink = canView ? NotificationUtils.getActivityPermalink(activityId) : NotificationUtils.getNotificationActivityLinkForNotSpaceMembers(space);
        return activityLink;
    }

    public static String getNotificationActivityLinkForNotSpaceMembers(Space space) {
        return "/".concat(PortalContainer.getCurrentPortalContainerName()).concat("/s/").concat(space.getId());
    }

    private static String getActivityPermalink(String activityId) {
        return LinkProvider.getSingleActivityUrl((String)activityId);
    }
}

