/*
 * Decompiled with CFR 0.152.
 */
package nl.martijndwars.webpush;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import nl.martijndwars.webpush.AbstractPushService;
import nl.martijndwars.webpush.ClosableCallback;
import nl.martijndwars.webpush.Encoding;
import nl.martijndwars.webpush.HttpRequest;
import nl.martijndwars.webpush.Notification;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.jose4j.lang.JoseException;

public class PushService
extends AbstractPushService<PushService> {
    public PushService() {
    }

    public PushService(String gcmApiKey) {
        super(gcmApiKey);
    }

    public PushService(KeyPair keyPair) {
        super(keyPair);
    }

    public PushService(KeyPair keyPair, String subject) {
        super(keyPair, subject);
    }

    public PushService(String publicKey, String privateKey) throws GeneralSecurityException {
        super(publicKey, privateKey);
    }

    public PushService(String publicKey, String privateKey, String subject) throws GeneralSecurityException {
        super(publicKey, privateKey, subject);
    }

    public HttpResponse send(Notification notification, Encoding encoding) throws GeneralSecurityException, IOException, JoseException, ExecutionException, InterruptedException {
        return this.sendAsync(notification, encoding).get();
    }

    public HttpResponse send(Notification notification) throws GeneralSecurityException, IOException, JoseException, ExecutionException, InterruptedException {
        return this.send(notification, Encoding.AESGCM);
    }

    @Deprecated
    public Future<HttpResponse> sendAsync(Notification notification, Encoding encoding) throws GeneralSecurityException, IOException, JoseException {
        HttpPost httpPost = this.preparePost(notification, encoding);
        CloseableHttpAsyncClient closeableHttpAsyncClient = HttpAsyncClients.createSystem();
        closeableHttpAsyncClient.start();
        return closeableHttpAsyncClient.execute((HttpUriRequest)httpPost, (FutureCallback)new ClosableCallback(closeableHttpAsyncClient));
    }

    @Deprecated
    public Future<HttpResponse> sendAsync(Notification notification) throws GeneralSecurityException, IOException, JoseException {
        return this.sendAsync(notification, Encoding.AES128GCM);
    }

    public HttpPost preparePost(Notification notification, Encoding encoding) throws GeneralSecurityException, IOException, JoseException {
        HttpRequest request = this.prepareRequest(notification, encoding);
        HttpPost httpPost = new HttpPost(request.getUrl());
        request.getHeaders().forEach((arg_0, arg_1) -> ((HttpPost)httpPost).addHeader(arg_0, arg_1));
        if (request.getBody() != null) {
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(request.getBody()));
        }
        return httpPost;
    }
}

