/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.function.Function;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlTreeCreationException;
import org.hibernate.sql.ast.tree.from.TableGroup;

public interface FromClauseAccess {
    public TableGroup findTableGroupOnCurrentFromClause(NavigablePath var1);

    public TableGroup findTableGroup(NavigablePath var1);

    default public TableGroup findTableGroupForGetOrCreate(NavigablePath navigablePath) {
        return this.findTableGroup(navigablePath);
    }

    default public TableGroup getTableGroup(NavigablePath navigablePath) throws SqlTreeCreationException {
        TableGroup tableGroup = this.findTableGroup(navigablePath);
        if (tableGroup == null) {
            throw new SqlTreeCreationException("Could not locate TableGroup - " + navigablePath);
        }
        return tableGroup;
    }

    public void registerTableGroup(NavigablePath var1, TableGroup var2);

    default public TableGroup resolveTableGroup(NavigablePath navigablePath, Function<NavigablePath, TableGroup> creator) {
        TableGroup tableGroup = this.findTableGroupForGetOrCreate(navigablePath);
        if (tableGroup == null) {
            tableGroup = creator.apply(navigablePath);
            this.registerTableGroup(navigablePath, tableGroup);
        }
        return tableGroup;
    }
}

