/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexTemplateDataStreamConfiguration
implements JsonpSerializable {
    @Nullable
    private final Boolean hidden;
    @Nullable
    private final Boolean allowCustomRouting;
    public static final JsonpDeserializer<IndexTemplateDataStreamConfiguration> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexTemplateDataStreamConfiguration::setupIndexTemplateDataStreamConfigurationDeserializer);

    private IndexTemplateDataStreamConfiguration(Builder builder) {
        this.hidden = builder.hidden;
        this.allowCustomRouting = builder.allowCustomRouting;
    }

    public static IndexTemplateDataStreamConfiguration of(Function<Builder, ObjectBuilder<IndexTemplateDataStreamConfiguration>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean hidden() {
        return this.hidden;
    }

    @Nullable
    public final Boolean allowCustomRouting() {
        return this.allowCustomRouting;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.hidden != null) {
            generator.writeKey("hidden");
            generator.write(this.hidden.booleanValue());
        }
        if (this.allowCustomRouting != null) {
            generator.writeKey("allow_custom_routing");
            generator.write(this.allowCustomRouting.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIndexTemplateDataStreamConfigurationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::hidden, JsonpDeserializer.booleanDeserializer(), "hidden");
        op.add(Builder::allowCustomRouting, JsonpDeserializer.booleanDeserializer(), "allow_custom_routing");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndexTemplateDataStreamConfiguration> {
        @Nullable
        private Boolean hidden;
        @Nullable
        private Boolean allowCustomRouting;

        public final Builder hidden(@Nullable Boolean value) {
            this.hidden = value;
            return this;
        }

        public final Builder allowCustomRouting(@Nullable Boolean value) {
            this.allowCustomRouting = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndexTemplateDataStreamConfiguration build() {
            this._checkSingleUse();
            return new IndexTemplateDataStreamConfiguration(this);
        }
    }
}

