/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.notification.provider.builder;

import io.meeds.gamification.model.Announcement;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.AnnouncementService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.utils.Utils;
import io.meeds.social.translation.service.TranslationService;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.TimeConvertUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class ContributionAcceptedTemplateBuilder
extends AbstractTemplateBuilder {
    private final RuleService ruleService;
    private final AnnouncementService announcementService;
    private final TranslationService translationService;
    private final TemplateProvider templateProvider;
    private final boolean pushNotification;

    public ContributionAcceptedTemplateBuilder(RuleService ruleService, AnnouncementService announcementService, TranslationService translationService, TemplateProvider templateProvider, boolean pushNotification) {
        this.ruleService = ruleService;
        this.announcementService = announcementService;
        this.translationService = translationService;
        this.templateProvider = templateProvider;
        this.pushNotification = pushNotification;
    }

    protected MessageInfo makeMessage(NotificationContext ctx) {
        NotificationInfo notification = ctx.getNotificationInfo();
        String announcementId = notification.getValueOwnerParameter("REALIZATION_ID");
        if (StringUtils.isBlank((CharSequence)announcementId)) {
            return null;
        }
        Announcement announcement = this.announcementService.getAnnouncementById(Long.parseLong(announcementId));
        if (announcement == null) {
            return null;
        }
        long ruleId = announcement.getChallengeId();
        RuleDTO rule = this.ruleService.findRuleById(ruleId);
        if (rule == null || rule.isDeleted() || rule.getProgram() == null || rule.getProgram().isDeleted()) {
            return null;
        }
        Identity identity = Utils.getIdentityById(announcement.getCreator().toString());
        if (identity == null || identity.isDeleted() || !identity.isEnable()) {
            return null;
        }
        String pluginId = notification.getKey().getId();
        String language = this.getLanguage(notification);
        TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)this.templateProvider.getChannelKey(), (String)pluginId, (String)language);
        Locale userLocale = new Locale(language);
        String ruleTitle = this.translationService.getTranslationLabel("rule", ruleId, "title", userLocale);
        if (StringUtils.isBlank((CharSequence)ruleTitle)) {
            ruleTitle = rule.getTitle();
        }
        templateContext.put((Object)"RULE_TITLE", (Object)ruleTitle);
        templateContext.put((Object)"ANNOUNCEMENT_MESSAGE", (Object)announcement.getComment());
        String announcementUrl = LinkProviderUtils.getRedirectUrl((String)"view_full_activity", (String)String.valueOf(announcement.getActivityId()));
        templateContext.put((Object)"ANNOUNCEMENT_URL", (Object)announcementUrl);
        SocialNotificationUtils.addFooterAndFirstName((String)notification.getTo(), (TemplateContext)templateContext);
        templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
        templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)new Date(notification.getLastModifiedDate()), (String)"EE, dd yyyy", (Locale)userLocale, (int)TimeConvertUtils.YEAR));
        MessageInfo messageInfo = new MessageInfo();
        if (this.pushNotification) {
            messageInfo.subject(announcementUrl);
        } else {
            messageInfo.subject(TemplateUtils.processSubject((TemplateContext)templateContext));
        }
        messageInfo.body(TemplateUtils.processGroovy((TemplateContext)templateContext));
        ctx.setException(templateContext.getException());
        return messageInfo.end();
    }

    protected boolean makeDigest(NotificationContext ctx, Writer writer) {
        return false;
    }
}

