/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity;

import java.util.BitSet;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.DomainResultGraphNode;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractDiscriminatedEntityResultGraphNode
implements DomainResultGraphNode,
FetchParent {
    private final NavigablePath navigablePath;
    private final DiscriminatedAssociationModelPart graphedPart;
    private final JavaType<?> baseAssociationJtd;
    private Fetch discriminatorValueFetch;
    private Fetch keyValueFetch;
    private ImmutableFetchList fetches;

    public AbstractDiscriminatedEntityResultGraphNode(NavigablePath navigablePath, DiscriminatedAssociationModelPart graphedPart, JavaType<?> baseAssociationJtd) {
        this.navigablePath = navigablePath;
        this.graphedPart = graphedPart;
        this.baseAssociationJtd = baseAssociationJtd;
    }

    protected void afterInitialize(DomainResultCreationState creationState) {
        this.fetches = creationState.visitFetches(this);
        assert (this.fetches.size() == 2);
        this.discriminatorValueFetch = this.fetches.get(this.graphedPart.getDiscriminatorPart());
        this.keyValueFetch = this.fetches.get(this.graphedPart.getKeyPart());
    }

    public Fetch getDiscriminatorValueFetch() {
        return this.discriminatorValueFetch;
    }

    public Fetch getKeyValueFetch() {
        return this.keyValueFetch;
    }

    public JavaType<?> getBaseAssociationJtd() {
        return this.baseAssociationJtd;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.baseAssociationJtd;
    }

    @Override
    public boolean containsAnyNonScalarResults() {
        return true;
    }

    @Override
    public DiscriminatedAssociationModelPart getReferencedMappingContainer() {
        return this.graphedPart;
    }

    @Override
    public DiscriminatedAssociationModelPart getReferencedMappingType() {
        return this.graphedPart;
    }

    @Override
    public ImmutableFetchList getFetches() {
        return this.fetches;
    }

    @Override
    public Fetch findFetch(Fetchable fetchable) {
        if (this.graphedPart.getDiscriminatorPart() == fetchable) {
            return this.discriminatorValueFetch;
        }
        if (this.graphedPart.getKeyPart() == fetchable) {
            return this.keyValueFetch;
        }
        throw new IllegalArgumentException("Given Fetchable [" + fetchable + "] did not match either discriminator nor key mapping");
    }

    @Override
    public boolean hasJoinFetches() {
        return false;
    }

    @Override
    public boolean containsCollectionFetches() {
        return false;
    }

    @Override
    public void collectValueIndexesToCache(BitSet valueIndexes) {
        FetchParent.super.collectValueIndexesToCache(valueIndexes);
    }
}

