/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.format.jakartajson;

import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbException;
import java.lang.reflect.Type;
import org.hibernate.type.format.AbstractJsonFormatMapper;

public final class JsonBJsonFormatMapper
extends AbstractJsonFormatMapper {
    public static final String SHORT_NAME = "jsonb";
    private final Jsonb jsonb;

    public JsonBJsonFormatMapper() {
        this(JsonbBuilder.create());
    }

    public JsonBJsonFormatMapper(Jsonb jsonb) {
        this.jsonb = jsonb;
    }

    @Override
    public <T> T fromString(CharSequence charSequence, Type type) {
        try {
            return (T)this.jsonb.fromJson(charSequence.toString(), type);
        }
        catch (JsonbException e) {
            throw new IllegalArgumentException("Could not deserialize string to java type: " + type, e);
        }
    }

    @Override
    public <T> String toString(T value, Type type) {
        try {
            return this.jsonb.toJson(value, type);
        }
        catch (JsonbException e) {
            throw new IllegalArgumentException("Could not serialize object of java type: " + type, e);
        }
    }
}

