/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.api.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.gatein.management.api.model.ModelNumber;
import org.gatein.management.api.model.ModelString;
import org.gatein.management.api.model.ModelValue;
import org.gatein.management.core.api.model.DmrModelString;
import org.gatein.management.core.api.model.DmrModelValue;
import org.jboss.dmr.ModelNode;

class DmrModelNumber
extends DmrModelValue
implements ModelNumber {
    DmrModelNumber(ModelNode value) {
        super(value);
    }

    public int getInt() {
        if (!this.isDefined()) {
            return 0;
        }
        return this.value.asInt();
    }

    public ModelNumber set(int value) {
        this.value.set(value);
        return this;
    }

    public long getLong() {
        if (!this.isDefined()) {
            return 0L;
        }
        return this.value.asLong();
    }

    public ModelNumber set(long value) {
        this.value.set(value);
        return this;
    }

    public double getDouble() {
        if (!this.isDefined()) {
            return 0.0;
        }
        return this.value.asDouble();
    }

    public ModelNumber set(double value) {
        this.value.set(value);
        return this;
    }

    public BigInteger getBigInteger() {
        if (!this.isDefined()) {
            return null;
        }
        return this.value.asBigInteger();
    }

    public ModelNumber set(BigInteger value) {
        this.value.set(value);
        return this;
    }

    public BigDecimal getBigDecimal() {
        if (!this.isDefined()) {
            return null;
        }
        return this.value.asBigDecimal();
    }

    public ModelNumber set(BigDecimal value) {
        this.value.set(value);
        return this;
    }

    public ModelNumber.ModelNumberType getNumberType() {
        switch (this.value.getType()) {
            case INT: {
                return ModelNumber.ModelNumberType.INT;
            }
            case LONG: {
                return ModelNumber.ModelNumberType.LONG;
            }
            case DOUBLE: {
                return ModelNumber.ModelNumberType.DOUBLE;
            }
            case BIG_INTEGER: {
                return ModelNumber.ModelNumberType.BIG_INTEGER;
            }
            case BIG_DECIMAL: {
                return ModelNumber.ModelNumberType.BIG_DECIMAL;
            }
        }
        throw new IllegalStateException("Unknown number type for model node type " + this.value.getType());
    }

    @Override
    public <T extends ModelValue> T asValue(Class<T> valueType) {
        if (ModelString.class.isAssignableFrom(valueType)) {
            return (T)((ModelValue)valueType.cast(new DmrModelString(new ModelNode(this.value.asString()))));
        }
        return super.asValue(valueType);
    }
}

